/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.expiration;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.utils.AbstractRequestHandler;
import com.nuix.automate.scheduler.tus.utils.TusServletRequest;
import com.nuix.automate.scheduler.tus.utils.TusServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ExpirationRequestHandler
extends AbstractRequestHandler {
    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method) || HttpMethod.POST.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String uploadUri = servletResponse.getHeader("Location");
        if (StringUtils.isBlank((CharSequence)uploadUri)) {
            uploadUri = servletRequest.getRequestURI();
        }
        Long expirationPeriod = uploadStorageService.getUploadExpirationPeriod();
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(uploadUri, ownerKey);
        if (expirationPeriod != null && expirationPeriod > 0L && uploadInfo != null) {
            uploadInfo.updateExpiration(expirationPeriod);
            uploadStorageService.update(uploadInfo);
            servletResponse.setDateHeader("Upload-Expires", uploadInfo.getExpirationTimestamp());
        }
    }

    @Override
    public boolean isErrorHandler() {
        return true;
    }
}

