/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.tus.upload.UploadId;
import com.nuix.automate.scheduler.tus.upload.UploadType;
import com.nuix.automate.scheduler.tus.utils.Utils;
import com.nuix.automate.utils.models.internal.dataset.UploadInfoState;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.time.StopWatch;

public class UploadInfo
implements Serializable,
Cloneable {
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final List<String> fileNameKeys = Arrays.asList("filename", "name");
    private static final List<String> mimeTypeKeys = Arrays.asList("mimetype", "filetype", "type");
    private UploadId id;
    private UploadType uploadType;
    private UploadInfoState state;
    private String ownerKey;
    private Long offset;
    private Long length;
    private long lastTransferred;
    private long transferInterval;
    private int interruptedCount;
    private String uploadLocation;
    private String locationIdentifier;
    private String encodedMetadata = null;
    private String clientIpAddresses;
    private String serverIpAddress;
    private String serverName;
    private String serverRole;
    private final Long creationTimestamp = this.getCurrentTime();
    private Long expirationTimestamp;
    private long uploadDuration;
    private List<String> concatenationPartIds;
    private String uploadConcatHeaderValue;
    private Map<String, MessageDigest> digests;
    private transient StopWatch stopWatch;
    private transient int watchCount;
    private transient long initialUploadDuration;
    private transient long initialRootFileUploadDuration;

    public synchronized void startStopWatch() {
        if (this.stopWatch == null) {
            this.stopWatch = new StopWatch();
        }
        if (this.stopWatch.isStopped()) {
            this.initialUploadDuration = this.getUploadDuration();
            this.watchCount = 0;
            this.stopWatch.reset();
            this.stopWatch.start();
        }
        ++this.watchCount;
    }

    public synchronized void stopStopWatch() {
        --this.watchCount;
        this.syncUploadDurationWithStopWatch();
        if (this.watchCount <= 0 && this.stopWatch.isStarted()) {
            this.stopWatch.stop();
        }
    }

    public void syncUploadDurationWithStopWatch() {
        this.setUploadDuration(this.initialUploadDuration + this.getStopWatchTime());
    }

    @JsonIgnore
    public long getStopWatchTime() {
        return this.stopWatch.getTime();
    }

    public void setInitialRootFileUploadDuration(long initialRootFileUploadDuration) {
        this.initialRootFileUploadDuration = initialRootFileUploadDuration;
    }

    public long getInitialRootFileUploadDuration() {
        return this.initialRootFileUploadDuration;
    }

    public UploadInfo clone() {
        try {
            return (UploadInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public UploadInfo() {
    }

    public UploadInfo(HttpServletRequest servletRequest) {
        this();
        String clientIpAddress = servletRequest.getHeader("X-Forwarded-Client-IP");
        this.clientIpAddresses = clientIpAddress != null ? clientIpAddress : Utils.buildRemoteIpList(servletRequest);
        String proxyIpAddress = servletRequest.getHeader("X-Forwarded-Server-IP");
        this.serverIpAddress = proxyIpAddress != null ? proxyIpAddress : servletRequest.getLocalAddr();
        String proxyServerName = servletRequest.getHeader("X-Forwarded-Server-Name");
        this.serverName = proxyServerName != null ? proxyServerName : servletRequest.getServerName();
        String proxyRole = servletRequest.getHeader("X-Forwarded-Server-Role");
        this.serverRole = proxyRole != null ? proxyRole : SchedulerApplication.getInstance().getConfiguration().getRole().name();
    }

    @JsonIgnore
    public boolean isRoot() {
        return this.getFileName().equals(this.getRelativePath());
    }

    @JsonIgnore
    public long getRemainingLength() {
        if (this.length == null) {
            return 0L;
        }
        if (this.offset == null) {
            return this.length;
        }
        return this.length - this.offset;
    }

    public UploadInfoState getState() {
        return this.state;
    }

    public void setState(UploadInfoState state) {
        this.state = state;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String getUploadLocation() {
        return this.uploadLocation;
    }

    public void setUploadLocation(String uploadLocation) {
        this.uploadLocation = uploadLocation;
    }

    public String getLocationIdentifier() {
        return this.locationIdentifier;
    }

    public void setLocationIdentifier(String locationIdentifier) {
        this.locationIdentifier = locationIdentifier;
    }

    public Map<String, MessageDigest> getDigests() {
        return this.digests;
    }

    public void setDigests(Map<String, MessageDigest> digests) {
        this.digests = digests;
    }

    public String getEncodedMetadata() {
        return this.encodedMetadata;
    }

    public void setEncodedMetadata(String encodedMetadata) {
        this.encodedMetadata = encodedMetadata;
    }

    @JsonIgnore
    public Map<String, String> getMetadata() {
        TreeMap<String, String> metadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String valuePair : this.splitToArray(this.encodedMetadata, ",")) {
            int i;
            String[] keyValue = this.splitToArray(valuePair, "\\s");
            String value = null;
            if (keyValue.length <= 0) continue;
            String key = StringUtils.trimToEmpty((String)keyValue[0]);
            for (i = 1; keyValue.length > i && StringUtils.isBlank((CharSequence)keyValue[i]); ++i) {
            }
            if (keyValue.length > i) {
                value = this.decode(keyValue[i]);
            }
            metadata.put(key, value);
        }
        return metadata;
    }

    public boolean hasMetadata() {
        return StringUtils.isNotBlank((CharSequence)this.encodedMetadata);
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = Math.max(0L, length != null ? length : 0L);
    }

    public synchronized void removeLength(long length) {
        this.setLength(this.getLength() - length);
    }

    public boolean hasLength() {
        return this.length != null;
    }

    public boolean isUploadInProgress() {
        return !this.offset.equals(this.length);
    }

    public long getLastTransferSpeed() {
        if (this.transferInterval > 0L) {
            return this.lastTransferred / this.transferInterval;
        }
        return 0L;
    }

    public long getLastTransferred() {
        return this.lastTransferred;
    }

    public void setLastTransferred(long lastTransferred) {
        this.lastTransferred = lastTransferred;
    }

    public long getTransferInterval() {
        return this.transferInterval;
    }

    public void setTransferInterval(long transferInterval) {
        this.transferInterval = transferInterval;
    }

    public void incrementInterruptedCount() {
        ++this.interruptedCount;
    }

    public int getInterruptedCount() {
        return this.interruptedCount;
    }

    public void setInterruptedCount(int interruptedCount) {
        this.interruptedCount = interruptedCount;
    }

    public void setId(UploadId id) {
        this.id = id;
    }

    public UploadId getId() {
        return this.id;
    }

    public void setOwnerKey(String ownerKey) {
        this.ownerKey = ownerKey;
    }

    public String getOwnerKey() {
        return this.ownerKey;
    }

    public Long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public void updateExpiration(long expirationPeriod) {
        this.expirationTimestamp = this.getCurrentTime() + expirationPeriod;
    }

    public Long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getClientIpAddresses() {
        return this.clientIpAddresses;
    }

    public void setClientIpAddresses(String clientIpAddresses) {
        this.clientIpAddresses = clientIpAddresses;
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }

    public void setServerIpAddress(String serverIpAddress) {
        this.serverIpAddress = serverIpAddress;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerRole() {
        return this.serverRole;
    }

    public void setServerRole(String serverRole) {
        this.serverRole = serverRole;
    }

    public UploadType getUploadType() {
        return this.uploadType;
    }

    public void setUploadType(UploadType uploadType) {
        this.uploadType = uploadType;
    }

    public void setConcatenationPartIds(List<String> concatenationPartIds) {
        this.concatenationPartIds = concatenationPartIds;
    }

    public List<String> getConcatenationPartIds() {
        return this.concatenationPartIds;
    }

    public void setUploadConcatHeaderValue(String uploadConcatHeaderValue) {
        this.uploadConcatHeaderValue = uploadConcatHeaderValue;
    }

    public String getUploadConcatHeaderValue() {
        return this.uploadConcatHeaderValue;
    }

    public String getFileName() {
        return this.getFileName(this.getMetadata());
    }

    public String getFileName(Map<String, String> metadata) {
        for (String fileNameKey : fileNameKeys) {
            if (!metadata.containsKey(fileNameKey)) continue;
            return metadata.get(fileNameKey);
        }
        return this.getId().toString();
    }

    public String getRelativePath() {
        return this.getRelativePath(this.getMetadata());
    }

    public String getRelativePath(Map<String, String> metadata) {
        String relativePath = metadata.get("relativePath");
        if (relativePath != null && !relativePath.equalsIgnoreCase("null") && relativePath.trim().length() > 0) {
            return Paths.get(relativePath, new String[0]).normalize().toString();
        }
        return this.getFileName(metadata);
    }

    public String getFileMimeType() {
        Map<String, String> metadata = this.getMetadata();
        for (String fileNameKey : mimeTypeKeys) {
            if (!metadata.containsKey(fileNameKey)) continue;
            return metadata.get(fileNameKey);
        }
        return APPLICATION_OCTET_STREAM;
    }

    public boolean isExpired() {
        return this.expirationTimestamp != null && this.expirationTimestamp < this.getCurrentTime();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadInfo)) {
            return false;
        }
        UploadInfo that = (UploadInfo)o;
        return new EqualsBuilder().append((Object)this.getUploadType(), (Object)that.getUploadType()).append(this.getOffset(), that.getOffset()).append((Object)this.getEncodedMetadata(), (Object)that.getEncodedMetadata()).append((Object)this.getLength(), (Object)that.getLength()).append((Object)this.getId(), (Object)that.getId()).append((Object)this.getClientIpAddresses(), (Object)that.getClientIpAddresses()).append((Object)this.getExpirationTimestamp(), (Object)that.getExpirationTimestamp()).append(this.getConcatenationPartIds(), that.getConcatenationPartIds()).append((Object)this.getUploadConcatHeaderValue(), (Object)that.getUploadConcatHeaderValue()).append((Object)this.getUploadLocation(), (Object)that.getUploadLocation()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getUploadType()).append(this.getOffset()).append((Object)this.getEncodedMetadata()).append((Object)this.getLength()).append((Object)this.getId()).append((Object)this.getClientIpAddresses()).append((Object)this.getExpirationTimestamp()).append(this.getConcatenationPartIds()).append((Object)this.getUploadConcatHeaderValue()).append((Object)this.getUploadLocation()).toHashCode();
    }

    protected long getCurrentTime() {
        return new Date().getTime();
    }

    private String[] splitToArray(String value, String separatorRegex) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return new String[0];
        }
        return StringUtils.trimToEmpty((String)value).split(separatorRegex);
    }

    private String decode(String encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        return new String(Base64.getDecoder().decode(encodedValue), StandardCharsets.UTF_8);
    }

    public long getUploadDuration() {
        return this.uploadDuration;
    }

    public void setUploadDuration(long uploadDuration) {
        this.uploadDuration = uploadDuration;
    }
}

