/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload.cache;

import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.exception.UploadLocationNotFoundException;
import com.nuix.automate.scheduler.tus.exception.UploadNotFoundException;
import com.nuix.automate.scheduler.tus.upload.UploadId;
import com.nuix.automate.scheduler.tus.upload.UploadIdFactory;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadLock;
import com.nuix.automate.scheduler.tus.upload.UploadLockingService;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.upload.concatenation.UploadConcatenationService;
import com.nuix.automate.scheduler.tus.utils.InputStreamContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Map;

public class ThreadLocalCachedStorageAndLockingService
implements UploadLockingService,
UploadStorageService {
    private final ThreadLocal<WeakReference<UploadInfo>> uploadInfoCache = new ThreadLocal();
    private final UploadLockingService lockingServiceDelegate;
    private final UploadStorageService storageServiceDelegate;
    private UploadIdFactory idFactory;

    public ThreadLocalCachedStorageAndLockingService(UploadStorageService storageServiceDelegate, UploadLockingService lockingServiceDelegate) {
        this.storageServiceDelegate = storageServiceDelegate.getClass() == ThreadLocalCachedStorageAndLockingService.class ? ((ThreadLocalCachedStorageAndLockingService)storageServiceDelegate).storageServiceDelegate : storageServiceDelegate;
        this.lockingServiceDelegate = lockingServiceDelegate.getClass() == ThreadLocalCachedStorageAndLockingService.class ? ((ThreadLocalCachedStorageAndLockingService)lockingServiceDelegate).lockingServiceDelegate : lockingServiceDelegate;
    }

    @Override
    public UploadInfo getUploadInfo(UploadId id) {
        UploadInfo uploadInfo;
        WeakReference<UploadInfo> ref = this.uploadInfoCache.get();
        if (ref == null || (uploadInfo = (UploadInfo)ref.get()) == null || !id.equals(uploadInfo.getId())) {
            uploadInfo = this.storageServiceDelegate.getUploadInfo(id);
            this.uploadInfoCache.set(new WeakReference<UploadInfo>(uploadInfo));
        }
        return uploadInfo;
    }

    @Override
    public UploadInfo getUploadInfo(String uploadUrl, String ownerKey) {
        UploadInfo uploadInfo = this.getUploadInfo(this.idFactory.readUploadId(uploadUrl));
        if (uploadInfo == null || !uploadInfo.getOwnerKey().equals(ownerKey)) {
            uploadInfo = this.storageServiceDelegate.getUploadInfo(uploadUrl, ownerKey);
            this.uploadInfoCache.set(new WeakReference<UploadInfo>(uploadInfo));
        }
        return uploadInfo;
    }

    @Override
    public void update(UploadInfo uploadInfo) throws IOException, UploadNotFoundException {
        this.storageServiceDelegate.update(uploadInfo);
        this.uploadInfoCache.set(new WeakReference<UploadInfo>(uploadInfo));
    }

    @Override
    public void setIdFactory(UploadIdFactory idFactory) {
        this.idFactory = idFactory;
        this.storageServiceDelegate.setIdFactory(idFactory);
        this.lockingServiceDelegate.setIdFactory(idFactory);
    }

    @Override
    public void finalizeUpload(UploadInfo uploadInfo, Map<String, String> hashes) throws UploadLocationNotFoundException, IOException {
        this.storageServiceDelegate.finalizeUpload(uploadInfo, hashes);
        this.cleanupCache();
    }

    @Override
    public String getUploadURI() {
        return this.storageServiceDelegate.getUploadURI();
    }

    @Override
    public UploadInfo append(UploadInfo upload, InputStreamContainer inputStreamContainer) throws IOException, TusException {
        UploadInfo info = this.storageServiceDelegate.append(upload, inputStreamContainer);
        this.uploadInfoCache.set(new WeakReference<UploadInfo>(info));
        return info;
    }

    @Override
    public void setMaxUploadSize(Long maxUploadSize) {
        this.storageServiceDelegate.setMaxUploadSize(maxUploadSize);
    }

    @Override
    public long getMaxUploadSize() {
        return this.storageServiceDelegate.getMaxUploadSize();
    }

    @Override
    public UploadInfo create(UploadInfo info, String ownerKey) throws IOException, UploadLocationNotFoundException {
        UploadInfo uploadInfo = this.storageServiceDelegate.create(info, ownerKey);
        this.uploadInfoCache.set(new WeakReference<UploadInfo>(uploadInfo));
        return uploadInfo;
    }

    @Override
    public InputStream getUploadedBytes(String uploadURI, String ownerKey) throws IOException, UploadNotFoundException, UploadLocationNotFoundException {
        return this.storageServiceDelegate.getUploadedBytes(uploadURI, ownerKey);
    }

    @Override
    public InputStream getUploadedBytes(UploadId id) throws IOException, UploadNotFoundException, UploadLocationNotFoundException {
        return this.storageServiceDelegate.getUploadedBytes(id);
    }

    @Override
    public void copyUploadTo(UploadInfo info, OutputStream outputStream) throws UploadNotFoundException, IOException, UploadLocationNotFoundException {
        this.storageServiceDelegate.copyUploadTo(info, outputStream);
        this.uploadInfoCache.set(new WeakReference<UploadInfo>(info));
    }

    @Override
    public void cleanupExpiredUploads(UploadLockingService uploadLockingService) throws IOException {
        this.storageServiceDelegate.cleanupExpiredUploads(uploadLockingService);
        this.cleanupCache();
    }

    @Override
    public void removeLastNumberOfBytes(UploadInfo uploadInfo, long byteCount) throws UploadNotFoundException, IOException, UploadLocationNotFoundException {
        this.storageServiceDelegate.removeLastNumberOfBytes(uploadInfo, byteCount);
        this.uploadInfoCache.set(new WeakReference<UploadInfo>(uploadInfo));
    }

    @Override
    public void terminateUpload(UploadInfo uploadInfo) throws UploadNotFoundException, IOException {
        this.storageServiceDelegate.terminateUpload(uploadInfo);
        this.cleanupCache();
    }

    @Override
    public Long getUploadExpirationPeriod() {
        return this.storageServiceDelegate.getUploadExpirationPeriod();
    }

    @Override
    public void setUploadExpirationPeriod(Long uploadExpirationPeriod) {
        this.storageServiceDelegate.setUploadExpirationPeriod(uploadExpirationPeriod);
    }

    @Override
    public void setUploadConcatenationService(UploadConcatenationService concatenationService) {
        this.storageServiceDelegate.setUploadConcatenationService(concatenationService);
    }

    @Override
    public UploadConcatenationService getUploadConcatenationService() {
        return this.storageServiceDelegate.getUploadConcatenationService();
    }

    @Override
    public UploadLock lockUploadByUri(String requestURI) throws TusException, IOException {
        UploadLock uploadLock = this.lockingServiceDelegate.lockUploadByUri(requestURI);
        return new CachedLock(uploadLock);
    }

    @Override
    public UploadLock lockUploadById(UploadId id) throws TusException, IOException {
        UploadLock uploadLock = this.lockingServiceDelegate.lockUploadById(id);
        return new CachedLock(uploadLock);
    }

    @Override
    public void cleanupStaleLocks() throws IOException {
        this.lockingServiceDelegate.cleanupStaleLocks();
        this.cleanupCache();
    }

    @Override
    public boolean isLocked(UploadId id) {
        return this.lockingServiceDelegate.isLocked(id);
    }

    private void cleanupCache() {
        WeakReference<UploadInfo> ref = this.uploadInfoCache.get();
        if (ref != null) {
            this.uploadInfoCache.remove();
            ref.clear();
        }
    }

    class CachedLock
    implements UploadLock {
        private final UploadLock delegate;

        CachedLock(UploadLock delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getUploadUri() {
            return this.delegate != null ? this.delegate.getUploadUri() : null;
        }

        @Override
        public void release() {
            if (this.delegate != null) {
                this.delegate.release();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.delegate != null) {
                this.delegate.close();
            }
            ThreadLocalCachedStorageAndLockingService.this.cleanupCache();
        }
    }
}

