/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload.concatenation;

import com.nuix.automate.scheduler.tus.exception.UploadLocationNotFoundException;
import com.nuix.automate.scheduler.tus.exception.UploadNotFoundException;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class UploadInputStreamEnumeration
implements Enumeration<InputStream> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UploadInputStreamEnumeration.class);
    private final UploadStorageService uploadStorageService;
    private Iterator<UploadInfo> uploadIterator;
    private InputStream currentInputStream = null;

    public UploadInputStreamEnumeration(List<UploadInfo> uploadList, UploadStorageService uploadStorageService) {
        ArrayList<UploadInfo> uploads = new ArrayList<UploadInfo>(uploadList);
        this.uploadStorageService = uploadStorageService;
        this.uploadIterator = uploads.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        this.currentInputStream = this.uploadIterator != null && this.uploadIterator.hasNext() ? this.getNextInputStream() : null;
        if (this.currentInputStream == null) {
            this.uploadIterator = null;
            return false;
        }
        return true;
    }

    @Override
    public InputStream nextElement() {
        return this.currentInputStream;
    }

    private InputStream getNextInputStream() {
        InputStream is = null;
        UploadInfo info = this.uploadIterator.next();
        if (info != null) {
            try {
                is = this.uploadStorageService.getUploadedBytes(info.getId());
            }
            catch (UploadLocationNotFoundException | UploadNotFoundException | IOException ex) {
                LOGGER.error("Error while retrieving input stream for upload with ID " + String.valueOf(info.getId()), (Throwable)ex);
                is = null;
            }
        }
        return is;
    }
}

