/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload.scheduler;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.tus.exception.UploadLocationNotFoundException;
import com.nuix.automate.scheduler.tus.upload.UploadId;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadLockingService;
import com.nuix.automate.scheduler.tus.upload.scheduler.SchedulerStorageService;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public class ProxyStorageService
extends SchedulerStorageService {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ProxyStorageService.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final Map<String, Map<String, MessageDigest>> uploadInfosDigests;

    public void clearUploadIdDigests(String uploadId) {
        this.uploadInfosDigests.remove(uploadId);
    }

    public Map<String, String> getUploadIdDigests(String uploadId) {
        TreeMap<String, String> hashes = new TreeMap<String, String>();
        Map<String, MessageDigest> digests = this.getUploadInfoDigests(uploadId);
        for (String algo : digests.keySet()) {
            MessageDigest digest = digests.get(algo);
            String hash = DatatypeConverter.printHexBinary((byte[])digest.digest());
            hashes.put(algo, hash);
        }
        return hashes;
    }

    private Map<String, MessageDigest> initializeHashes() {
        TreeMap<String, MessageDigest> digests = new TreeMap<String, MessageDigest>();
        String hashAlgorithms = this.schedulerApplication.getConfiguration().getUploadHashAlgorithms();
        if (StringUtils.isNotBlank((CharSequence)hashAlgorithms) && !hashAlgorithms.toLowerCase().contains("none")) {
            for (String algorithm : hashAlgorithms.split(",")) {
                String normalizedAlgorithmName = algorithm.replace("[", "").replace("]", "").trim();
                normalizedAlgorithmName = normalizedAlgorithmName.replace("SHA", "SHA-").replace("--", "-");
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(normalizedAlgorithmName);
                    digests.put(normalizedAlgorithmName.replace("-", ""), messageDigest);
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.error("Algorithm " + normalizedAlgorithmName + " not supported", (Throwable)e);
                }
            }
        }
        return digests;
    }

    private synchronized Map<String, MessageDigest> getUploadInfoDigests(String id) {
        Map<String, MessageDigest> uploadInfoDigests = this.uploadInfosDigests.get(id);
        if (uploadInfoDigests == null) {
            uploadInfoDigests = this.initializeHashes();
            this.uploadInfosDigests.put(id, uploadInfoDigests);
        }
        return uploadInfoDigests;
    }

    public ProxyStorageService(SchedulerApplication schedulerApplication) {
        super(schedulerApplication);
        this.schedulerApplication = schedulerApplication;
        this.uploadInfosDigests = new HashMap<String, Map<String, MessageDigest>>();
    }

    @Override
    public UploadInfo getUploadInfo(UploadId id) {
        UploadInfo uploadInfo = this.schedulerApplication.getProxyResource().getProxyWorker().getUploadInfo(id);
        Map<String, MessageDigest> digests = this.getUploadInfoDigests(id.toString());
        uploadInfo.setDigests(digests);
        return uploadInfo;
    }

    @Override
    public UploadInfo create(UploadInfo uploadInfo, String ownerKey) throws IOException, UploadLocationNotFoundException {
        throw new NotImplementedException("Proxy Storage cannot create uploads");
    }

    @Override
    public void update(UploadInfo uploadInfo) {
        this.schedulerApplication.getProxyResource().getProxyWorker().updateUploadInfo(uploadInfo);
        if (this.uploadInfosDigests.containsKey(uploadInfo.getId().toString())) {
            this.uploadInfosDigests.put(uploadInfo.getId().toString(), uploadInfo.getDigests());
        }
    }

    @Override
    public void terminateUpload(UploadInfo info) throws IOException {
        throw new NotImplementedException("Proxy Storage cannot terminate uploads");
    }

    @Override
    public void cleanupExpiredUploads(UploadLockingService uploadLockingService) throws IOException {
        throw new NotImplementedException("Proxy Storage cannot cleanup expired uploads");
    }

    @Override
    public void finalizeUpload(UploadInfo uploadInfo, Map<String, String> hashes) throws UploadLocationNotFoundException, IOException {
        throw new NotImplementedException("Proxy Storage cannot finalize uploads");
    }
}

