/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload.scheduler;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.tus.exception.InvalidUploadOffsetException;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.exception.UploadLocationNotFoundException;
import com.nuix.automate.scheduler.tus.exception.UploadNotFoundException;
import com.nuix.automate.scheduler.tus.upload.UploadId;
import com.nuix.automate.scheduler.tus.upload.UploadIdFactory;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadLockingService;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.upload.UploadType;
import com.nuix.automate.scheduler.tus.upload.concatenation.UploadConcatenationService;
import com.nuix.automate.scheduler.tus.upload.scheduler.SchedulerLockingService;
import com.nuix.automate.scheduler.tus.utils.InputStreamContainer;
import com.nuix.automate.scheduler.utils.DatasetUtils;
import com.nuix.automate.scheduler.utils.FileInfoCache;
import com.nuix.automate.utils.general.FilePathUtils;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ThreadPoolUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.FileInfo;
import com.nuix.automate.utils.models.internal.dataset.UploadInfoState;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import jakarta.xml.bind.DatatypeConverter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Exchanger;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SchedulerStorageService
implements UploadStorageService {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SchedulerStorageService.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private Long uploadExpirationPeriod = null;
    private final SchedulerApplication schedulerApplication;
    private final Map<String, UploadInfo> uploadInfos;
    private UploadIdFactory idFactory;
    private UploadConcatenationService uploadConcatenationService;
    private SchedulerLockingService uploadLockingService;
    private final ScheduledThreadPoolExecutor uploadObserverThreadPool;

    public SchedulerStorageService(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.uploadObserverThreadPool = ThreadPoolUtils.createScheduledThreadPoolExecutor((String)"UploadObserver", (int)1);
        this.uploadInfos = new ConcurrentHashMap<String, UploadInfo>();
    }

    public Collection<UploadInfo> getUploadInfos() {
        return this.uploadInfos.values();
    }

    public void addUploadInfo(UploadInfo uploadInfo) {
        this.uploadInfos.put(uploadInfo.getId().toString(), uploadInfo);
    }

    private void removeUploadInfo(UploadId id) {
        this.uploadInfos.remove(id.toString());
    }

    public List<UploadInfo> getDatasetUploadInfos(String datasetId) {
        return this.uploadInfos.values().stream().filter(uploadInfo -> datasetId.equals(uploadInfo.getLocationIdentifier())).collect(Collectors.toList());
    }

    @Override
    public void setIdFactory(UploadIdFactory idFactory) {
        Validate.notNull((Object)idFactory, (String)"The IdFactory cannot be null", (Object[])new Object[0]);
        this.idFactory = idFactory;
    }

    @Override
    public void setMaxUploadSize(Long maxUploadSize) {
    }

    @Override
    public long getMaxUploadSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public UploadInfo getUploadInfo(String uploadUrl, String ownerKey) {
        UploadId id = this.idFactory.readUploadId(uploadUrl);
        UploadInfo uploadInfo = this.getUploadInfo(id);
        if (uploadInfo == null || !uploadInfo.getOwnerKey().equals(ownerKey)) {
            return null;
        }
        return uploadInfo;
    }

    @Override
    public UploadInfo getUploadInfo(UploadId id) {
        return this.uploadInfos.get(id.toString());
    }

    @Override
    public String getUploadURI() {
        return this.idFactory.getUploadURI();
    }

    @Override
    public UploadInfo create(UploadInfo uploadInfo, String ownerKey) throws IOException, UploadLocationNotFoundException {
        Path filePath = SchedulerStorageService.getDraftFileLocation(uploadInfo);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("File will be stored at " + filePath.toString());
        }
        UploadId id = this.createNewId();
        uploadInfo.setId(id);
        uploadInfo.setOffset(0L);
        uploadInfo.setOwnerKey(ownerKey);
        this.addUploadInfo(uploadInfo);
        Path bytesPath = this.getBytesPath(uploadInfo);
        Path bytesTempFolder = bytesPath.getParent();
        if (!Files.exists(bytesTempFolder, new LinkOption[0])) {
            Files.createDirectories(bytesTempFolder, new FileAttribute[0]);
        }
        Files.createFile(bytesPath, new FileAttribute[0]);
        return uploadInfo;
    }

    @Override
    public void update(UploadInfo uploadInfo) {
        if (this.uploadInfos.containsKey(uploadInfo.getId().toString())) {
            this.uploadInfos.put(uploadInfo.getId().toString(), uploadInfo);
            if (this.uploadExpirationPeriod != null) {
                uploadInfo.updateExpiration(this.uploadExpirationPeriod);
            }
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_UPLOAD_INFOS, uploadInfo.getLocationIdentifier());
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_UPLOAD_INFOS, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadInfo append(final UploadInfo info, final InputStreamContainer inputStreamContainer) throws IOException, TusException {
        if (info != null) {
            info.setState(UploadInfoState.ACTIVE);
            Runnable uploadObserver = new Runnable(){
                long lastObservedDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                long lastRead;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long read = inputStreamContainer.getBytesRead();
                    long transferred = read - this.lastRead;
                    this.lastRead = read;
                    if (transferred <= 0L) {
                        return;
                    }
                    1 var5_3 = this;
                    synchronized (var5_3) {
                        long currentDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                        long millisElapsed = currentDate - this.lastObservedDate;
                        long newOffset = info.getOffset() + transferred;
                        info.setOffset(newOffset);
                        if (info.getLastTransferred() == 0L || millisElapsed >= 5000L) {
                            info.setLastTransferred(transferred);
                            info.setTransferInterval(millisElapsed);
                            this.lastObservedDate = currentDate;
                        }
                        info.syncUploadDurationWithStopWatch();
                        SchedulerStorageService.this.update(info);
                    }
                }
            };
            ScheduledFuture<?> scheduledUploadObserverTask = this.uploadObserverThreadPool.scheduleWithFixedDelay(uploadObserver, 5L, 5L, TimeUnit.SECONDS);
            Path bytesPath = this.getBytesPathExists(info);
            Long offset = info.getOffset();
            try (ReadableByteChannel uploadedByteChannel = Channels.newChannel(inputStreamContainer.getContentInputStream());
                 FileChannel fileChannel = FileChannel.open(bytesPath, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
                info.startStopWatch();
                this.update(info);
                try {
                    int capacity;
                    fileChannel.lock();
                    if (!offset.equals(fileChannel.size())) {
                        throw new InvalidUploadOffsetException("The upload offset does not correspond to the written bytes. You can only append to the end of an upload");
                    }
                    int minSizeForParallelWrite = 65536;
                    int bufferCount = 2;
                    long remaining = info.getRemainingLength();
                    if (remaining < (long)minSizeForParallelWrite) {
                        capacity = (int)remaining;
                    } else {
                        Integer uploadBufferSizeMax = this.schedulerApplication.getConfiguration().getUploadBufferMaxSize();
                        if (uploadBufferSizeMax == null || uploadBufferSizeMax <= 0) {
                            uploadBufferSizeMax = 8192;
                        }
                        int maxCapacity = (int)Math.min((long)uploadBufferSizeMax.intValue() * 1024L, Integer.MAX_VALUE);
                        capacity = (int)Math.min(remaining / (long)bufferCount, (long)maxCapacity);
                    }
                    int minCapacity = 8;
                    if (capacity < minCapacity) {
                        capacity = minCapacity;
                    }
                    capacity = capacity / 8 * 8;
                    if (this.schedulerApplication.getConfiguration().getUploadWithNullWriter()) {
                        LOGGER.warn("Uploading with NULL Writer");
                        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
                        while (SchedulerStorageService.fullReadIntoBuffer(uploadedByteChannel, buffer) != -1) {
                            buffer.clear();
                        }
                    } else if (remaining > (long)minSizeForParallelWrite && this.schedulerApplication.getConfiguration().getUploadWithSeparateWriteThread()) {
                        LOGGER.info("Uploading with Parallel Write Thread");
                        SchedulerStorageService.uploadWithSeparateWriteThread(fileChannel, uploadedByteChannel, capacity, info.getDigests().values());
                    } else {
                        LOGGER.info("Uploading with Single Thread Sequentially");
                        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
                        byte[] digestBuffer = new byte[Math.min(capacity, 8192)];
                        while (SchedulerStorageService.fullReadIntoBuffer(uploadedByteChannel, buffer) != -1) {
                            buffer.flip();
                            if (info.getDigests().size() > 0) {
                                SchedulerStorageService.updateDigestsWithByteBuffer(info.getDigests().values(), buffer.asReadOnlyBuffer(), digestBuffer);
                            }
                            while (buffer.hasRemaining()) {
                                fileChannel.write(buffer);
                            }
                            buffer.compact();
                        }
                    }
                    fileChannel.force(true);
                    uploadObserver.run();
                }
                catch (Exception ex) {
                    LOGGER.error("Exception thrown while uploading", (Throwable)ex);
                    fileChannel.force(true);
                    info.setOffset(fileChannel.size());
                    throw ex;
                }
            }
            finally {
                info.stopStopWatch();
                scheduledUploadObserverTask.cancel(false);
                long newOffset = info.getOffset();
                long uploadSize = newOffset - offset;
                double uploadSpeed = (double)uploadSize / (double)info.getStopWatchTime();
                double overallUploadSpeed = (double)newOffset / (double)info.getUploadDuration();
                LOGGER.info("Upload " + String.valueOf(info.getId()) + " transferred " + uploadSize + " bytes for " + info.getStopWatchTime() / 1000L + " s at " + Math.floor(uploadSpeed) + " KB/s. Overall size " + newOffset + " bytes at " + Math.floor(overallUploadSpeed) + " KB/s");
                if (info.isUploadInProgress()) {
                    info.incrementInterruptedCount();
                }
                info.setState(UploadInfoState.IDLE);
                this.update(info);
            }
        }
        return info;
    }

    public static void uploadWithSeparateWriteThread(FileChannel fileChannel, ReadableByteChannel readableByteChannel, final int bufferCapacity, final Collection<MessageDigest> digests) throws IOException {
        final SynchronousQueue hashQueue = new SynchronousQueue();
        final Phaser phaser = new Phaser(2);
        Thread hashThread = new Thread(new Runnable(){
            private final byte[] digestBuffer;
            {
                this.digestBuffer = new byte[Math.min(bufferCapacity, 8192)];
            }

            @Override
            public void run() {
                try {
                    ByteBuffer buffer;
                    while ((buffer = (ByteBuffer)hashQueue.take()).capacity() != 0) {
                        if (digests.size() > 0) {
                            SchedulerStorageService.updateDigestsWithByteBuffer(digests, buffer, this.digestBuffer);
                        }
                        phaser.arrive();
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.error("Error updating digest", (Throwable)e);
                }
            }
        });
        hashThread.setName("Automate Upload Hash Thread");
        hashThread.start();
        Exchanger<ByteBuffer> bufferExchanger = new Exchanger<ByteBuffer>();
        Thread writeThread = new Thread(() -> {
            try {
                ByteBuffer buffer = null;
                while (true) {
                    buffer = bufferExchanger.exchange(buffer);
                    hashQueue.put(buffer.asReadOnlyBuffer());
                    if (buffer.capacity() != 0) {
                        while (buffer.hasRemaining()) {
                            fileChannel.write(buffer);
                        }
                        phaser.arriveAndAwaitAdvance();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException | InterruptedException e) {
                LOGGER.error("Error writing to file channel", (Throwable)e);
            }
        });
        writeThread.setName("Automate Upload Write Thread");
        writeThread.start();
        try {
            int read;
            ByteBuffer buffer = null;
            do {
                if (buffer == null) {
                    buffer = ByteBuffer.allocateDirect(bufferCapacity);
                }
                buffer.clear();
                read = SchedulerStorageService.fullReadIntoBuffer(readableByteChannel, buffer);
                buffer.flip();
                buffer = bufferExchanger.exchange(buffer);
            } while (read != -1);
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
        }
        try {
            bufferExchanger.exchange(ByteBuffer.allocate(0));
            writeThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
        }
    }

    private static void updateDigestsWithByteBuffer(Collection<MessageDigest> digests, ByteBuffer buffer, byte[] tempArray) {
        int chunk;
        for (int len = buffer.remaining(); len > 0; len -= chunk) {
            chunk = Math.min(len, tempArray.length);
            buffer.get(tempArray, 0, chunk);
            for (MessageDigest digest : digests) {
                digest.update(tempArray, 0, chunk);
            }
        }
    }

    private static int fullReadIntoBuffer(ReadableByteChannel readableByteChannel, ByteBuffer buffer) throws IOException {
        int currentRead;
        int read = 0;
        do {
            try {
                currentRead = readableByteChannel.read(buffer);
            }
            catch (EOFException e) {
                currentRead = -1;
            }
            if (currentRead <= 0 && read != 0) continue;
            read += currentRead;
        } while (currentRead != -1 && buffer.hasRemaining());
        return read;
    }

    @Override
    public void removeLastNumberOfBytes(UploadInfo info, long byteCount) throws IOException, UploadLocationNotFoundException {
        if (info != null && byteCount > 0L) {
            Path bytesPath = this.getBytesPathExists(info);
            try (FileChannel file = FileChannel.open(bytesPath, StandardOpenOption.WRITE);){
                file.lock();
                file.truncate(file.size() - byteCount);
                file.force(true);
                long newOffset = file.size();
                info.setOffset(newOffset);
            }
        }
    }

    @Override
    public void terminateUpload(UploadInfo info) throws IOException {
        if (info != null) {
            try {
                Path bytesPath = this.getBytesPath(info);
                FileUtils.deleteRecursively((Path)bytesPath);
            }
            catch (UploadLocationNotFoundException uploadLocationNotFoundException) {
            }
            finally {
                this.uploadLockingService.terminateLock(info.getId());
                this.removeUploadInfo(info.getId());
                ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_UPLOAD_INFOS, info.getLocationIdentifier());
                ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_UPLOAD_INFOS, "");
            }
        }
    }

    public void setUploadLockingService(SchedulerLockingService schedulerLockingService) {
        this.uploadLockingService = schedulerLockingService;
    }

    @Override
    public Long getUploadExpirationPeriod() {
        return this.uploadExpirationPeriod;
    }

    @Override
    public void setUploadExpirationPeriod(Long uploadExpirationPeriod) {
        this.uploadExpirationPeriod = uploadExpirationPeriod;
    }

    @Override
    public void setUploadConcatenationService(UploadConcatenationService concatenationService) {
        Validate.notNull((Object)concatenationService);
        this.uploadConcatenationService = concatenationService;
    }

    @Override
    public UploadConcatenationService getUploadConcatenationService() {
        return this.uploadConcatenationService;
    }

    @Override
    public InputStream getUploadedBytes(String uploadURI, String ownerKey) throws IOException, UploadNotFoundException, UploadLocationNotFoundException {
        UploadId id = this.idFactory.readUploadId(uploadURI);
        UploadInfo uploadInfo = this.getUploadInfo(uploadURI, ownerKey);
        if (uploadInfo == null) {
            throw new UploadNotFoundException("The upload with id " + String.valueOf(id) + " could not be found for owner " + ownerKey);
        }
        return this.getUploadedBytes(id);
    }

    @Override
    public InputStream getUploadedBytes(UploadId id) throws IOException, UploadLocationNotFoundException, UploadNotFoundException {
        InputStream inputStream;
        UploadInfo info = this.getUploadInfo(id);
        if (UploadType.CONCATENATED == info.getUploadType() && this.uploadConcatenationService != null) {
            inputStream = this.uploadConcatenationService.getConcatenatedBytes(info);
        } else {
            Path bytesPath = this.getBytesPathExists(info);
            inputStream = Channels.newInputStream(FileChannel.open(bytesPath, StandardOpenOption.READ));
        }
        return inputStream;
    }

    @Override
    public void copyUploadTo(UploadInfo info, OutputStream outputStream) throws IOException, UploadLocationNotFoundException, UploadNotFoundException {
        List<UploadInfo> uploads = this.getUploads(info);
        try (WritableByteChannel outputChannel = Channels.newChannel(outputStream);){
            for (UploadInfo upload : uploads) {
                if (upload == null) {
                    LOGGER.warn("We cannot copy the bytes of an upload that does not exist");
                    continue;
                }
                if (upload.isUploadInProgress()) {
                    LOGGER.warn("We cannot copy the bytes of upload " + String.valueOf(upload.getId()) + " because it is still in progress");
                    continue;
                }
                Path bytesPath = this.getBytesPathExists(upload);
                FileChannel file = FileChannel.open(bytesPath, StandardOpenOption.READ);
                try {
                    file.transferTo(0L, upload.getLength(), outputChannel);
                }
                finally {
                    if (file == null) continue;
                    file.close();
                }
            }
        }
    }

    @Override
    public void cleanupExpiredUploads(UploadLockingService uploadLockingService) throws IOException {
        ArrayList<UploadInfo> expiredUploads = new ArrayList<UploadInfo>();
        for (UploadInfo uploadInfo : this.uploadInfos.values()) {
            if (!uploadInfo.isExpired() || uploadInfo.getState() != UploadInfoState.IDLE || uploadLockingService.isLocked(uploadInfo.getId())) continue;
            expiredUploads.add(uploadInfo);
        }
        for (UploadInfo expiredUpload : expiredUploads) {
            this.terminateUpload(expiredUpload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeUpload(UploadInfo uploadInfo, Map<String, String> hashes) throws UploadLocationNotFoundException, IOException {
        String fileLastModified;
        EventType.Type eventType;
        boolean overwriteExisting;
        Path bytesPath = this.getBytesPathExists(uploadInfo);
        Path filePath = SchedulerStorageService.getDraftFileLocation(uploadInfo);
        Map<String, String> metadata = uploadInfo.getMetadata();
        boolean overwrite = Boolean.parseBoolean(metadata.get("overwrite"));
        boolean bl = overwriteExisting = overwrite && Files.exists(filePath, new LinkOption[0]);
        if (overwriteExisting) {
            eventType = EventType.Type.DATA_SET_FILE_OVERWROTE;
            Files.move(bytesPath, filePath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            eventType = EventType.Type.DATA_SET_FILE_UPLOADED;
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Files.move(bytesPath, filePath, new CopyOption[0]);
        }
        String fileName = uploadInfo.getFileName(metadata);
        String relativePath = uploadInfo.getRelativePath(metadata);
        FileInfo fileInfo = new FileInfo(fileName);
        fileInfo.setRelativePath(relativePath, true);
        fileInfo.setAddedBy(uploadInfo.getOwnerKey());
        fileInfo.setClientIpAddresses(uploadInfo.getClientIpAddresses());
        fileInfo.setServerIpAddress(uploadInfo.getServerIpAddress());
        fileInfo.setServerName(uploadInfo.getServerName());
        fileInfo.setServerRole(uploadInfo.getServerRole());
        fileInfo.setUploadDuration(uploadInfo.getUploadDuration());
        fileInfo.setSize(uploadInfo.getLength().longValue());
        fileInfo.incrementFileCount();
        String datasetId = uploadInfo.getLocationIdentifier();
        fileInfo.setDatasetId(datasetId);
        fileInfo.computeId();
        if (hashes == null) {
            hashes = uploadInfo.getDigests().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DatatypeConverter.printHexBinary((byte[])((MessageDigest)entry.getValue()).digest())));
        }
        fileInfo.setHashes(hashes);
        StringBuilder eventDetails = new StringBuilder();
        eventDetails.append(this.iu.getFormattedString("DatasetResource.AuditLog.File.Name", (Object)fileName));
        eventDetails.append("\n");
        eventDetails.append(this.iu.getFormattedString("DatasetResource.AuditLog.File.RelativePath", (Object)relativePath));
        eventDetails.append("\n");
        eventDetails.append(this.iu.getFormattedString("DatasetResource.AuditLog.File.Size", (Object)FormattingUtils.sizeToDisplaySize((long)uploadInfo.getLength())));
        for (String hashAlgorithm : hashes.keySet()) {
            String hash = hashes.get(hashAlgorithm);
            eventDetails.append("\n");
            eventDetails.append(this.iu.getFormattedString("DatasetResource.AuditLog.File.Hash", (Object[])new String[]{hashAlgorithm, hash}));
        }
        this.schedulerApplication.getWebhookWorker().triggerEvent(eventType, fileInfo, uploadInfo.getOwnerKey());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), uploadInfo.getLocationIdentifier(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), uploadInfo.getOwnerKey(), eventType, eventDetails.toString(), uploadInfo.getClientIpAddresses().toString()));
        long lastModified = Files.getLastModifiedTime(filePath, new LinkOption[0]).toMillis();
        fileInfo.setAddedDate(Long.valueOf(lastModified));
        if (!fileInfo.isRoot()) {
            String rootFileRelativePath = FilePathUtils.getRelativePathSplit((String)fileInfo.getRelativePath())[0];
            String rootFileId = FileInfo.computeId((String)fileInfo.getDatasetId(), (String)rootFileRelativePath);
            fileInfo.setRootFileId(rootFileId);
            SchedulerStorageService schedulerStorageService = this;
            synchronized (schedulerStorageService) {
                FileInfo oldFileInfo;
                FileInfo rootFileInfo = DatasetUtils.getDatasetUtils(this.schedulerApplication).updateAndGetRootFileInfo(fileInfo);
                if (overwriteExisting && (oldFileInfo = FileInfoCache.getInstance().getFileInfo(fileInfo.getId())) != null) {
                    rootFileInfo.setSize(rootFileInfo.getSize() - oldFileInfo.getSize());
                    rootFileInfo.decrementFileCount();
                }
                this.schedulerApplication.getDatasetResource().addOrUpdateFileInfo(rootFileInfo);
                if (this.schedulerApplication.getClientMatterDao().updateFileInfo(rootFileInfo) == 0) {
                    this.schedulerApplication.getClientMatterDao().addFileInfo(rootFileInfo);
                }
            }
        }
        if (overwriteExisting) {
            this.schedulerApplication.getDatasetResource().addOrUpdateFileInfo(fileInfo);
            if (this.schedulerApplication.getClientMatterDao().updateFileInfo(fileInfo) == 0) {
                this.schedulerApplication.getClientMatterDao().addFileInfo(fileInfo);
            }
        } else {
            this.schedulerApplication.getDatasetResource().addOrUpdateFileInfo(fileInfo);
            this.schedulerApplication.getClientMatterDao().addFileInfo(fileInfo);
        }
        if ((fileLastModified = metadata.get("lastModified")) != null) {
            Files.setLastModifiedTime(filePath, FileTime.fromMillis(Long.parseLong(fileLastModified)));
        }
        this.terminateUpload(uploadInfo);
        Dataset dataset = this.schedulerApplication.getDatasetResource().getDataset(datasetId);
        dataset.setLastModifiedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        this.schedulerApplication.getSchedulerConfigurationDao().updateDataset(dataset);
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, dataset.getMatterId());
        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, datasetId);
        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, "");
    }

    private List<UploadInfo> getUploads(UploadInfo info) throws IOException, UploadNotFoundException {
        List<UploadInfo> uploads;
        if (info != null && UploadType.CONCATENATED == info.getUploadType() && this.uploadConcatenationService != null) {
            this.uploadConcatenationService.merge(info);
            uploads = this.uploadConcatenationService.getPartialUploads(info);
        } else {
            uploads = Collections.singletonList(info);
        }
        return uploads;
    }

    public static Path getTempFileLocation(UploadInfo uploadInfo) throws FileTraversalException {
        return FileUtils.safePathAppend((String)uploadInfo.getUploadLocation(), (String[])new String[]{"InProgress", uploadInfo.getId().toString()});
    }

    public static Path getDraftFileLocation(UploadInfo uploadInfo) throws FileTraversalException {
        return FileUtils.safeResolveParent((String)uploadInfo.getUploadLocation(), (String[])new String[]{"Draft", uploadInfo.getRelativePath()});
    }

    private Path getBytesPath(UploadInfo uploadInfo) throws UploadLocationNotFoundException, FileTraversalException {
        if (uploadInfo != null && StringUtils.isNotBlank((CharSequence)uploadInfo.getUploadLocation())) {
            return SchedulerStorageService.getTempFileLocation(uploadInfo);
        }
        throw new UploadLocationNotFoundException("The upload info does not have an upload location.");
    }

    private Path getBytesPathExists(UploadInfo uploadInfo) throws UploadLocationNotFoundException, FileTraversalException {
        Path bytesPath = this.getBytesPath(uploadInfo);
        if (Files.exists(bytesPath, new LinkOption[0])) {
            return bytesPath;
        }
        throw new UploadLocationNotFoundException("The upload location was not found.");
    }

    private synchronized UploadId createNewId() {
        UploadId id;
        while (this.getUploadInfo(id = this.idFactory.createId()) != null) {
        }
        return id;
    }
}

