/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.utils;

import com.nuix.automate.scheduler.tus.TusExtension;
import com.nuix.automate.scheduler.tus.utils.HttpChunkedEncodingInputStream;
import com.nuix.automate.scheduler.tus.utils.InputStreamContainer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;

public class TusServletRequest
extends HttpServletRequestWrapper
implements InputStreamContainer {
    private CountingInputStream countingInputStream;
    private InputStream contentInputStream;
    private final boolean isChunkedTransferDecodingEnabled;
    private final Map<String, List<String>> trailerHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final Set<String> processedBySet = new TreeSet<String>();

    public TusServletRequest(HttpServletRequest request, boolean isChunkedTransferDecodingEnabled) {
        super(request);
        this.isChunkedTransferDecodingEnabled = isChunkedTransferDecodingEnabled;
    }

    public TusServletRequest(HttpServletRequest request) {
        this(request, false);
    }

    @Override
    public InputStream getContentInputStream() throws IOException {
        if (this.contentInputStream == null) {
            this.contentInputStream = super.getInputStream();
            boolean isChunked = this.hasChunkedTransferEncoding();
            if (isChunked && this.isChunkedTransferDecodingEnabled) {
                this.contentInputStream = new HttpChunkedEncodingInputStream(this.contentInputStream, this.trailerHeaders);
            }
            this.countingInputStream = new CountingInputStream(this.contentInputStream);
            this.contentInputStream = this.countingInputStream;
        }
        return this.contentInputStream;
    }

    @Override
    public long getBytesRead() {
        if (this.countingInputStream == null) {
            return 0L;
        }
        return this.countingInputStream.getByteCount();
    }

    public String getHeader(String name) {
        List<String> values;
        String value = super.getHeader(name);
        if (StringUtils.isBlank((CharSequence)value) && this.trailerHeaders.containsKey(name) && (values = this.trailerHeaders.get(name)) != null && !values.isEmpty()) {
            value = values.get(0);
        }
        return value;
    }

    public boolean isProcessedBy(TusExtension processor) {
        return this.processedBySet.contains(processor.getName());
    }

    public void addProcessor(TusExtension processor) {
        this.processedBySet.add(processor.getName());
    }

    private boolean hasChunkedTransferEncoding() {
        return StringUtils.equalsIgnoreCase((CharSequence)"chunked", (CharSequence)this.getHeader("Transfer-Encoding"));
    }
}

