/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.utils;

import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Utils.class);
    private static final int LOCK_FILE_RETRY_COUNT = 3;
    private static final long LOCK_FILE_SLEEP_TIME = 500L;

    private Utils() {
    }

    public static String getHeader(HttpServletRequest request, String header) {
        return StringUtils.trimToEmpty((String)request.getHeader(header));
    }

    public static Long getLongHeader(HttpServletRequest request, String header) {
        try {
            return Long.valueOf(Utils.getHeader(request, header));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static String buildRemoteIpList(HttpServletRequest servletRequest) {
        String ipAddresses = ResourceUtils.getRemoteIpAddresses((HttpServletRequest)servletRequest);
        return ipAddresses;
    }

    public static List<String> parseConcatenationIDsFromHeader(String uploadConcatValue) {
        String idString = StringUtils.substringAfter((String)uploadConcatValue, (String)";");
        return new LinkedList<String>(Arrays.asList(StringUtils.trimToEmpty((String)idString).split("\\s")));
    }

    public static <T> T readSerializable(Path path, Class<T> clazz) throws IOException {
        T info;
        block15: {
            info = null;
            if (path != null) {
                try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
                    if (Utils.lockFileShared(channel) != null) {
                        try (ObjectInputStream ois = new ObjectInputStream(Channels.newInputStream(channel));){
                            info = clazz.cast(ois.readObject());
                            break block15;
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                        break block15;
                    }
                    throw new IOException("Unable to lock file " + String.valueOf(path));
                }
            }
        }
        return info;
    }

    public static void writeSerializable(Serializable object, Path path) throws IOException {
        block18: {
            if (path != null) {
                try (FileChannel channel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    if (Utils.lockFileExclusively(channel) != null) {
                        try (BufferedOutputStream buffer = new BufferedOutputStream(Channels.newOutputStream(channel));
                             ObjectOutputStream output = new ObjectOutputStream(buffer);){
                            output.writeObject(object);
                            break block18;
                        }
                    }
                    throw new IOException("Unable to lock file " + String.valueOf(path));
                }
            }
        }
    }

    public static FileLock lockFileExclusively(FileChannel channel) throws IOException {
        return Utils.lockFile(channel, false);
    }

    public static FileLock lockFileShared(FileChannel channel) throws IOException {
        return Utils.lockFile(channel, true);
    }

    public static void sleep(long sleepTimeMillis) {
        try {
            Thread.sleep(sleepTimeMillis);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Sleep was interrupted");
            Thread.currentThread().interrupt();
        }
    }

    private static FileLock lockFile(FileChannel channel, boolean shared) throws IOException {
        int i = 0;
        FileLock lock = null;
        do {
            if (i <= 0) continue;
            Utils.sleep(500L);
        } while ((lock = channel.tryLock(0L, Long.MAX_VALUE, shared)) == null && ++i < 3);
        return lock;
    }
}

