/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.security.basic.BasicAuthUser;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.scheduler.utils.AzureEnv;
import com.nuix.automate.scheduler.utils.AzureEnvironmentUtils;
import com.nuix.automate.scheduler.utils.HttpAddressUtils;
import com.nuix.automate.utils.exceptions.AuthenticationResponseException;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.basic.BasicCredentials;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;

public class AuthenticationUtil {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AuthenticationUtil.class);
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;

    public AuthenticationUtil(SchedulerApplication schedulerApplication) {
        this.schedulerConfiguration = schedulerApplication.getConfiguration();
        this.schedulerApplication = schedulerApplication;
    }

    private String getHeader() {
        if (this.schedulerApplication.getUserServiceResource().getEnabledMicrosoftOidcClients().size() > 0) {
            MicrosoftUserService microsoftUserService = (MicrosoftUserService)this.schedulerApplication.getUserServiceResource().getEnabledMicrosoftOidcClients().iterator().next().getOidcUserService();
            AzureEnv azureEnv = AzureEnvironmentUtils.resolveEnvironmentFromName(microsoftUserService.getEnvironment());
            String clientId = microsoftUserService.getClientId().replace("\"", "");
            String tenantId = microsoftUserService.getTenant().replace("\"", "");
            return "Bearer realm=\"" + tenantId + "\", error=\"invalid_token\", error_description=\"Access Token missing or malformed.\", authorization_uri=\"" + azureEnv.getAuthorityUrl() + "/" + tenantId + "/oauth2/v2.0/authorize\", client_id=\"" + clientId + "\"";
        }
        return "";
    }

    public BearerUser getUserFromHeader(HttpServletRequest request) throws AuthenticationResponseException {
        return this.getUserFromHeader(request, false);
    }

    public BearerUser getUserFromHeader(HttpServletRequest request, boolean withUiToken) throws AuthenticationResponseException {
        return this.getUserFromHeader(request, "Authorization", withUiToken);
    }

    public BearerUser getUserFromHeader(HttpServletRequest req, String authorizationHeaderName, boolean withUiToken) throws AuthenticationResponseException {
        String authHeader = req.getHeader(authorizationHeaderName);
        Object responseAuthHeader = "Basic realm=\"" + req.getRequestURL().toString() + "\"";
        if (authHeader != null) {
            if (authHeader.startsWith("Basic")) {
                BearerUser user2;
                BasicCredentials basicCredentials;
                block12: {
                    String base64Credentials = authHeader.substring("Basic".length()).trim();
                    byte[] credDecoded = Base64.getDecoder().decode(base64Credentials);
                    String credentials = new String(credDecoded, StandardCharsets.UTF_8);
                    String[] values = credentials.split(":", 2);
                    basicCredentials = new BasicCredentials(values[0], values[1]);
                    try {
                        user2 = this.schedulerApplication.getPasswordBasicAuthenticator().authenticate(basicCredentials, ResourceUtils.getRemoteRequestUrl((HttpServletRequest)req));
                        if (!user2.isPresent()) break block12;
                        BasicAuthUser basicAuthUser = (BasicAuthUser)((Object)user2.get());
                        if (basicAuthUser.getIdentifier().getIdentifierType().equals((Object)IdentifierType.INTERNAL_USERNAME)) {
                            String remoteAddress = ResourceUtils.getRemoteIpAddresses((HttpServletRequest)req);
                            if (this.schedulerConfiguration.getInternalCredentials().getRestrictToLocalhost() && !HttpAddressUtils.isAddressLocalhost(remoteAddress)) {
                                LOGGER.warn("Denied login for username " + basicAuthUser.getName() + " from " + remoteAddress + ". Internal authentication restricted to localhost.");
                                break block12;
                            }
                            ((BasicAuthUser)((Object)user2.get())).invalidate();
                            return (BearerUser)user2.get();
                        }
                        ((BasicAuthUser)((Object)user2.get())).invalidate();
                        return (BearerUser)user2.get();
                    }
                    catch (AuthenticationException user2) {
                        // empty catch block
                    }
                }
                user2 = this.schedulerApplication.getApiKeyResource().authenticateWithApiKey(basicCredentials.getUsername(), basicCredentials.getPassword());
                if (user2 != null) {
                    return user2;
                }
            } else if (authHeader.startsWith("Bearer")) {
                responseAuthHeader = this.getHeader();
                String token = authHeader.substring("Bearer".length()).trim();
                try {
                    Optional<BearerUser> user = withUiToken ? this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req) : this.schedulerApplication.getBearerAuthenticator().authenticate(token);
                    if (user.isPresent()) {
                        return user.get();
                    }
                }
                catch (AuthenticationException authenticationException) {
                    // empty catch block
                }
            }
        }
        Response authRequiredResponse = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"").header("WWW-Authenticate", responseAuthHeader).build();
        throw new AuthenticationResponseException(authRequiredResponse);
    }
}

