/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.azure.core.management.Region;
import com.azure.resourcemanager.compute.models.VirtualMachineSizeTypes;
import com.nuix.automate.scheduler.utils.AzureEnv;
import java.util.ArrayList;
import java.util.TreeSet;

public class AzureEnvironmentUtils {
    public static String getRegionIdFromNameOrLabel(String name) {
        for (Region r : Region.values()) {
            if (!r.name().equalsIgnoreCase(name) && !r.label().equalsIgnoreCase(name)) continue;
            return r.name();
        }
        return name;
    }

    public static String[] getAzureVmSizes() {
        TreeSet<String> result = new TreeSet<String>();
        for (VirtualMachineSizeTypes virtualMachineSizeType : VirtualMachineSizeTypes.values()) {
            result.add(virtualMachineSizeType.toString());
        }
        return result.toArray(new String[0]);
    }

    public static String[] getAzureLocations() {
        ArrayList<String> locationNames = new ArrayList<String>();
        for (Region r : Region.values()) {
            locationNames.add(r.label());
        }
        locationNames.sort(String::compareTo);
        return locationNames.toArray(new String[0]);
    }

    public static String[] getAzureEnvironments() {
        ArrayList<String> locationNames = new ArrayList<String>();
        for (AzureEnv r : AzureEnv.values()) {
            locationNames.add(r.toString());
        }
        locationNames.sort(String::compareTo);
        return locationNames.toArray(new String[0]);
    }

    public static AzureEnv resolveEnvironmentFromName(String name) {
        for (AzureEnv r : AzureEnv.values()) {
            if (r.toString().equalsIgnoreCase(name)) {
                return r;
            }
            if (!r.name().equalsIgnoreCase(name)) continue;
            return r;
        }
        return AzureEnv.AZURE_COMMERCIAL;
    }
}

