/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.resources.DatasetResource;
import com.nuix.automate.utils.models.api.dataset.FileInfo;
import java.util.List;
import java.util.Set;

public class FileInfoCache {
    private SchedulerApplication schedulerApplication;
    private DatasetResource resource;
    private boolean cacheEnabled;
    private static FileInfoCache instance;

    public static FileInfoCache getInstance() {
        if (instance == null) {
            instance = new FileInfoCache();
            FileInfoCache.instance.schedulerApplication = SchedulerApplication.getInstance();
            FileInfoCache.instance.cacheEnabled = FileInfoCache.instance.schedulerApplication.getConfiguration().isCacheDatasetFileInfos();
            FileInfoCache.instance.resource = FileInfoCache.instance.schedulerApplication.getDatasetResource();
        }
        return instance;
    }

    public List<FileInfo> getDatasetRootFileInfos(String datasetId) {
        if (this.cacheEnabled) {
            return this.resource.getDataSetFileInfos(datasetId, true);
        }
        return this.schedulerApplication.getSchedulerConfigurationDao().getDatasetRootFileInfos(datasetId);
    }

    public List<FileInfo> getDatasetFileInfos(String datasetId) {
        if (this.cacheEnabled) {
            return this.resource.getDataSetFileInfos(datasetId, false);
        }
        return this.schedulerApplication.getSchedulerConfigurationDao().getDatasetFileInfos(datasetId);
    }

    public FileInfo getFileInfo(String id) {
        if (this.cacheEnabled) {
            return this.resource.getFileInfo(id);
        }
        return this.schedulerApplication.getSchedulerConfigurationDao().getFileInfo(id);
    }

    public List<FileInfo> getFileInfos(Set<String> dataSetIds, Long beforeDate, Long afterDate) {
        if (this.cacheEnabled) {
            return this.resource.filterFileInfos(dataSetIds, beforeDate, afterDate);
        }
        return this.schedulerApplication.getSchedulerConfigurationDao().getFileInfos(dataSetIds, beforeDate, afterDate);
    }
}

