/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.webhook.WebhookCall;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeadersCaptureInterceptor
implements Interceptor {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(HeadersCaptureInterceptor.class);
    private WebhookCall webhookCall;

    public HeadersCaptureInterceptor(WebhookCall webhookCall) {
        this.webhookCall = webhookCall;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Headers headers = request.headers();
        StringBuilder stringBuilder = new StringBuilder();
        for (String headerName : headers.names()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(headerName);
            stringBuilder.append(": ");
            stringBuilder.append(headers.get(headerName));
        }
        this.webhookCall.setRequestHeaders(stringBuilder.toString());
        return chain.proceed(request);
    }
}

