/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.resources.LegalHoldResource;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipation;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldRole;
import java.util.List;
import java.util.Set;

public class LegalHoldParticipationCache {
    private SchedulerApplication schedulerApplication;
    private LegalHoldResource resource;
    private boolean cacheEnabled;
    private static LegalHoldParticipationCache instance;

    public static LegalHoldParticipationCache getInstance() {
        if (instance == null) {
            instance = new LegalHoldParticipationCache();
            LegalHoldParticipationCache.instance.schedulerApplication = SchedulerApplication.getInstance();
            LegalHoldParticipationCache.instance.resource = LegalHoldParticipationCache.instance.schedulerApplication.getLegalHoldResource();
            LegalHoldParticipationCache.instance.cacheEnabled = LegalHoldParticipationCache.instance.schedulerApplication.getConfiguration().isCacheLegalHoldParticipants();
        }
        return instance;
    }

    public LegalHoldParticipation getUserLegalHoldParticipation(String legalHoldId, String userId, LegalHoldRole role) {
        if (this.cacheEnabled) {
            return this.resource.getUserLegalHoldParticipation(legalHoldId, userId, role);
        }
        return this.schedulerApplication.getSchedulerConfigurationDao().getUserLegalHoldParticipation(legalHoldId, userId, role);
    }

    public List<LegalHoldParticipation> getUserLegalHoldParticipations(String legalHoldId, String userId) {
        if (this.cacheEnabled) {
            return this.resource.getUserLegalHoldParticipations(legalHoldId, userId);
        }
        return this.schedulerApplication.getSchedulerConfigurationDao().getUserLegalHoldParticipations(legalHoldId, userId);
    }

    public List<LegalHoldParticipation> getUserLegalHoldParticipations(String userId, LegalHoldRole role) {
        if (this.cacheEnabled) {
            return this.resource.getUserLegalHoldParticipations(userId, role);
        }
        return this.schedulerApplication.getSchedulerConfigurationDao().getUserLegalHoldParticipations(userId, role);
    }

    public List<LegalHoldParticipation> getLegalHoldParticipations(String legalHoldId, LegalHoldRole role) {
        if (this.cacheEnabled) {
            return this.resource.getLegalHoldParticipations(legalHoldId, role);
        }
        return this.schedulerApplication.getSchedulerConfigurationDao().getLegalHoldParticipations(legalHoldId, role);
    }

    public List<LegalHoldParticipation> getLegalHoldParticipations(String legalHoldId) {
        if (this.cacheEnabled) {
            return this.resource.getLegalHoldParticipations(legalHoldId);
        }
        return this.schedulerApplication.getSchedulerConfigurationDao().getLegalHoldParticipations(legalHoldId);
    }

    public Set<String> getLegalHoldParticipationUserIds(String legalHoldId, LegalHoldRole role) {
        if (this.cacheEnabled) {
            return this.resource.getLegalHoldParticipationUserIds(legalHoldId, role);
        }
        return this.schedulerApplication.getSchedulerConfigurationDao().getLegalHoldParticipationUserIds(legalHoldId, role);
    }
}

