/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.OfflineBearerUser;
import com.nuix.automate.scheduler.security.bearer.OfflineUser;
import com.nuix.automate.scheduler.utils.LegalHoldParticipationCache;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.exceptions.LegalHoldTriggerConfigurationException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.Job;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.legalhold.CustodianState;
import com.nuix.automate.utils.models.api.legalhold.JobTriggerType;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipation;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldRole;
import com.nuix.automate.utils.models.api.legalhold.NoticeDatasetEvent;
import com.nuix.automate.utils.models.api.legalhold.TriggerConfiguration;
import com.nuix.automate.utils.models.api.legalhold.TriggerConfigurationEvent;
import com.nuix.automate.utils.models.api.notice.FormElementType;
import com.nuix.automate.utils.models.api.notice.FormOption;
import com.nuix.automate.utils.models.api.notice.Notice;
import com.nuix.automate.utils.models.api.notice.NoticeEvent;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicy;
import com.nuix.automate.utils.models.api.smtp.EmailType;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.workflow.ParameterType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class LegalHoldUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LegalHoldUtils.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;

    public LegalHoldUtils(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    public SecurityPolicy buildAdministratorImplicitPolicy(LegalHold legalHold, List<LegalHoldParticipation> administrators) {
        SecurityPolicy administratorPolicy = this.buildImplicitPolicy(legalHold.getId(), Permission.MANAGE);
        administratorPolicy.setName(this.iu.getFormattedString("LegalHoldResource.ImplicitPolicy.AdministratorsName", (Object)legalHold.getName()));
        administratorPolicy.setDescription(this.iu.getFormattedString("LegalHoldResource.ImplicitPolicy.AdministratorsDescription", (Object)legalHold.getName()));
        TreeSet<Identifier> principals = new TreeSet<Identifier>();
        for (LegalHoldParticipation participation : administrators) {
            principals.add(this.getLegalHoldUserIdentifier(participation.getUserId()));
        }
        administratorPolicy.setPrincipals(principals);
        return administratorPolicy;
    }

    public SecurityPolicy buildCustodianImplicitPolicy(LegalHold legalHold) {
        SecurityPolicy custodianPolicy = this.buildImplicitPolicy(legalHold.getId(), Permission.RESPOND);
        custodianPolicy.setName(this.iu.getFormattedString("LegalHoldResource.ImplicitPolicy.CustodiansName", (Object)legalHold.getName()));
        custodianPolicy.setDescription(this.iu.getFormattedString("LegalHoldResource.ImplicitPolicy.CustodiansDescription", (Object)legalHold.getName()));
        TreeSet<Identifier> principals = new TreeSet<Identifier>();
        principals.add(new Identifier(IdentifierType.CUSTODIAN, ""));
        custodianPolicy.setPrincipals(principals);
        return custodianPolicy;
    }

    private SecurityPolicy buildImplicitPolicy(String legalHoldId, Permission permission) {
        SecurityPolicy implicitPolicy = new SecurityPolicy();
        implicitPolicy.setId(UidUtils.getRandom());
        implicitPolicy.setEnabled(Boolean.valueOf(true));
        TreeSet<Permission> permissions = new TreeSet<Permission>();
        permissions.add(permission);
        implicitPolicy.setPermissions(permissions);
        TreeSet<Identifier> scopes = new TreeSet<Identifier>();
        scopes.add(new Identifier(IdentifierType.LEGAL_HOLD_ID, legalHoldId));
        implicitPolicy.setScope(scopes);
        return implicitPolicy;
    }

    private Identifier getLegalHoldUserIdentifier(String userId) {
        UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(userId);
        if (userAccount != null) {
            switch (userAccount.getPlatform()) {
                case LDAP: {
                    return new Identifier(IdentifierType.LDAP_USERNAME, userAccount.getName());
                }
                case UMS: {
                    return new Identifier(IdentifierType.UMS_USERNAME, userAccount.getName());
                }
                case MANAGED: 
                case INTERNAL: {
                    return new Identifier(IdentifierType.INTERNAL_USERNAME, userAccount.getName());
                }
                case AZURE_AD: 
                case GOOGLE_WORKSPACE: {
                    if (userAccount.getAttributes() != null && userAccount.getAttributes().get("displayName") != null) {
                        return new Identifier(IdentifierType.OIDC_USERNAME, String.valueOf(userAccount.getAttributes().get("displayName")));
                    }
                    return new Identifier(IdentifierType.OIDC_USERNAME, userAccount.getName());
                }
            }
            return new Identifier(IdentifierType.LEGAL_HOLD_USERNAME, userAccount.getName());
        }
        return new Identifier(IdentifierType.LEGAL_HOLD_USER_ID, userId);
    }

    private String getLegalHoldUserEmail(String userId) {
        UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(userId);
        String email = "";
        if (userAccount != null && userAccount.getEmail() != null) {
            email = userAccount.getEmail();
        }
        return email;
    }

    public void handleCustodianTriggerConfiguration(LegalHold legalHold, JobTriggerType triggerType, List<LegalHoldParticipation> participants, Notice notice, NoticeEvent noticeEvent, Map<String, String> responseValues) {
        if (!Boolean.TRUE.equals(legalHold.getTriggerJobs()) || legalHold.getTriggerConfigurations() == null) {
            return;
        }
        for (TriggerConfiguration configuration : legalHold.getTriggerConfigurations().values()) {
            if (configuration.getEnabled() != Boolean.TRUE || configuration.getTrigger() != triggerType) continue;
            HashMap<String, String> userIdentifiers = new HashMap<String, String>();
            HashMap<String, String> userEmails = new HashMap<String, String>();
            if (participants != null) {
                for (LegalHoldParticipation participant : participants) {
                    Identifier userIdentifier = this.getLegalHoldUserIdentifier(participant.getUserId());
                    String userEmail = this.getLegalHoldUserEmail(participant.getUserId());
                    userIdentifiers.put(participant.getUserId(), userIdentifier.getIdentifierName());
                    userEmails.put(participant.getUserId(), userEmail);
                }
            }
            if (noticeEvent != null) {
                Identifier userIdentifier = this.getLegalHoldUserIdentifier(noticeEvent.getUserId());
                String userEmail = this.getLegalHoldUserEmail(noticeEvent.getUserId());
                userIdentifiers.put(noticeEvent.getUserId(), userIdentifier.getIdentifierName());
                userEmails.put(noticeEvent.getUserId(), userEmail);
            }
            Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(configuration.getWorkflowTemplateId());
            String additionalLegalHoldIdParameterName = null;
            for (Parameter parameter : workflow.getSessionParameters()) {
                if (parameter.getParameterType() != ParameterType.LEGAL_HOLD) continue;
                additionalLegalHoldIdParameterName = parameter.getName();
                break;
            }
            ArrayList<Parameter> sessionParameters = new ArrayList<Parameter>();
            if (additionalLegalHoldIdParameterName != null) {
                sessionParameters.add(new Parameter(additionalLegalHoldIdParameterName, legalHold.getId()));
            }
            sessionParameters.add(new Parameter("{legal_hold_id}", legalHold.getId()));
            sessionParameters.add(new Parameter("{legal_hold_name}", legalHold.getName()));
            sessionParameters.add(new Parameter("{legal_hold_event_trigger}", configuration.getTrigger().name()));
            HashSet<Object> eventUserIds = new HashSet<Object>();
            TriggerConfigurationEvent event = new TriggerConfigurationEvent();
            event.setId(UidUtils.getRandom());
            event.setLegalHoldId(legalHold.getId());
            event.setTriggerConfigurationId(configuration.getId());
            event.setTriggerType(configuration.getTrigger());
            if (noticeEvent != null) {
                event.setNoticeEventId(noticeEvent.getId());
            }
            String jobName = null;
            String jobNotes = null;
            if (triggerType == JobTriggerType.ON_MATTER_CUSTODIANS_HOLD || triggerType == JobTriggerType.ON_MATTER_CUSTODIANS_RELEASE) {
                jobName = legalHold.getName() + " - " + workflow.getName();
                jobNotes = "This job was triggered from the legal hold " + legalHold.getName() + " for the users " + String.join((CharSequence)", ", userIdentifiers.values());
                sessionParameters.add(new Parameter("{legal_hold_custodian_ids}", SerializationUtils.toJson(userIdentifiers.keySet())));
                sessionParameters.add(new Parameter("{legal_hold_custodian_names}", SerializationUtils.toJson(userIdentifiers.values())));
                sessionParameters.add(new Parameter("{legal_hold_custodian_emails}", SerializationUtils.toJson(userEmails.values())));
                eventUserIds.addAll(userIdentifiers.keySet());
            } else if (triggerType == JobTriggerType.ON_CUSTODIAN_REMINDER || triggerType == JobTriggerType.ON_CUSTODIAN_ESCALATION || triggerType == JobTriggerType.ON_CUSTODIAN_RESPONSE || triggerType == JobTriggerType.ON_CUSTODIAN_HOLD || triggerType == JobTriggerType.ON_CUSTODIAN_RELEASE) {
                String email;
                String custodianName;
                String custodianId;
                if (triggerType == JobTriggerType.ON_CUSTODIAN_RESPONSE && !configuration.triggeredByNotice(notice, responseValues)) continue;
                jobName = legalHold.getName() + " - " + workflow.getName();
                if (triggerType == JobTriggerType.ON_CUSTODIAN_REMINDER || triggerType == JobTriggerType.ON_CUSTODIAN_ESCALATION || triggerType == JobTriggerType.ON_CUSTODIAN_RESPONSE) {
                    if (noticeEvent == null) {
                        LOGGER.error("Unable to create trigger configuration job for " + triggerType.name() + ", notice event was null");
                        continue;
                    }
                    custodianId = noticeEvent.getUserId();
                    custodianName = (String)userIdentifiers.get(noticeEvent.getUserId());
                    email = (String)userEmails.get(noticeEvent.getUserId());
                    sessionParameters.add(new Parameter("{legal_hold_notice_event_id}", noticeEvent.getId()));
                    if (triggerType == JobTriggerType.ON_CUSTODIAN_RESPONSE) {
                        String responseValuesJson = SerializationUtils.toJson(responseValues);
                        sessionParameters.add(new Parameter("{legal_hold_notice_event_response}", responseValuesJson));
                    }
                } else {
                    if (participants == null || participants.size() == 0) {
                        LOGGER.error("Unable to create trigger configuration job for " + triggerType.name() + ", no participants to issue");
                        continue;
                    }
                    LegalHoldParticipation singleParticipant = participants.get(0);
                    custodianId = singleParticipant.getUserId();
                    custodianName = (String)userIdentifiers.get(custodianId);
                    email = (String)userEmails.get(custodianId);
                }
                jobName = jobName + " (" + custodianName + ")";
                jobNotes = "This job was triggered from the legal hold " + legalHold.getName() + " for the user " + custodianName;
                sessionParameters.add(new Parameter("{legal_hold_custodian_ids}", SerializationUtils.toJson(Collections.singletonList(custodianId))));
                sessionParameters.add(new Parameter("{legal_hold_custodian_names}", SerializationUtils.toJson(Collections.singletonList(custodianName))));
                sessionParameters.add(new Parameter("{legal_hold_custodian_emails}", SerializationUtils.toJson(Collections.singletonList(email))));
                sessionParameters.add(new Parameter("{legal_hold_custodian_id}", custodianId));
                sessionParameters.add(new Parameter("{legal_hold_custodian_name}", custodianName));
                sessionParameters.add(new Parameter("{legal_hold_custodian_email}", email));
                eventUserIds.add(custodianId);
            }
            event.setUserIds(eventUserIds);
            if (jobName == null) continue;
            this.triggerJob(legalHold, configuration, sessionParameters, event, jobName, jobNotes);
            this.schedulerApplication.getSchedulerConfigurationDao().addTriggerConfigurationEvent(event);
            if (!configuration.getTriggered()) {
                configuration.setTriggered(true);
                this.schedulerApplication.getSchedulerConfigurationDao().updateLegalHold(legalHold);
                ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD, legalHold.getId());
                ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLDS, "");
            }
            ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD_TRIGGER_CONFIGURATION_EVENTS, legalHold.getId());
        }
    }

    public void handleMatterTriggerConfiguration(LegalHold legalHold, JobTriggerType triggerType) {
        if (!Boolean.TRUE.equals(legalHold.getTriggerJobs()) || legalHold.getTriggerConfigurations() == null) {
            return;
        }
        for (TriggerConfiguration configuration : legalHold.getTriggerConfigurations().values()) {
            if (configuration.getEnabled() != Boolean.TRUE || configuration.getTrigger() != triggerType || configuration.getTriggered()) continue;
            Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(configuration.getWorkflowTemplateId());
            String additionalLegalHoldIdParameterName = null;
            for (Parameter parameter : workflow.getSessionParameters()) {
                if (parameter.getParameterType() != ParameterType.LEGAL_HOLD) continue;
                additionalLegalHoldIdParameterName = parameter.getName();
                break;
            }
            ArrayList<Parameter> sessionParameters = new ArrayList<Parameter>();
            if (additionalLegalHoldIdParameterName != null) {
                sessionParameters.add(new Parameter(additionalLegalHoldIdParameterName, legalHold.getId()));
            }
            sessionParameters.add(new Parameter("{legal_hold_id}", legalHold.getId()));
            sessionParameters.add(new Parameter("{legal_hold_name}", legalHold.getName()));
            sessionParameters.add(new Parameter("{legal_hold_event_trigger}", configuration.getTrigger().name()));
            TriggerConfigurationEvent event = new TriggerConfigurationEvent();
            event.setId(UidUtils.getRandom());
            event.setLegalHoldId(legalHold.getId());
            event.setTriggerConfigurationId(configuration.getId());
            event.setTriggerType(configuration.getTrigger());
            String jobName = legalHold.getName() + " - " + workflow.getName();
            String jobNotes = "This job was triggered from the legal hold " + legalHold.getName();
            this.triggerJob(legalHold, configuration, sessionParameters, event, jobName, jobNotes);
            this.schedulerApplication.getSchedulerConfigurationDao().addTriggerConfigurationEvent(event);
            configuration.setTriggered(true);
            this.schedulerApplication.getSchedulerConfigurationDao().updateLegalHold(legalHold);
            ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD, legalHold.getId());
            ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLDS, "");
            ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD_TRIGGER_CONFIGURATION_EVENTS, legalHold.getId());
        }
    }

    private void triggerJob(LegalHold legalHold, TriggerConfiguration configuration, List<Parameter> sessionParameters, TriggerConfigurationEvent event, String jobName, String jobNotes) {
        JobModel queueJob = new JobModel();
        queueJob.setName(jobName);
        queueJob.setNotes(jobNotes);
        queueJob.setPriority(legalHold.getPriority());
        queueJob.setMatterId(legalHold.getMatterId());
        queueJob.setSessionParameters(sessionParameters);
        queueJob.setResourcePoolId(legalHold.getResourcePoolId());
        queueJob.setExecutionProfileId(legalHold.getExecutionProfileId());
        queueJob.setLibraryWorkflowId(configuration.getWorkflowTemplateId());
        event.setTriggeredDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        String id = legalHold.getLastModifiedByUserId();
        if (id == null) {
            throw new LegalHoldTriggerConfigurationException("Legal hold is missing lastChangedUserId", this.iu.getString("LegalHoldResource.TriggerConfigurationEvent.MissingChangedBy"));
        }
        OfflineUser offlineUser = this.schedulerApplication.getSecurityDao().getOfflineUser(id);
        OfflineBearerUser offlineBearerUser = new OfflineBearerUser(offlineUser);
        LOGGER.info("Triggering job from legal hold: " + jobName);
        Response response = this.schedulerApplication.getJobResource().addProcessingJob(offlineBearerUser, null, null, queueJob);
        event.getStatus().reset();
        if (response != null) {
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String entity = "";
                if (response.hasEntity()) {
                    entity = response.getEntity().toString();
                }
                String errorMessage = "Unable to trigger " + configuration.getTrigger().name() + " for workflow " + configuration.getWorkflowLibraryId() + " of " + legalHold.getName() + " job resource responded with: " + entity;
                String localizedErrorMessage = this.iu.getFormattedString("LegalHoldResource.TriggerConfigurationEvent.ErrorAddingDetailed", (Object)configuration.getTrigger().getLocalizedString());
                event.getStatus().setError(localizedErrorMessage);
                throw new LegalHoldTriggerConfigurationException(errorMessage, localizedErrorMessage);
            }
            Job result = (Job)response.getEntity();
            event.setJobId(result.getId());
        }
    }

    public void removeOrUpdateTriggerConfigurationEvents(String legalHoldId, Set<String> removedUserIds) {
        List<TriggerConfigurationEvent> triggerConfigurationEvents = this.schedulerApplication.getSchedulerConfigurationDao().getTriggerConfigurationEvents(legalHoldId);
        EnumSet<JobTriggerType> custodianJobTriggerTypes = EnumSet.of(JobTriggerType.ON_CUSTODIAN_HOLD, JobTriggerType.ON_CUSTODIAN_RELEASE, JobTriggerType.ON_CUSTODIAN_RESPONSE, JobTriggerType.ON_CUSTODIAN_ESCALATION, JobTriggerType.ON_CUSTODIAN_REMINDER);
        for (String userId : removedUserIds) {
            for (TriggerConfigurationEvent triggerConfigurationEvent : triggerConfigurationEvents) {
                Set eventUserIds;
                if (!custodianJobTriggerTypes.contains(triggerConfigurationEvent.getTriggerType()) || !(eventUserIds = triggerConfigurationEvent.getUserIds()).contains(userId)) continue;
                TriggerConfigurationEvent event = triggerConfigurationEvent.clone();
                if (eventUserIds.size() > 1) {
                    eventUserIds.remove(userId);
                    event.setUserIds(eventUserIds);
                    this.schedulerApplication.getSchedulerConfigurationDao().updateTriggerConfigurationEvent(event);
                    continue;
                }
                this.schedulerApplication.getSchedulerConfigurationDao().deleteTriggerConfigurationEvents(event.getId());
            }
        }
    }

    public void issueNotices(BearerUser user, String userId, List<Notice> notices) {
        for (Notice notice : notices) {
            if (notice.getEnabled() != Boolean.TRUE) continue;
            UserAccount custodianUser = this.schedulerApplication.getUserServiceResource().getUser(userId);
            this.schedulerApplication.getNoticeUtils().buildNoticeEvent(user, notice, userId);
        }
    }

    public boolean issueSilentHold(LegalHoldParticipation participationModel) {
        if (participationModel == null || participationModel.getRole() != LegalHoldRole.CUSTODIAN || participationModel.getCustodianState() == CustodianState.ON_HOLD) {
            return false;
        }
        participationModel.setCustodianState(CustodianState.ON_HOLD);
        participationModel.setHoldIssuedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        participationModel.setHoldReleasedDate(null);
        this.schedulerApplication.getLegalHoldResource().updateLegalHoldParticipation(participationModel);
        this.schedulerApplication.getSchedulerConfigurationDao().updateLegalHoldParticipation(participationModel);
        return true;
    }

    public boolean issueHold(BearerUser user, LegalHoldParticipation participationModel, List<Notice> noticeModels) {
        if (!this.issueSilentHold(participationModel)) {
            return false;
        }
        this.disableAllUserLegalHoldNoticeEvents(participationModel.getLegalHoldId(), participationModel.getUserId());
        this.issueNotices(user, participationModel.getUserId(), noticeModels);
        return true;
    }

    public boolean issueSilentRelease(LegalHoldParticipation participationModel) {
        if (participationModel == null || participationModel.getRole() != LegalHoldRole.CUSTODIAN || participationModel.getCustodianState() == CustodianState.RELEASED) {
            return false;
        }
        participationModel.setCustodianState(CustodianState.RELEASED);
        participationModel.setHoldReleasedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        this.schedulerApplication.getLegalHoldResource().updateLegalHoldParticipation(participationModel);
        this.schedulerApplication.getSchedulerConfigurationDao().updateLegalHoldParticipation(participationModel);
        return true;
    }

    public boolean issueRelease(BearerUser user, LegalHoldParticipation participationModel, Notice releaseNotice) {
        if (!this.issueSilentRelease(participationModel)) {
            return false;
        }
        this.disableAllUserLegalHoldNoticeEvents(participationModel.getLegalHoldId(), participationModel.getUserId());
        this.schedulerApplication.getNoticeUtils().buildNoticeEvent(user, releaseNotice, participationModel.getUserId());
        return true;
    }

    private void disableAllUserLegalHoldNoticeEvents(String legalHoldId, String userId) {
        List<NoticeEvent> userNoticeEvents = this.schedulerApplication.getSchedulerConfigurationDao().getUserNoticeEvents(userId);
        for (NoticeEvent noticeEvent : userNoticeEvents) {
            try {
                Notice notice = this.schedulerApplication.getNoticeResource().getNotice(noticeEvent.getNoticeId());
                if (!legalHoldId.equals(notice.getLegalHoldId()) || noticeEvent.getEnabled() == Boolean.FALSE) continue;
                noticeEvent.setEnabled(Boolean.valueOf(false));
                this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(noticeEvent);
            }
            catch (Exception e) {
                LOGGER.error("Cannot disable notice event " + noticeEvent.getId(), (Throwable)e);
            }
        }
    }

    public void sendEmailToAdmins(BearerUser user, LegalHold legalHold, EmailType emailType, String emailDescription) {
        if (legalHold.getSilent() == Boolean.TRUE) {
            return;
        }
        Map<String, Parameter> legalHoldBuiltInParameters = this.schedulerApplication.getNoticeUtils().getLegalHoldBuiltInParameters(legalHold);
        for (LegalHoldParticipation adminParticipation : LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHold.getId(), LegalHoldRole.ADMINISTRATOR)) {
            UserAccount adminUserAccount = this.schedulerApplication.getUserServiceResource().getUser(adminParticipation.getUserId());
            if (!this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabled(adminUserAccount) || !adminUserAccount.hasEmail()) continue;
            SmtpEmail smtpEmail = this.buildLegalHoldSmtpEmail(legalHold, emailType);
            smtpEmail.setTo(adminUserAccount.getEmail());
            String noticeUrl = this.schedulerApplication.getUserResource().createLegalHoldLoginLink(adminUserAccount, legalHold, legalHold.getMatterUrl());
            smtpEmail.setHtmlFormat(Boolean.valueOf(true));
            smtpEmail.setMessage(smtpEmail.buildTemplateHtmlMessage(user.getName(), emailDescription, noticeUrl));
            this.schedulerApplication.getNoticeUtils().evaluateEmailParameters(smtpEmail, legalHoldBuiltInParameters);
            this.schedulerApplication.getSchedulerConfigurationDao().addSmtpEmail(smtpEmail);
            this.schedulerApplication.getThirdPartyServiceResource().submitEmail(smtpEmail);
        }
    }

    public SmtpEmail buildLegalHoldSmtpEmail(LegalHold legalHold, EmailType type) {
        SmtpEmail smtpEmail = new SmtpEmail(legalHold);
        smtpEmail.setType(type);
        smtpEmail.setSubject(legalHold.getName() + " - " + type.toString());
        smtpEmail.setSubmittedUserId(legalHold.getLastModifiedByUserId());
        return smtpEmail;
    }

    public Set<String> getUserLegalHoldIdsAsAdministrator(String userId) {
        HashSet<String> results = new HashSet<String>();
        for (LegalHoldParticipation participationModel : LegalHoldParticipationCache.getInstance().getUserLegalHoldParticipations(userId, LegalHoldRole.ADMINISTRATOR)) {
            results.add(participationModel.getLegalHoldId());
        }
        return results;
    }

    public Set<String> getUserIdsOfLegalHoldsAdminOf(String administratorUserId) {
        HashSet<String> results = new HashSet<String>();
        for (LegalHoldParticipation participationModel : LegalHoldParticipationCache.getInstance().getUserLegalHoldParticipations(administratorUserId, LegalHoldRole.ADMINISTRATOR)) {
            List<LegalHoldParticipation> participations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(participationModel.getLegalHoldId());
            for (LegalHoldParticipation participation : participations) {
                results.add(participation.getUserId());
            }
        }
        return results;
    }

    public Set<String> getAdminIdsOfLegalHoldsMemberOf(String custodianId) {
        HashSet<String> results = new HashSet<String>();
        for (LegalHoldParticipation participationModel : LegalHoldParticipationCache.getInstance().getUserLegalHoldParticipations(custodianId, LegalHoldRole.CUSTODIAN)) {
            List<LegalHoldParticipation> adminParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(participationModel.getLegalHoldId(), LegalHoldRole.ADMINISTRATOR);
            for (LegalHoldParticipation participation : adminParticipations) {
                results.add(participation.getUserId());
            }
        }
        return results;
    }

    public Map<String, List<NoticeDatasetEvent>> getLegalHoldNoticeDatasetEvents(String legalHoldId) {
        HashMap<String, List<NoticeDatasetEvent>> noticeDatasetEvents = new HashMap<String, List<NoticeDatasetEvent>>();
        for (Notice notice : this.schedulerApplication.getSchedulerConfigurationDao().getLegalHoldNotices(legalHoldId)) {
            List datasetFormOptions = null;
            if (notice.getSurveyFormOptions() != null) {
                datasetFormOptions = notice.getSurveyFormOptions().stream().filter(formOption -> formOption.getType() == FormElementType.DATA_UPLOAD).collect(Collectors.toList());
            }
            if (datasetFormOptions == null || datasetFormOptions.size() <= 0) continue;
            for (NoticeEvent noticeEvent : this.schedulerApplication.getSchedulerConfigurationDao().getNoticeNoticeEvents(notice.getId())) {
                if (noticeEvent.getSurveyFormValues() == null || noticeEvent.getSurveyFormValues().size() <= 0) continue;
                Map<String, Parameter> noticeEventBuiltInParameters = this.schedulerApplication.getNoticeUtils().getNoticeEventBuiltInParameters(noticeEvent);
                for (FormOption formOption2 : datasetFormOptions) {
                    String datasetId = (String)noticeEvent.getSurveyFormValues().get(formOption2.getKey());
                    if (datasetId == null || datasetId.trim().length() <= 0) continue;
                    NoticeDatasetEvent noticeDatasetEvent = new NoticeDatasetEvent();
                    noticeDatasetEvent.setDatasetId(datasetId);
                    noticeDatasetEvent.setFormLabel(this.schedulerApplication.getNoticeUtils().evaluateParameters(noticeEventBuiltInParameters, formOption2.getLabel()));
                    noticeDatasetEvents.computeIfAbsent(noticeEvent.getUserId(), k -> new ArrayList()).add(noticeDatasetEvent);
                }
            }
        }
        return noticeDatasetEvents;
    }

    public Set<String> getNamesOfJobsUsingLegalHold(BearerUser user, String legalHoldId) {
        TreeSet<String> jobNames = new TreeSet<String>();
        List<JobDetailsModel> nonFinishedJobsUsingLegalHold = this.schedulerApplication.getJobResource().getNonFinishedJobsUsingLegalHold(legalHoldId);
        if (nonFinishedJobsUsingLegalHold.size() == 0) {
            return jobNames;
        }
        if (user == null) {
            jobNames.add(this.iu.getString("Job.Name.Other"));
        } else {
            for (JobDetailsModel jobDetailsModel : nonFinishedJobsUsingLegalHold) {
                JobModel jobModel = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, jobDetailsModel.getSettings());
                if (jobModel.getUserPermissions().contains(Permission.VIEW)) {
                    jobNames.add(jobModel.getName());
                    continue;
                }
                jobNames.add(this.iu.getString("Job.Name.Other"));
            }
        }
        return jobNames;
    }

    public Response verifyNotUsedInJobs(BearerUser user, String legalHoldId) {
        Set<String> jobNames = this.getNamesOfJobsUsingLegalHold(user, legalHoldId);
        if (jobNames.size() == 0) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("jobNames", String.join((CharSequence)", ", jobNames));
        if (jobNames.size() == 1) {
            return ExceptionUtils.toResponse((String)"errorDeletingLegalHoldUsedByJob", properties);
        }
        return ExceptionUtils.toResponse((String)"errorDeletingLegalHoldUsedByJobs", properties);
    }
}

