/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.user.LoginLinkScope;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.internal.user.LoginLinkPayload;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.security.SecurityUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class LoginLinkUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LoginLinkUtils.class);
    private final SchedulerApplication schedulerApplication;

    public LoginLinkUtils(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    public String createLoginLink(String schedulerUrl, LoginLinkPayload linkPayload) throws InvalidKeyException, NoSuchAlgorithmException {
        String payload = SerializationUtils.toJson((Object)linkPayload);
        String encodedPayload = Base64.getEncoder().encodeToString(payload.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = SecurityUtils.computeHmac((String)encodedPayload, (String)this.schedulerApplication.getSettingsResource().getLoginLinkKey().getSecret());
        String encodedSignature = Base64.getEncoder().encodeToString(signatureBytes);
        Object url = schedulerUrl;
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + "#/login?ssotoken=" + encodedPayload + "." + encodedSignature;
        return url;
    }

    public String getUrlFragment(String urlString) throws URISyntaxException {
        URI testUri = new URI(urlString);
        return testUri.getFragment();
    }

    public boolean isLoginLinkEnabled(LegalHold legalHold, UserService userService, LoginLinkScope loginLinkScope) {
        boolean isLegalHoldValid = legalHold != null && legalHold.getSilent() != Boolean.TRUE && legalHold.getEnableLoginLinks() == Boolean.TRUE && LegalHold.manageStates.contains(legalHold.getState());
        boolean isUserServiceValid = userService != null && userService.getEnabled() == Boolean.TRUE && userService.getEnableLoginLinks() == Boolean.TRUE && userService.getLoginLinkAutoExpireInterval() != null && userService.getLoginLinkAutoExpireInterval() > 0 && userService.getLoginLinkScope() == loginLinkScope;
        return isLegalHoldValid && isUserServiceValid;
    }

    public boolean isPayloadValid(LegalHold legalHold, UserService userService, LoginLinkScope loginLinkScope) {
        if (legalHold == null) {
            LOGGER.warn("Login link is not valid: Legal Hold is null");
            return false;
        }
        if (legalHold.getSilent() == Boolean.TRUE) {
            LOGGER.warn("Login link is not valid: Legal Hold is Silent");
            return false;
        }
        if (legalHold.getEnableLoginLinks() != Boolean.TRUE) {
            LOGGER.warn("Login link is not valid: Login Links are not enabled in the Legal Hold");
            return false;
        }
        if (!LegalHold.manageStates.contains(legalHold.getState())) {
            LOGGER.warn("Login link is not valid: Legal hold state is not present in managed states");
            return false;
        }
        if (userService == null) {
            LOGGER.warn("Login link is not valid: User service is null");
            return false;
        }
        if (userService.getEnabled() != Boolean.TRUE) {
            LOGGER.warn("Login link is not valid: User service is not enabled");
            return false;
        }
        if (userService.getEnableLoginLinks() != Boolean.TRUE) {
            LOGGER.warn("Login link is not valid: Login Links are not enabled in the User Service");
            return false;
        }
        if (userService.getLoginLinkAutoExpireInterval() == null) {
            LOGGER.warn("Login link is not valid: User Service Login Link Auto Expire Interval is null");
            return false;
        }
        if (userService.getLoginLinkAutoExpireInterval() <= 0) {
            LOGGER.warn("Login link is not valid: User Service Login Link Auto Expire Interval is not greater than 0");
            return false;
        }
        if (userService.getLoginLinkScope() != loginLinkScope) {
            LOGGER.warn("Login link is not valid: Link login scope is different than User Service login scope");
            return false;
        }
        return true;
    }

    public boolean isPayloadValid(LoginLinkPayload linkPayload, boolean ignoreExpiration) {
        UserService userService;
        UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(linkPayload.getUserId());
        if (userAccount == null) {
            LOGGER.warn("Login link is not valid: User Account is null");
            return false;
        }
        if (!userAccount.hasEmail()) {
            LOGGER.warn("Login link is not valid: User Account does not have email");
            return false;
        }
        LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(linkPayload.getLegalHoldId());
        if (!this.isPayloadValid(legalHold, userService = this.schedulerApplication.getUserServiceResource().getUserService(userAccount.getUserServiceId()), linkPayload.getScope())) {
            LOGGER.warn("Login link is not valid: Link failed payload validation");
            return false;
        }
        long linkAge = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - linkPayload.getCreatedDate();
        long allowedAge = (long)userService.getLoginLinkAutoExpireInterval().intValue() * 60L * 1000L;
        if (!ignoreExpiration && linkAge >= allowedAge) {
            LOGGER.warn("Login link is not valid: Link age " + linkAge + " is greater than the allowed age " + allowedAge);
            return false;
        }
        return true;
    }

    public LoginLinkPayload parsePayload(String loginLink) {
        String[] ssoTokenSplit = this.getSsoTokenSplit(loginLink);
        String payload = new String(Base64.getDecoder().decode(ssoTokenSplit[0]), StandardCharsets.UTF_8);
        return (LoginLinkPayload)SerializationUtils.fromJson((String)payload, LoginLinkPayload.class);
    }

    public boolean validateLinkSignature(String loginLink) {
        boolean valid = false;
        try {
            String[] ssoTokenSplit = this.getSsoTokenSplit(loginLink);
            String encodedPayload = ssoTokenSplit[0];
            byte[] signatureBytes = Base64.getDecoder().decode(ssoTokenSplit[1]);
            valid = SecurityUtils.validateHmac((byte[])signatureBytes, (String)encodedPayload, (String)this.schedulerApplication.getSettingsResource().getLoginLinkKey().getSecret());
        }
        catch (Exception e) {
            LOGGER.error("Error validating sso link", (Throwable)e);
        }
        if (!valid) {
            LOGGER.error("Link signature is not valid");
        }
        return valid;
    }

    public String[] getSsoTokenSplit(String loginLink) {
        return loginLink.split("/#/login\\?ssotoken=")[1].split("\\.");
    }
}

