/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.notice.Notice;
import com.nuix.automate.utils.models.api.notice.NoticeConfiguration;
import com.nuix.automate.utils.models.api.notice.NoticeEvent;
import com.nuix.automate.utils.models.api.notice.NoticeTemplate;
import com.nuix.automate.utils.models.api.notice.NoticeType;
import com.nuix.automate.utils.models.api.smtp.EmailType;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.ActivityType;
import com.nuix.automate.utils.utilization.CustodianActivity;
import com.nuix.automate.utils.utilization.CustodianNotice;
import com.nuix.automate.utils.utilization.Transfer;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdbi.v3.core.statement.StatementException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class NoticeUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NoticeUtils.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    public static final Set<String> builtInParameterNames = new HashSet<String>(Arrays.asList("{legal_hold_name}", "{custodian_name}", "{custodian_email}", "{custodian_upn}", "{notice_subject}", "{sent_date}", "{original_notice_subject}", "{original_notice_respond_by_date}", "{original_notice_sent_date}"));

    public NoticeUtils(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    public List<Notice> getEnabledSurveyNotices(LegalHold legalHold) {
        ArrayList<Notice> surveyNotices = new ArrayList<Notice>();
        for (NoticeConfiguration noticeConfiguration : legalHold.getSurveyNoticeConfigurations().values()) {
            Notice notice = this.schedulerApplication.getNoticeResource().getNotice(noticeConfiguration.getNoticeId());
            if (notice == null || notice.getEnabled() != Boolean.TRUE) continue;
            surveyNotices.add(notice);
        }
        return surveyNotices;
    }

    public List<Notice> getReminderAndEscalateNotices(List<Notice> notices) {
        ArrayList<Notice> reminderAndEscalateNotices = new ArrayList<Notice>();
        for (Notice notice : notices) {
            Notice escalateNotice;
            NoticeConfiguration configuration = notice.getConfiguration();
            Notice reminderNotice = this.schedulerApplication.getNoticeResource().getNotice(configuration.getReminderNoticeId());
            if (reminderNotice != null) {
                reminderAndEscalateNotices.add(reminderNotice);
            }
            if ((escalateNotice = this.schedulerApplication.getNoticeResource().getNotice(configuration.getEscalateNoticeId())) == null) continue;
            reminderAndEscalateNotices.add(escalateNotice);
        }
        return reminderAndEscalateNotices;
    }

    public Notice buildOrUpdateNotices(String legalHoldId, NoticeConfiguration configuration) {
        Notice notice = null;
        if (configuration.getEnabled() == Boolean.TRUE && configuration.getNoticeId() == null && configuration.getNoticeTemplateId() != null) {
            notice = this.buildNotice(legalHoldId, configuration);
        } else if (configuration.getNoticeId() != null) {
            notice = this.schedulerApplication.getNoticeResource().getNotice(configuration.getNoticeId());
            notice.setConfiguration(configuration);
            this.schedulerApplication.getSchedulerConfigurationDao().updateNotice(notice);
        }
        if (notice != null) {
            if (configuration.getEnableRemind() == Boolean.TRUE && configuration.getReminderNoticeId() == null && configuration.getReminderNoticeTemplateId() != null) {
                this.buildReminderNotice(legalHoldId, configuration);
            } else if (configuration.getReminderNoticeId() != null) {
                Notice reminderNoticeModel = this.schedulerApplication.getNoticeResource().getNotice(configuration.getReminderNoticeId());
                reminderNoticeModel.getConfiguration().updateReminder(configuration);
                this.schedulerApplication.getSchedulerConfigurationDao().updateNotice(reminderNoticeModel);
            }
            if (configuration.getEscalateOnResponseFail() == Boolean.TRUE && configuration.getEscalateNoticeId() == null && configuration.getEscalateNoticeTemplateId() != null) {
                this.buildEscalateNotice(legalHoldId, configuration);
            } else if (configuration.getEscalateNoticeId() != null) {
                Notice escalateNoticeModel = this.schedulerApplication.getNoticeResource().getNotice(configuration.getEscalateNoticeId());
                escalateNoticeModel.getConfiguration().updateEscalate(configuration);
                this.schedulerApplication.getSchedulerConfigurationDao().updateNotice(escalateNoticeModel);
            }
            this.schedulerApplication.getSchedulerConfigurationDao().updateNotice(notice);
        }
        return notice;
    }

    private Notice buildNotice(String legalHoldId, NoticeConfiguration configuration) {
        LOGGER.info("Building notice for legal hold: " + legalHoldId);
        NoticeTemplate noticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(configuration.getNoticeTemplateId());
        Notice notice = new Notice(legalHoldId, noticeTemplate, configuration);
        this.schedulerApplication.getNoticeResource().addNotice(notice);
        return notice;
    }

    private Notice buildReminderNotice(String legalHoldId, NoticeConfiguration parentNoticeConfiguration) {
        LOGGER.info("Building reminder notice for legal hold: " + legalHoldId);
        String reminderNoticeTemplateId = parentNoticeConfiguration.getReminderNoticeTemplateId();
        NoticeTemplate reminderNoticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(reminderNoticeTemplateId);
        NoticeConfiguration reminderConfiguration = new NoticeConfiguration();
        reminderConfiguration.setNoticeType(NoticeType.REMINDER);
        reminderConfiguration.updateReminder(parentNoticeConfiguration);
        Notice reminderNoticeModel = new Notice(legalHoldId, reminderNoticeTemplate, reminderConfiguration);
        reminderNoticeModel.setParentNoticeId(parentNoticeConfiguration.getNoticeId());
        parentNoticeConfiguration.setReminderNoticeId(reminderNoticeModel.getId());
        this.schedulerApplication.getNoticeResource().addNotice(reminderNoticeModel);
        return reminderNoticeModel;
    }

    private Notice buildEscalateNotice(String legalHoldId, NoticeConfiguration parentNoticeConfiguration) {
        LOGGER.info("Building escalate notice for legal hold: " + legalHoldId);
        String escalateNoticeTemplateId = parentNoticeConfiguration.getEscalateNoticeTemplateId();
        NoticeTemplate escalateNoticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(escalateNoticeTemplateId);
        NoticeConfiguration escalateConfiguration = new NoticeConfiguration();
        escalateConfiguration.setNoticeType(NoticeType.ESCALATION);
        escalateConfiguration.updateEscalate(parentNoticeConfiguration);
        Notice escalateNoticeModel = new Notice(legalHoldId, escalateNoticeTemplate, escalateConfiguration);
        escalateNoticeModel.setParentNoticeId(parentNoticeConfiguration.getNoticeId());
        parentNoticeConfiguration.setEscalateNoticeId(escalateNoticeModel.getId());
        this.schedulerApplication.getNoticeResource().addNotice(escalateNoticeModel);
        return escalateNoticeModel;
    }

    public NoticeEvent buildNoticeEvent(BearerUser user, Notice notice, String userId) {
        List<NoticeEvent> existingNoticeEvents = this.schedulerApplication.getSchedulerConfigurationDao().getUserNoticeEvents(notice.getId(), userId);
        return this.buildNoticeEvent(user, notice, userId, existingNoticeEvents);
    }

    public NoticeEvent buildNoticeEvent(BearerUser user, Notice noticeModel, String userId, List<NoticeEvent> existingNoticeEvents) {
        String emailDescription;
        EmailType emailType;
        NoticeEvent noticeEvent;
        boolean custodianActive;
        UserAccount custodianUser = this.schedulerApplication.getUserServiceResource().getUser(userId);
        boolean bl = custodianActive = custodianUser != null && custodianUser.getUserAccountState().equals((Object)UserAccountState.ACTIVE);
        if (!custodianActive) {
            LOGGER.info("Skip building noticeEvent for user: " + userId + " because user is not active");
            return null;
        }
        LOGGER.info("Building noticeEvent for user: " + userId);
        if (noticeModel.getType() != NoticeType.REMINDER && noticeModel.getType() != NoticeType.RECURRING && existingNoticeEvents.size() > 0) {
            noticeEvent = existingNoticeEvents.get(0);
            emailType = EmailType.NOTICE_REISSUED;
            emailDescription = this.iu.getString("EmailResource.NoticeEventEmailDescription." + noticeModel.getType().name() + "_REISSUED");
            noticeEvent.resetSubmission(noticeModel.getSurveyFormOptions());
            noticeEvent.setSentDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
            this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(noticeEvent);
        } else {
            noticeEvent = new NoticeEvent(noticeModel.getId(), userId);
            this.schedulerApplication.getSchedulerConfigurationDao().addNoticeEvent(noticeEvent);
            emailType = EmailType.NOTICE_RECEIVED;
            emailDescription = this.iu.getString("EmailResource.NoticeEventEmailDescription." + noticeModel.getType().name());
        }
        UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(userId);
        if (this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabled(userAccount) && userAccount.hasEmail()) {
            LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(noticeModel.getLegalHoldId());
            SmtpEmail smtpEmail = new SmtpEmail(legalHold);
            smtpEmail.setType(emailType);
            smtpEmail.setSubject(noticeModel.getSubject());
            smtpEmail.setTo(userAccount.getEmail());
            smtpEmail.setSubmittedUserId(legalHold.getLastModifiedByUserId());
            String noticeUrl = this.schedulerApplication.getUserResource().createLegalHoldLoginLink(userAccount, legalHold, legalHold.getNoticeUrl(noticeEvent.getId()));
            smtpEmail.setHtmlFormat(Boolean.valueOf(true));
            smtpEmail.setMessage(smtpEmail.buildTemplateHtmlMessage(null, emailDescription, noticeUrl));
            this.evaluateEmailParameters(smtpEmail, this.getNoticeEventBuiltInParameters(noticeEvent));
            this.schedulerApplication.getSchedulerConfigurationDao().addSmtpEmail(smtpEmail);
            this.schedulerApplication.getThirdPartyServiceResource().submitEmail(smtpEmail);
            this.trackIssuedNoticeEventUtilization(user, noticeModel, noticeEvent);
        }
        return noticeEvent;
    }

    public void trackUpdatedNoticeEventUtilization(BearerUser user, Notice notice, NoticeEvent noticeEvent) {
        String userId = noticeEvent.getUserId();
        User utilizationUser = this.schedulerApplication.getLegalHoldResource().getUtilizationUserFromLegalHoldUserId(noticeEvent.getUserId());
        if (utilizationUser != null) {
            userId = utilizationUser.getUserId();
        }
        this.trackUpdatedNoticeEventUtilization(userId, notice, noticeEvent);
    }

    public CustodianNotice trackUpdatedNoticeEventUtilization(String userId, Notice notice, NoticeEvent noticeEvent) {
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<CustodianNotice> custodianNotices = new HashSet<CustodianNotice>();
        utilizationRecords.setCustodianNotices(custodianNotices);
        CustodianNotice custodianNotice = new CustodianNotice();
        custodianNotice.setCustodianNoticeId(noticeEvent.getId());
        custodianNotice.setNoticeId(noticeEvent.getNoticeId());
        custodianNotice.setLegalHoldId(notice.getLegalHoldId());
        custodianNotice.setUserId(userId);
        custodianNotice.setNoticeIssuedEpoch(noticeEvent.getCreatedDate());
        custodianNotice.setNoticeViewedEpoch(noticeEvent.getFirstViewedDate());
        custodianNotice.setNoticeRespondedEpoch(noticeEvent.getRespondedDate());
        if (Boolean.TRUE.equals(notice.getConfiguration().getRequireResponse())) {
            custodianNotice.setNoticeRespondByEpoch(Long.valueOf(notice.getConfiguration().getRespondByMillis(noticeEvent.getCreatedDate().longValue())));
        }
        custodianNotice.setNoticeEscalatedEpoch(noticeEvent.getEscalatedDate());
        this.schedulerApplication.getUtilizationDaoV2().replaceCustodianNotice(custodianNotice);
        custodianNotices.add(custodianNotice);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
        return custodianNotice;
    }

    public void trackCustodianActivity(String legalHoldId, String custodianNoticeId, String activityKey) {
        CustodianActivity custodianActivity = new CustodianActivity();
        custodianActivity.setCustodianActivityId(UidUtils.getRandom());
        custodianActivity.setCustodianNoticeId(custodianNoticeId);
        custodianActivity.setActivityKey(activityKey);
        custodianActivity.setLegalHoldId(legalHoldId);
        try {
            this.schedulerApplication.getUtilizationDaoV2().addCustodianActivity(custodianActivity);
        }
        catch (StatementException statementException) {
            // empty catch block
        }
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<CustodianActivity> custodianActivities = new HashSet<CustodianActivity>();
        custodianActivities.add(custodianActivity);
        utilizationRecords.setCustodianActivities(custodianActivities);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public void trackDataSetUtilization(Transfer transfer, NoticeEvent noticeEvent) {
        String noticeId = noticeEvent.getNoticeId();
        Notice notice = this.schedulerApplication.getNoticeResource().getNotice(noticeId);
        if (notice != null) {
            this.trackCustodianActivity(notice.getLegalHoldId(), noticeEvent.getId(), transfer.getActivityKey());
        }
    }

    public void trackIssuedNoticeEventUtilization(BearerUser user, Notice notice, NoticeEvent noticeEvent) {
        String userId = noticeEvent.getUserId();
        User utilizationUser = this.schedulerApplication.getLegalHoldResource().getUtilizationUserFromLegalHoldUserId(noticeEvent.getUserId());
        if (utilizationUser != null) {
            userId = utilizationUser.getUserId();
            this.schedulerApplication.getUtilizationDaoV2().replaceUser(utilizationUser);
        }
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<CustodianActivity> custodianActivities = new HashSet<CustodianActivity>();
        utilizationRecords.setCustodianActivities(custodianActivities);
        HashSet<ActivityDetails> activityDetailsSet = new HashSet<ActivityDetails>();
        utilizationRecords.setActivityDetails(activityDetailsSet);
        CustodianNotice custodianNotice = this.trackUpdatedNoticeEventUtilization(userId, notice, noticeEvent);
        LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(notice.getLegalHoldId());
        if (notice.getConfiguration().getNoticeType().equals((Object)NoticeType.HOLD)) {
            CustodianActivity custodianSetupActivity = new CustodianActivity();
            custodianSetupActivity.setCustodianActivityId(UidUtils.getRandom());
            custodianSetupActivity.setCustodianNoticeId(custodianNotice.getCustodianNoticeId());
            custodianSetupActivity.setActivityKey(custodianSetupActivity.getCustodianActivityId());
            custodianSetupActivity.setLegalHoldId(legalHold.getId());
            try {
                this.schedulerApplication.getUtilizationDaoV2().addCustodianActivity(custodianSetupActivity);
            }
            catch (StatementException statementException) {
                // empty catch block
            }
            custodianActivities.add(custodianSetupActivity);
            ActivityDetails custodianSetupActivityDetails = new ActivityDetails();
            custodianSetupActivityDetails.setStartEpoch(custodianNotice.getNoticeIssuedEpoch().longValue());
            custodianSetupActivityDetails.setLastEpoch(custodianNotice.getNoticeIssuedEpoch() + 1L);
            custodianSetupActivityDetails.setMatterId(legalHold.getMatterId());
            custodianSetupActivityDetails.setActivityType(ActivityType.LEGAL_HOLD_SETUP);
            custodianSetupActivityDetails.setUserId(User.getIdFromName((String)user.getName(), (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret()));
            custodianSetupActivityDetails.setActivityKey(custodianSetupActivity.getActivityKey());
            this.schedulerApplication.getUserResource().trackFinishedActivity(custodianSetupActivityDetails);
            activityDetailsSet.add(custodianSetupActivityDetails);
        }
        CustodianActivity custodianIssueNoticeActivity = new CustodianActivity();
        custodianIssueNoticeActivity.setCustodianActivityId(UidUtils.getRandom());
        custodianIssueNoticeActivity.setCustodianNoticeId(custodianNotice.getCustodianNoticeId());
        custodianIssueNoticeActivity.setActivityKey(custodianIssueNoticeActivity.getCustodianActivityId());
        custodianIssueNoticeActivity.setLegalHoldId(legalHold.getId());
        try {
            this.schedulerApplication.getUtilizationDaoV2().addCustodianActivity(custodianIssueNoticeActivity);
        }
        catch (StatementException custodianSetupActivityDetails) {
            // empty catch block
        }
        custodianActivities.add(custodianIssueNoticeActivity);
        ActivityDetails custodianIssuedHoldActivityDetails = new ActivityDetails();
        custodianIssuedHoldActivityDetails.setStartEpoch(custodianNotice.getNoticeIssuedEpoch().longValue());
        custodianIssuedHoldActivityDetails.setLastEpoch(custodianNotice.getNoticeIssuedEpoch() + 1L);
        custodianIssuedHoldActivityDetails.setMatterId(legalHold.getMatterId());
        if (notice.getConfiguration().getNoticeType().equals((Object)NoticeType.HOLD)) {
            custodianIssuedHoldActivityDetails.setActivityType(ActivityType.LEGAL_HOLD_ISSUED);
        } else {
            custodianIssuedHoldActivityDetails.setActivityType(ActivityType.LEGAL_HOLD_NOTICE_SENT);
        }
        custodianIssuedHoldActivityDetails.setUserId(userId);
        custodianIssuedHoldActivityDetails.setActivityKey(custodianIssueNoticeActivity.getActivityKey());
        this.schedulerApplication.getUserResource().trackFinishedActivity(custodianIssuedHoldActivityDetails);
        activityDetailsSet.add(custodianIssuedHoldActivityDetails);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public SmtpEmail buildNoticeEventEmailModel(NoticeEvent noticeEvent, EmailType type) {
        Notice notice = this.schedulerApplication.getNoticeResource().getNotice(noticeEvent.getNoticeId());
        LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(notice.getLegalHoldId());
        SmtpEmail smtpEmail = new SmtpEmail(legalHold);
        smtpEmail.setType(type);
        smtpEmail.setSubject(notice.getSubject() + " - " + type.toString());
        smtpEmail.setSubmittedUserId(legalHold.getLastModifiedByUserId());
        return smtpEmail;
    }

    public void evaluateEmailParameters(SmtpEmail emailModel, Map<String, Parameter> parameters) {
        String subject = emailModel.getSubject();
        String message = emailModel.getMessage();
        for (Parameter parameter : parameters.values()) {
            subject = subject.replace(parameter.getName(), parameter.getValue());
            message = message.replace(parameter.getName(), parameter.getValue());
        }
        emailModel.setSubject(subject);
        emailModel.setMessage(message);
    }

    public Map<String, Parameter> getLegalHoldBuiltInParameters(LegalHold legalHold) {
        HashMap<String, Parameter> builtInParameters = new HashMap<String, Parameter>(legalHold.getParameters());
        builtInParameters.put("{legal_hold_name}", new Parameter("{legal_hold_name}", legalHold.getName()));
        this.evaluateNestedParameters(builtInParameters);
        return builtInParameters;
    }

    public Map<String, Parameter> getNoticeBuiltInParameters(Notice notice, Long eventSentDate) {
        Notice parentNotice;
        HashMap<String, Parameter> builtInParameters = new HashMap<String, Parameter>();
        LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(notice.getLegalHoldId());
        if (legalHold != null) {
            builtInParameters.putAll(this.getLegalHoldBuiltInParameters(legalHold));
        }
        builtInParameters.put("{notice_subject}", new Parameter("{notice_subject}", notice.getSubject()));
        if (notice.getParentNoticeId() != null && (NoticeType.REMINDER.equals((Object)notice.getType()) || NoticeType.ESCALATION.equals((Object)notice.getType())) && (parentNotice = this.schedulerApplication.getNoticeResource().getNotice(notice.getParentNoticeId())) != null) {
            builtInParameters.put("{original_notice_subject}", new Parameter("{original_notice_subject}", parentNotice.getSubject()));
            NoticeConfiguration parentConfiguration = parentNotice.getConfiguration();
            if (Boolean.TRUE.equals(parentConfiguration.getRequireResponse())) {
                Object parentRespondByDate;
                long millis;
                if (eventSentDate != null) {
                    millis = parentConfiguration.getRespondByMillis(eventSentDate.longValue());
                    DateTime dateTime = new DateTime(millis);
                    parentRespondByDate = FormattingUtils.dateTimeToLocalString((DateTime)dateTime) + " (" + DateTimeZone.getDefault().toString() + ")";
                } else if (parentConfiguration.getRespondByDate() != null) {
                    millis = parentConfiguration.getRespondByDate();
                    DateTime dateTime = new DateTime(millis);
                    parentRespondByDate = FormattingUtils.dateTimeToLocalString((DateTime)dateTime) + " (" + DateTimeZone.getDefault().toString() + ")";
                } else {
                    parentRespondByDate = this.iu.getNumeralString("NoticeResource.RespondByDays", (long)parentConfiguration.getRespondByNDays().intValue());
                }
                builtInParameters.put("{original_notice_respond_by_date}", new Parameter("{original_notice_respond_by_date}", (String)parentRespondByDate));
                if (eventSentDate != null) {
                    DateTime dateTime = new DateTime((Object)eventSentDate);
                    String parentSentDate = FormattingUtils.dateTimeToLocalString((DateTime)dateTime) + " (" + DateTimeZone.getDefault().toString() + ")";
                    builtInParameters.put("{original_notice_sent_date}", new Parameter("{original_notice_sent_date}", parentSentDate));
                }
            }
        }
        this.evaluateNestedParameters(builtInParameters);
        return builtInParameters;
    }

    public Map<String, Parameter> getNoticeEventBuiltInParameters(NoticeEvent noticeEvent) {
        HashMap<String, Parameter> builtInParameters = new HashMap<String, Parameter>();
        Long sentDate = noticeEvent.getSentDate();
        Notice notice = this.schedulerApplication.getNoticeResource().getNotice(noticeEvent.getNoticeId());
        if (notice != null) {
            builtInParameters.putAll(this.getNoticeBuiltInParameters(notice, sentDate));
        }
        UserAccount noticeEventUser = this.schedulerApplication.getUserServiceResource().getUser(noticeEvent.getUserId());
        String custodianName = noticeEvent.getUserId();
        if (noticeEventUser != null) {
            custodianName = noticeEventUser.getName();
            if (noticeEventUser.hasEmail()) {
                builtInParameters.put("{custodian_email}", new Parameter("{custodian_email}", noticeEventUser.getEmail()));
            }
            if (noticeEventUser.getPlatform() == UserAccountPlatform.AZURE_AD) {
                builtInParameters.put("{custodian_upn}", new Parameter("{custodian_upn}", noticeEventUser.getName()));
                Object userDisplayName = noticeEventUser.getAttributes().get("displayName");
                if (userDisplayName != null && !userDisplayName.toString().trim().isEmpty()) {
                    custodianName = userDisplayName.toString();
                }
            }
        }
        builtInParameters.put("{custodian_name}", new Parameter("{custodian_name}", custodianName));
        DateTime dateTime = new DateTime((Object)sentDate);
        String formattedSentDate = FormattingUtils.dateTimeToLocalString((DateTime)dateTime) + " (" + DateTimeZone.getDefault().getNameKey(0L) + ")";
        builtInParameters.put("{sent_date}", new Parameter("{sent_date}", formattedSentDate));
        this.evaluateNestedParameters(builtInParameters);
        return builtInParameters;
    }

    public Map<String, Parameter> normalizeParameters(Map<String, Parameter> parameters) {
        HashMap<String, Parameter> normalizedParameters = new HashMap<String, Parameter>();
        for (String paramName : parameters.keySet()) {
            String normalizedParameterName = FormattingUtils.normalizeParameterName((String)paramName);
            Parameter parameterModel = parameters.get(paramName);
            parameterModel.setName(normalizedParameterName);
            normalizedParameters.put(normalizedParameterName, parameterModel);
        }
        return normalizedParameters;
    }

    public String[] evaluateParameters(Map<String, Parameter> parameterMap, String ... values) {
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.evaluateParameters(parameterMap, values[i]);
        }
        return result;
    }

    public String evaluateParameters(Map<String, Parameter> parameterMap, String value) {
        String result = value;
        for (Parameter parameter : parameterMap.values()) {
            if (parameter.getValue() == null) continue;
            String htmlEncodedValue = FormattingUtils.encodeForHtml((String)parameter.getValue());
            result = result.replace(parameter.getName(), htmlEncodedValue);
        }
        return result;
    }

    private void evaluateNestedParameters(Map<String, Parameter> parameterMap) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(parameterMap.values());
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            String name = parameter.getName();
            for (int j = 1; j < parameters.size(); ++j) {
                int nextIndex = (j + i) % parameters.size();
                Parameter nextParameter = (Parameter)parameters.get(nextIndex);
                String value = nextParameter.getValue();
                if (!value.contains(name)) continue;
                nextParameter.setValue(value.replace(name, parameter.getValue()));
            }
        }
    }
}

