/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;

public class OpenApiUtil {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OpenApiUtil.class);

    public void exportOpenApi() {
        try {
            Path openApiFile;
            long delay = 1000L;
            LOGGER.info("Waiting " + delay + " ms before downloading API");
            Thread.sleep(delay);
            LOGGER.info("Downloading API");
            SchedulerConfiguration config = SchedulerApplication.getInstance().getConfiguration();
            String suffix = config.getOpenApiFileSuffix();
            if (suffix == null) {
                suffix = "";
            }
            if ((openApiFile = Paths.get("openapi" + suffix + ".json", new String[0])).toFile().exists()) {
                Files.delete(openApiFile);
            }
            Client client = DropwizardRestClientFactory.getClient((String)"Export openApi", (AutomateApplication)SchedulerApplication.getInstance(), (AutomateConfiguration)SchedulerApplication.getInstance().getConfiguration());
            WebTarget webTarget = client.target("http://localhost:5880/api/openapi.json");
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            Response response = invocationBuilder.get();
            String jsonResponse = (String)response.readEntity(String.class);
            FileUtils.writeStringToFile((File)openApiFile.toFile(), (String)jsonResponse, (Charset)StandardCharsets.UTF_8);
            LOGGER.info("Finished downloading API");
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Cannot export OpenAPI", (Throwable)e);
        }
    }
}

