/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.workflow.core.execution.workflow.ImmutableWorkflow;
import com.nuix.automate.workflow.core.execution.workflow.Workflow;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class WorkflowSerializationUtils {
    private static WorkflowSerializationUtils instance;
    private final Cache<String, ImmutableWorkflow> workflowCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowSerializationUtils getInstance() {
        Class<WorkflowSerializationUtils> clazz = WorkflowSerializationUtils.class;
        synchronized (WorkflowSerializationUtils.class) {
            if (instance == null) {
                instance = new WorkflowSerializationUtils();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private WorkflowSerializationUtils() {
        SchedulerConfiguration schedulerConfiguration = SchedulerApplication.getInstance().getConfiguration();
        this.workflowCache = Caffeine.newBuilder().maximumSize((long)schedulerConfiguration.getWorkflowCacheSize()).expireAfterAccess((long)schedulerConfiguration.getWorkflowCacheLifetimeSeconds(), TimeUnit.SECONDS).build();
    }

    public ImmutableWorkflow fromWorkflowCache(String xml) throws IOException {
        return this.fromWorkflowCache(xml, DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
    }

    public ImmutableWorkflow fromWorkflowCache(String xml, long lastModified) throws IOException {
        ImmutableWorkflow workflow = (ImmutableWorkflow)this.workflowCache.getIfPresent((Object)xml);
        if (workflow == null) {
            workflow = new ImmutableWorkflow(Workflow.fromXml((String)xml, (long)lastModified));
            this.workflowCache.put((Object)xml, (Object)workflow);
        }
        return workflow;
    }
}

