/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.allowedvalues.ParameterAllowedValues;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.DatasetState;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DataSetAllowedValues
extends ParameterAllowedValues {
    protected BearerUser user;
    protected boolean includeHiddenDatasets;
    protected String matterId;

    public DataSetAllowedValues(SchedulerApplication schedulerApplication, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues, BearerUser user, String matterId, boolean includeHiddenDatasets) {
        super(schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
        this.matterId = matterId;
        this.user = user;
        this.includeHiddenDatasets = includeHiddenDatasets;
    }

    @Override
    protected List<AllowedValueItem> getAllowedSessionParameterValueItems(Permission allowedValuesScopePermission) {
        List<String> parameterAllowedValues = this.getAllowedSessionParameterValues();
        ArrayList<AllowedValueItem> parameterAllowedValueItems = new ArrayList<AllowedValueItem>();
        for (Dataset matterDataset : this.schedulerApplication.getClientResource().getMatterDatasets(this.matterId)) {
            Dataset result;
            Set userPermissions;
            if (!this.matchesAllowedValues(parameterAllowedValues, matterDataset.getId(), matterDataset.getName()) || matterDataset.getState() != DatasetState.FINALIZED && (!this.includeHiddenDatasets || matterDataset.getState() != DatasetState.HIDDEN) || !(userPermissions = (result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(this.user, matterDataset)).getUserPermissions()).contains(Permission.VIEW) || !userPermissions.contains(allowedValuesScopePermission)) continue;
            parameterAllowedValueItems.add(new AllowedValueItem(result.getName(), result.getId()));
        }
        return parameterAllowedValueItems;
    }
}

