/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.allowedvalues.ParameterAllowedValues;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LegalHoldAllowedValues
extends ParameterAllowedValues {
    protected BearerUser user;

    public LegalHoldAllowedValues(SchedulerApplication schedulerApplication, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues, BearerUser user) {
        super(schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
        this.user = user;
    }

    @Override
    protected List<AllowedValueItem> getAllowedSessionParameterValueItems(Permission allowedValuesScopePermission) {
        List<String> parameterAllowedValues = this.getAllowedSessionParameterValues();
        ArrayList<AllowedValueItem> parameterAllowedValueItems = new ArrayList<AllowedValueItem>();
        for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
            if (!this.matchesAllowedValues(parameterAllowedValues, legalHold.getId(), legalHold.getName())) continue;
            HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.LEGAL_HOLDS));
            Set<Permission> legalHoldPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(this.user.getIdentifiers(), scopeIdentifiers);
            LegalHold result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(this.user, legalHold);
            Set userPermissions = result.getUserPermissions();
            if (!userPermissions.contains(Permission.VIEW) || !legalHoldPermissions.contains(allowedValuesScopePermission)) continue;
            parameterAllowedValueItems.add(new AllowedValueItem(result.getName(), result.getId()));
        }
        return parameterAllowedValueItems;
    }
}

