/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.allowedvalues.ParameterAllowedValues;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.models.api.filelibrary.FileLibrary;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class LibraryFileAllowedValues
extends ParameterAllowedValues {
    protected BearerUser user;

    public LibraryFileAllowedValues(SchedulerApplication schedulerApplication, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues, BearerUser user) {
        super(schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
        this.user = user;
    }

    @Override
    protected List<AllowedValueItem> getAllowedSessionParameterValueItems(Permission allowedValuesScopePermission) {
        List<String> parameterAllowedValues = this.getAllowedSessionParameterValues();
        ArrayList<AllowedValueItem> parameterAllowedValueItems = new ArrayList<AllowedValueItem>();
        for (FileLibrary library : this.schedulerApplication.getFileLibraryResource().getFileLibraries()) {
            FileLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(this.user, library);
            Set userPermissions = result.getUserPermissions();
            if (!userPermissions.contains(Permission.VIEW) || !userPermissions.contains(allowedValuesScopePermission)) continue;
            for (FileLibraryFile libraryFile : result.getFiles().values()) {
                if (!this.matchesAllowedValues(parameterAllowedValues, libraryFile.getId(), libraryFile.getName())) continue;
                parameterAllowedValueItems.add(new AllowedValueItem(libraryFile.getName(), libraryFile.getId()));
            }
        }
        return parameterAllowedValueItems;
    }
}

