/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.allowedvalues.ParameterAllowedValues;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.userdatadir.FileInfo;
import com.nuix.automate.utils.models.api.userdatadir.UserDataDir;
import com.nuix.automate.utils.workflow.ParameterType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class NuixProfileAllowedValues
extends ParameterAllowedValues {
    private final BearerUser user;
    private LibraryNuixFileType fileType;

    public NuixProfileAllowedValues(SchedulerApplication schedulerApplication, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues, BearerUser user) {
        super(schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
        this.user = user;
    }

    public void setFileType(ParameterType parameterType) {
        this.fileType = this.getFileTypeForParameter(parameterType);
    }

    @Override
    protected List<AllowedValueItem> getAllowedSessionParameterValueItems(Permission allowedValuesScopePermission) {
        Set userPermissions;
        List<String> parameterAllowedValues = this.getAllowedSessionParameterValues();
        ArrayList<AllowedValueItem> parameterAllowedValueItems = new ArrayList<AllowedValueItem>();
        Collection<FileInfo> fileInfos = null;
        UserDataDir userDataDir = this.schedulerApplication.getUserDataDirResource().getUserDataDir();
        if (userDataDir != null && (userPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(this.user, userDataDir).getUserPermissions()).contains(Permission.VIEW) && userPermissions.contains(allowedValuesScopePermission)) {
            fileInfos = this.schedulerApplication.getUserDataDirResource().getFileInfos().values();
        }
        if (fileInfos != null) {
            for (FileInfo fileInfo : fileInfos) {
                if (fileInfo.getFileType() != this.fileType || !this.matchesAllowedValues(parameterAllowedValues, fileInfo.getName(), fileInfo.getName())) continue;
                AllowedValueItem allowedValueItem = new AllowedValueItem(fileInfo.getName(), fileInfo.getName());
                parameterAllowedValueItems.add(allowedValueItem);
            }
        }
        return parameterAllowedValueItems;
    }

    private LibraryNuixFileType getFileTypeForParameter(ParameterType parameterType) {
        switch (parameterType) {
            case PROCESSING_PROFILE: {
                return LibraryNuixFileType.PROCESSING_PROFILE;
            }
            case CONFIGURATION_PROFILE: {
                return LibraryNuixFileType.CONFIGURATION_PROFILE;
            }
            case METADATA_PROFILE: {
                return LibraryNuixFileType.METADATA_PROFILE;
            }
            case METADATA_IMPORT_PROFILE: {
                return LibraryNuixFileType.METADATA_IMPORT_PROFILE;
            }
            case PLAYBOOK: {
                return LibraryNuixFileType.PLAYBOOK;
            }
            case OCR_PROFILE: {
                return LibraryNuixFileType.OCR_PROFILE;
            }
            case IMAGING_PROFILE: {
                return LibraryNuixFileType.IMAGING_PROFILE;
            }
            case PRODUCTION_PROFILE: {
                return LibraryNuixFileType.PRODUCTION_PROFILE;
            }
        }
        throw new IllegalArgumentException("Unexpected parameterType: " + String.valueOf(parameterType));
    }
}

