/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.allowedvalues.AllowedValues;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.general.CollectionUtils;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import java.util.ArrayList;
import java.util.List;

public class ParameterAllowedValues
extends AllowedValues {
    protected List<String> clientAllowedValues;
    protected List<String> matterAllowedValues;
    protected List<String> clientPoolAllowedValues;

    public ParameterAllowedValues(SchedulerApplication schedulerApplication, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues) {
        super(schedulerApplication, parameter);
        this.clientAllowedValues = clientAllowedValues;
        this.matterAllowedValues = matterAllowedValues;
        this.clientPoolAllowedValues = clientPoolAllowedValues;
    }

    @Override
    protected List<String> getAllowedSessionParameterValues() {
        List<String> allowedValues = null;
        if (this.matterAllowedValues != null && this.matterAllowedValues.size() > 0) {
            allowedValues = new ArrayList<String>(this.matterAllowedValues);
        }
        if (this.clientAllowedValues != null && this.clientAllowedValues.size() > 0) {
            allowedValues = allowedValues == null ? new ArrayList<String>(this.clientAllowedValues) : CollectionUtils.intersection(allowedValues, this.clientAllowedValues);
        }
        if (this.clientPoolAllowedValues != null && this.clientPoolAllowedValues.size() > 0) {
            allowedValues = allowedValues == null ? new ArrayList<String>(this.clientPoolAllowedValues) : CollectionUtils.intersection(allowedValues, this.clientPoolAllowedValues);
        }
        if (this.parameter != null && this.parameter.getAllowedValues() != null && this.parameter.getAllowedValues().size() > 0) {
            ArrayList parameterAllowedValues = new ArrayList(this.parameter.getAllowedValues());
            allowedValues = allowedValues == null ? new ArrayList(parameterAllowedValues) : CollectionUtils.intersection(allowedValues, parameterAllowedValues);
        }
        return allowedValues;
    }

    @Override
    protected List<AllowedValueItem> getAllowedSessionParameterValueItems(Permission allowedValuesScopePermission) {
        List<String> parameterAllowedValues = this.getAllowedSessionParameterValues();
        ArrayList<AllowedValueItem> parameterAllowedValueItems = null;
        if (parameterAllowedValues != null) {
            parameterAllowedValueItems = new ArrayList<AllowedValueItem>();
            for (String allowedValue : parameterAllowedValues) {
                parameterAllowedValueItems.add(new AllowedValueItem(allowedValue));
            }
        }
        return parameterAllowedValueItems;
    }
}

