/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.allowedvalues;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.RelativityServiceSession;
import com.nuix.automate.scheduler.utils.allowedvalues.ParameterAllowedValues;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.workflow.core.utils.relativity.RelativityClient;
import com.nuix.automate.workflow.core.utils.relativity.RelativityUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RelativityFilterableObjectAllowedValues
extends ParameterAllowedValues {
    protected String relativityServiceId;
    protected BearerUser user;
    protected LinkedHashMap<String, String> parameterNameValueMap;

    public RelativityFilterableObjectAllowedValues(SchedulerApplication schedulerApplication, Parameter parameter, List<String> clientAllowedValues, List<String> matterAllowedValues, List<String> clientPoolAllowedValues, BearerUser user, Map<ParameterType, String> serviceIds, LinkedHashMap<String, String> parameterNameValueMap) {
        super(schedulerApplication, parameter, clientAllowedValues, matterAllowedValues, clientPoolAllowedValues);
        this.user = user;
        if (serviceIds != null && serviceIds.get(ParameterType.RELATIVITY_SERVICE) != null) {
            this.relativityServiceId = serviceIds.get(ParameterType.RELATIVITY_SERVICE);
        }
        this.parameterNameValueMap = parameterNameValueMap;
    }

    protected List<AllowedValueItem> filterRelativityObject() {
        if (this.relativityServiceId != null && !this.relativityServiceId.equals("")) {
            try {
                RelativityServiceSession relativityServiceSession = (RelativityServiceSession)this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(this.relativityServiceId, this.user.getId(), true);
                RelativityClient client = relativityServiceSession.getClient();
                if (relativityServiceSession.getSignedIn() && client != null) {
                    String filterParameterValue = null;
                    if (this.parameter.getRelativityCondition().getFilterParameter() != null && this.parameter.getRelativityCondition().getFilterType() != null) {
                        filterParameterValue = this.parameterNameValueMap.get(this.parameter.getRelativityCondition().getFilterParameter());
                    }
                    return RelativityUtils.getInstance().filterRelativityObjects(client, this.parameter.getRelativityCondition(), this.parameter.getParameterType(), filterParameterValue);
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot retrieve client", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected List<AllowedValueItem> getAllowedSessionParameterValueItems(Permission allowedValuesScopePermission) {
        List<String> parameterAllowedValues = this.getAllowedSessionParameterValues();
        List<AllowedValueItem> filteredRelativityObjects = this.filterRelativityObject();
        ArrayList<AllowedValueItem> parameterAllowedValueItems = new ArrayList<AllowedValueItem>();
        if (filteredRelativityObjects != null) {
            for (AllowedValueItem allowedValue : filteredRelativityObjects) {
                if (!this.matchesAllowedValues(parameterAllowedValues, allowedValue.getValue(), allowedValue.getName())) continue;
                parameterAllowedValueItems.add(allowedValue);
            }
        }
        return parameterAllowedValueItems;
    }
}

