/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.utils.benchmark;

import au.com.bytecode.opencsv.CSVWriter;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.benchmark.SqlMethod;
import com.nuix.automate.scheduler.utils.benchmark.TimingResult;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TimingCollector;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class JdbiTimingCollector
implements TimingCollector {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JdbiTimingCollector.class);
    private final String[] headers = new String[]{"ID", "SQL Verb", "Statement Type", "Raw Statement", "DAO Method", "Table Name", "Epoch", "DateTime", "Duration (\u03bcs)"};
    private List<TimingResult> timingResults;
    private SchedulerApplication schedulerApplication;
    private AtomicLong lastDump;
    Path filePath;

    public JdbiTimingCollector(SchedulerApplication schedulerApplication) {
        LOGGER.info("Debug SQL Logs on");
        this.filePath = Paths.get(schedulerApplication.getConfiguration().getDebugSqlLogsPath(), "DebugSqlLogs-" + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + ".csv");
        if (!Files.exists(this.filePath.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(this.filePath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Cannot create SQL logs folder", (Throwable)e);
            }
        }
        try (FileWriter fileWriter = new FileWriter(this.filePath.toString(), StandardCharsets.UTF_8);){
            fileWriter.write(65279);
            this.writeHeadersToCsv(fileWriter);
        }
        catch (IOException e) {
            LOGGER.error("Unable to write timing log", (Throwable)e);
        }
        this.timingResults = new ArrayList<TimingResult>();
        this.schedulerApplication = schedulerApplication;
        this.lastDump = new AtomicLong(System.currentTimeMillis());
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                JdbiTimingCollector.this.commitLogsToFile();
            }
        }, 0L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitLogsToFile() {
        ArrayList<TimingResult> buffer = new ArrayList<TimingResult>();
        List<TimingResult> list = this.timingResults;
        synchronized (list) {
            if (this.timingResults.size() > 0) {
                buffer.addAll(this.timingResults);
                this.timingResults.clear();
            }
        }
        if (buffer.size() > 0) {
            try (FileWriter fileWriter = new FileWriter(this.filePath.toString(), StandardCharsets.UTF_8, true);){
                this.writeToCsv(fileWriter, buffer);
            }
            catch (IOException e) {
                LOGGER.error("Unable to write timing log", (Throwable)e);
            }
        }
    }

    public List<TimingResult> getTimingResults() {
        return this.timingResults;
    }

    private void writeHeadersToCsv(FileWriter writer) {
        try (CSVWriter csvWriter = new CSVWriter((Writer)writer);){
            csvWriter.writeNext(this.headers);
        }
        catch (IOException e) {
            LOGGER.error("Unable to write timing log", (Throwable)e);
        }
    }

    private void writeToCsv(FileWriter writer, List<TimingResult> timingResults) {
        try (CSVWriter csvWriter = new CSVWriter((Writer)writer);){
            for (TimingResult result : timingResults) {
                String[] line = new String[]{result.getId(), result.getSqlVerb(), result.getStatementType().name(), result.getRawStatement(), result.getMethod(), result.getTableName(), String.valueOf(result.getQueryStartEpoch()), FormattingUtils.dateTimeToGMTString((DateTime)new DateTime(result.getQueryStartEpoch())), String.valueOf(result.getDuration())};
                csvWriter.writeNext(line);
            }
            csvWriter.flush();
        }
        catch (IOException e) {
            LOGGER.error("Unable to write timing log", (Throwable)e);
        }
    }

    public void cleanup() {
        this.commitLogsToFile();
    }

    public void collect(long durationNano, StatementContext context) {
        long durationMs = durationNano / 1000000L;
        long durationMicros = durationNano / 1000L;
        long startEpoch = System.currentTimeMillis() - durationMs;
    }

    private String resolveTableName(SqlMethod type, String sql) {
        if (sql.equals("")) {
            return "";
        }
        String[] querySplit = sql.toLowerCase().split(" ");
        String tableName = "";
        if (type == SqlMethod.BATCH) {
            tableName = sql.split(" ")[2];
        } else if (type == SqlMethod.QUERY || querySplit[0].equals("delete")) {
            int tableNameIndex = -1;
            for (int i = 0; i < querySplit.length; ++i) {
                if (!querySplit[i].equals("from")) continue;
                tableNameIndex = i + 1;
            }
            if (tableNameIndex != -1) {
                tableName = sql.split(" ")[tableNameIndex];
            }
        } else {
            switch (querySplit[0]) {
                case "create": 
                case "drop": 
                case "alter": {
                    if (querySplit[1].equals("table")) {
                        tableName = sql.split(" ")[2];
                    }
                    if (!querySplit[0].equals("create") || !querySplit[1].equals("index")) break;
                    int tableNameIndex = -1;
                    for (int i = 0; i < querySplit.length; ++i) {
                        if (!querySplit[i].equals("on")) continue;
                        tableNameIndex = i + 1;
                    }
                    if (tableNameIndex == -1) break;
                    tableName = sql.split(" ")[tableNameIndex];
                    break;
                }
                case "insert": {
                    tableName = sql.split(" ")[2];
                    break;
                }
                case "update": {
                    tableName = sql.split(" ")[1];
                }
            }
        }
        if (tableName != null) {
            tableName = tableName.trim();
            tableName = tableName.replace(";", "");
        }
        return tableName;
    }
}

