/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.AccountAttribute;
import com.amazonaws.services.ec2.model.AccountAttributeValue;
import com.amazonaws.services.ec2.model.AmazonEC2Exception;
import com.amazonaws.services.ec2.model.DescribeAccountAttributesResult;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceStateChange;
import com.amazonaws.services.ec2.model.InstanceStatus;
import com.amazonaws.services.ec2.model.LaunchTemplateSpecification;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.ResourceType;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.StopInstancesResult;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.resources.ResourcePoolResource;
import com.nuix.automate.scheduler.workers.CloudResourcePoolWorker;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.EngineRole;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.resourcepool.AwsResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.CloudInstanceState;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AwsResourcePoolWorker
extends CloudResourcePoolWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AwsResourcePoolWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private AmazonEC2 ec2;

    @Override
    public boolean getUsingRemoteWorkers() {
        if (this.model.getCloudSettings().getRemoteAwsSettings() != null) {
            if (this.model.getCloudSettings().getRemoteAwsSettings().getLaunchTemplateId() != null && this.model.getCloudSettings().getRemoteAwsSettings().getLaunchTemplateId().length() > 0) {
                return true;
            }
            if (this.model.getCloudSettings().getRemoteAwsSettings().getInstanceIds() != null && this.model.getCloudSettings().getRemoteAwsSettings().getInstanceIds().size() > 0) {
                return true;
            }
            if (this.model.getCloudSettings().getRemoteAwsSettings().getTagName() != null && this.model.getCloudSettings().getRemoteAwsSettings().getTagName().length() > 0) {
                return true;
            }
        }
        return false;
    }

    public AwsResourcePoolWorker(SchedulerApplication schedulerApplication, ResourcePoolResource resourcePoolResource, ResourcePoolModel model) {
        super(schedulerApplication, resourcePoolResource, model);
    }

    @Override
    public String instanceName() {
        return "Instance";
    }

    @Override
    protected void initializeLicensedCloudClient() {
        if (this.model.getCloudSettings().getAwsSettings().getSecretKey() == null || this.model.getCloudSettings().getAwsSettings().getSecretKey().length() == 0) {
            this.model.getStatus().setError(this.iu.getString("CloudResourcePoolWorker.ReenterSecretKey"));
            return;
        }
        String currentCredentials = this.model.getCloudSettings().getAwsSettings().getAccessKey() + ":" + this.model.getCloudSettings().getAwsSettings().getSecretKey() + ":" + this.model.getCloudSettings().getAwsSettings().getRegion();
        if (this.previousCredentials == null || !currentCredentials.equals(this.previousCredentials)) {
            this.currentDelay = 0L;
            this.ec2 = null;
            LOGGER.info("Account settings changed");
        }
        if (this.ec2 != null) {
            try {
                DescribeAccountAttributesResult result = this.ec2.describeAccountAttributes();
                if (result == null) {
                    LOGGER.info("Cannot get account attributes, resetting client");
                    this.ec2 = null;
                }
            }
            catch (Exception e) {
                LOGGER.info("Cannot get account attributes, resetting client", (Throwable)e);
                this.ec2 = null;
            }
        }
        if (this.ec2 != null) {
            this.cloudClientInitialized = true;
            return;
        }
        long timeSinceLastAttempt = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.lastAttemptTime;
        if (timeSinceLastAttempt > this.currentDelay) {
            this.lastAttemptTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            this.model.addLog(this.iu.getString("AwsResourcePoolWorker.Connecting"));
            BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.model.getCloudSettings().getAwsSettings().getAccessKey(), this.model.getCloudSettings().getAwsSettings().getSecretKey());
            Regions region = Regions.valueOf((String)this.model.getCloudSettings().getAwsSettings().getRegion());
            this.ec2 = (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).withRegion(region)).build();
            try {
                DescribeAccountAttributesResult result = this.ec2.describeAccountAttributes();
                if (this.previousCredentials == null || !currentCredentials.equals(this.previousCredentials)) {
                    for (AccountAttribute accountAttribute : result.getAccountAttributes()) {
                        LOGGER.info(String.valueOf(this.model) + " AWS attribute " + String.valueOf(accountAttribute));
                        StringBuilder values = new StringBuilder();
                        for (AccountAttributeValue accountAttributeValue : accountAttribute.getAttributeValues()) {
                            if (values.length() > 0) {
                                values.append(", ");
                            }
                            values.append(accountAttributeValue.getAttributeValue());
                        }
                        this.model.addLog(accountAttribute.getAttributeName() + "=" + values.toString());
                    }
                }
                this.model.getStatus().resetOkMessage(this.iu.getString("CloudResourcePoolWorker.Connected"));
                this.model.addLog(this.iu.getString("AwsResourcePoolWorker.Connected"));
                this.currentDelay = 0L;
                this.cloudClientInitialized = true;
            }
            catch (AmazonEC2Exception e) {
                this.cloudClientInitialized = false;
                LOGGER.error("Cannot initialize AWS", (Throwable)e);
                this.model.getStatus().setError(this.iu.getFormattedString("AwsResourcePoolWorker.CannotConnect", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.CannotConnect", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                this.ec2 = null;
                this.currentDelay = this.currentDelay == 0L ? this.schedulerApplication.getConfiguration().getCloudInitialErrorDelay() : (this.currentDelay *= 2L);
                this.currentDelay = Math.min(this.currentDelay, MAX_DELAY);
                LOGGER.info("Increasing delay to " + this.currentDelay);
                this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.IncreasingDelay", (Object)(this.currentDelay / 1000L)));
            }
            this.previousCredentials = currentCredentials;
        } else {
            this.cloudClientInitialized = false;
        }
    }

    @Override
    protected Set<String> getModelInstanceIds(EngineRole engineRole) {
        switch (engineRole) {
            case REMOTE: {
                if (this.model.getCloudSettings().getRemoteAwsSettings().getInstanceIds() == null) break;
                return this.model.getCloudSettings().getRemoteAwsSettings().getInstanceIds();
            }
            case MAIN: {
                if (this.model.getCloudSettings().getAwsSettings().getInstanceIds() == null) break;
                return this.model.getCloudSettings().getAwsSettings().getInstanceIds();
            }
        }
        return new HashSet<String>();
    }

    @Override
    protected String launchMainInstanceFromTemplate(JobModel job) {
        Set<String> instanceIds;
        if (this.model.getCloudSettings().getAwsSettings().getLaunchTemplateId() != null && this.model.getCloudSettings().getAwsSettings().getLaunchTemplateId().length() > 0 && (instanceIds = this.launchTemplate(this.model.getCloudSettings().getAwsSettings().getLaunchTemplateId(), EngineRole.MAIN, job, 1)) != null && instanceIds.size() > 0) {
            return instanceIds.iterator().next();
        }
        return null;
    }

    @Override
    protected Set<String> launchRemoteInstancesFromTemplate(JobModel job, int count) {
        if (this.model.getCloudSettings().getRemoteAwsSettings().getLaunchTemplateId() != null && this.model.getCloudSettings().getRemoteAwsSettings().getLaunchTemplateId().length() > 0) {
            return this.launchTemplate(this.model.getCloudSettings().getRemoteAwsSettings().getLaunchTemplateId(), EngineRole.REMOTE, job, count);
        }
        return null;
    }

    private Set<String> launchTemplate(String templateId, EngineRole engineRole, JobModel job, int instancesCount) {
        LOGGER.info("Launching new " + String.valueOf(engineRole) + " instance from template " + templateId);
        switch (engineRole) {
            case MAIN: {
                this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.LaunchingMainInstanceFromTemplate", new Object[]{templateId, job.getName()}));
                break;
            }
            case REMOTE: {
                this.model.addLog(this.iu.getNumeralFormattedString("AwsResourcePoolWorker.LaunchingRemoteInstanceFromTemplate", (long)instancesCount, new Object[]{templateId, job.getName()}));
            }
        }
        LaunchTemplateSpecification launchTemplateSpecification = new LaunchTemplateSpecification().withLaunchTemplateId(templateId);
        TagSpecification tagSpecification = new TagSpecification();
        tagSpecification.getTags().add(new Tag("automate:engine:" + engineRole.name() + ":resourcePoolId", this.model.getId()));
        tagSpecification.setResourceType(ResourceType.Instance);
        int effectiveInstancesCount = instancesCount;
        if (effectiveInstancesCount > 1 && engineRole.equals((Object)EngineRole.MAIN)) {
            LOGGER.warn("Asked to start more than " + effectiveInstancesCount + " main instances. Reverting back to 1 instance");
            effectiveInstancesCount = 1;
        }
        RunInstancesRequest request = new RunInstancesRequest().withLaunchTemplate(launchTemplateSpecification).withMinCount(Integer.valueOf(effectiveInstancesCount)).withMaxCount(Integer.valueOf(effectiveInstancesCount)).withTagSpecifications(new TagSpecification[]{tagSpecification});
        RunInstancesResult result = this.ec2.runInstances(request);
        HashSet<String> instanceIds = new HashSet<String>();
        for (Instance instance : result.getReservation().getInstances()) {
            instanceIds.add(instance.getInstanceId());
            LOGGER.info("Launched " + String.valueOf(engineRole) + " instance " + instance.getInstanceId());
            switch (engineRole) {
                case MAIN: {
                    this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.LaunchedMainInstance", (Object)instance.getInstanceId()));
                    break;
                }
                case REMOTE: {
                    this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.LaunchedRemoteInstance", (Object)instance.getInstanceId()));
                }
            }
        }
        return instanceIds;
    }

    @Override
    protected String getInstancePublicDnsName(String instanceId) {
        try {
            Instance instanceDetails = this.getInstanceDetails(instanceId);
            if (this.schedulerApplication.getConfiguration().getAwsInstanceConnectUsingPublicDns() && instanceDetails.getPublicDnsName() != null && instanceDetails.getPublicDnsName().length() > 0) {
                return instanceDetails.getPublicDnsName();
            }
            if (this.schedulerApplication.getConfiguration().getAwsInstanceConnectUsingPublicIp() && instanceDetails.getPublicIpAddress() != null && instanceDetails.getPublicIpAddress().length() > 0) {
                return instanceDetails.getPublicIpAddress();
            }
            if (this.schedulerApplication.getConfiguration().getAwsInstanceConnectUsingPrivateDns() && instanceDetails.getPrivateDnsName() != null && instanceDetails.getPrivateDnsName().length() > 0) {
                return instanceDetails.getPrivateDnsName();
            }
            if (this.schedulerApplication.getConfiguration().getAwsInstanceConnectUsingPrivateIp() && instanceDetails.getPrivateIpAddress() != null && instanceDetails.getPrivateIpAddress().length() > 0) {
                return instanceDetails.getPrivateIpAddress();
            }
        }
        catch (Exception e) {
            LOGGER.error(String.valueOf(this.model) + " Cannot get instance " + instanceId + " DNS/IP", (Throwable)e);
            this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.CannotGetInstanceDetails", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
        }
        return null;
    }

    private Instance getInstanceDetails(String instanceId) {
        try {
            HashSet<String> instanceIds = new HashSet<String>();
            instanceIds.add(instanceId);
            DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest();
            describeInstancesRequest.setInstanceIds(instanceIds);
            boolean done = false;
            while (!done) {
                DescribeInstancesResult describeInstancesResult = this.ec2.describeInstances(describeInstancesRequest);
                for (Reservation reservation : describeInstancesResult.getReservations()) {
                    for (Instance instance : reservation.getInstances()) {
                        if (!instance.getInstanceId().equals(instanceId)) continue;
                        return instance;
                    }
                }
                describeInstancesRequest.setNextToken(describeInstancesResult.getNextToken());
                if (describeInstancesResult.getNextToken() != null) continue;
                done = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get instance details", (Throwable)e);
            this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.CannotGetInstanceDetails", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            this.ec2 = null;
        }
        return null;
    }

    @Override
    protected Map<String, CloudInstanceState> getInstanceStates(Set<String> instanceIds) {
        HashMap<String, CloudInstanceState> instanceStates = new HashMap<String, CloudInstanceState>();
        try {
            Map<String, InstanceState> awsInstanceStates = this.getAwsInstanceStates(instanceIds);
            for (String instanceId : awsInstanceStates.keySet()) {
                CloudInstanceState instanceState = CloudInstanceState.OTHER;
                InstanceState awsInstanceState = awsInstanceStates.get(instanceId);
                if (this.isRunning(awsInstanceState)) {
                    instanceState = CloudInstanceState.RUNNING;
                } else if (this.isTerminated(awsInstanceState)) {
                    instanceState = CloudInstanceState.TERMINATED;
                } else if (this.isStopped(awsInstanceState)) {
                    instanceState = CloudInstanceState.STOPPED;
                } else if (this.isPending(awsInstanceState)) {
                    instanceState = CloudInstanceState.PENDING;
                }
                instanceStates.put(instanceId, instanceState);
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get instance details", (Throwable)e);
            this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.CannotGetInstanceDetails", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            this.ec2 = null;
        }
        return instanceStates;
    }

    private boolean isRunning(InstanceState instanceState) {
        int lowByteCode = instanceState.getCode() % 256;
        return lowByteCode == 16;
    }

    private boolean isTerminated(InstanceState instanceState) {
        int lowByteCode = instanceState.getCode() % 256;
        return lowByteCode == 48;
    }

    private boolean isStopped(InstanceState instanceState) {
        int lowByteCode = instanceState.getCode() % 256;
        return lowByteCode == 80;
    }

    private boolean isPending(InstanceState instanceState) {
        int lowByteCode = instanceState.getCode() % 256;
        return lowByteCode == 0;
    }

    private Map<String, InstanceState> getAwsInstanceStates(Set<String> instanceIds) {
        DescribeInstanceStatusRequest describeInstanceStatusRequest = new DescribeInstanceStatusRequest();
        describeInstanceStatusRequest.setInstanceIds(instanceIds);
        describeInstanceStatusRequest.setIncludeAllInstances(Boolean.valueOf(true));
        HashMap<String, InstanceState> response = new HashMap<String, InstanceState>();
        boolean done = false;
        while (!done) {
            DescribeInstanceStatusResult describeInstanceStatusResult = this.ec2.describeInstanceStatus(describeInstanceStatusRequest);
            for (InstanceStatus instanceStatus : describeInstanceStatusResult.getInstanceStatuses()) {
                if (!instanceIds.contains(instanceStatus.getInstanceId())) continue;
                response.put(instanceStatus.getInstanceId(), instanceStatus.getInstanceState());
            }
            describeInstanceStatusRequest.setNextToken(describeInstanceStatusResult.getNextToken());
            if (describeInstanceStatusResult.getNextToken() != null) continue;
            done = true;
        }
        return response;
    }

    @Override
    protected void startInstance(String instanceId, EngineRole engineRole, JobModel job) {
        LOGGER.info("Starting " + String.valueOf(engineRole) + " instance " + instanceId);
        switch (engineRole) {
            case MAIN: {
                this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.StartingMainInstance", new Object[]{instanceId, job.getName()}));
                break;
            }
            case REMOTE: {
                this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.StartingRemoteInstance", new Object[]{instanceId, job.getName()}));
            }
        }
        StartInstancesRequest request = new StartInstancesRequest().withInstanceIds(new String[]{instanceId});
        StartInstancesResult result = this.ec2.startInstances(request);
        for (InstanceStateChange instanceStateChange : result.getStartingInstances()) {
            LOGGER.info("Started instance: " + String.valueOf(instanceStateChange));
        }
    }

    @Override
    protected void stopInstance(String instanceId, EngineRole engineRole) {
        LOGGER.info("Stopping " + String.valueOf(engineRole) + " instance " + instanceId);
        switch (engineRole) {
            case MAIN: {
                this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.StoppingMainInstance", (Object)instanceId));
                break;
            }
            case REMOTE: {
                this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.StoppingRemoteInstance", (Object)instanceId));
            }
        }
        StopInstancesRequest request = new StopInstancesRequest().withInstanceIds(new String[]{instanceId});
        StopInstancesResult result = this.ec2.stopInstances(request);
        for (InstanceStateChange instanceStateChange : result.getStoppingInstances()) {
            LOGGER.info("Stopped instance: " + String.valueOf(instanceStateChange));
        }
    }

    @Override
    protected void terminateInstance(String instanceId, EngineRole engineRole) {
        LOGGER.info("Terminating " + String.valueOf(engineRole) + " instance " + instanceId);
        switch (engineRole) {
            case MAIN: {
                this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.TerminatingMainInstance", (Object)instanceId));
                break;
            }
            case REMOTE: {
                this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.TerminatingRemoteInstance", (Object)instanceId));
            }
        }
        TerminateInstancesRequest request = new TerminateInstancesRequest().withInstanceIds(new String[]{instanceId});
        TerminateInstancesResult result = this.ec2.terminateInstances(request);
        for (InstanceStateChange instanceStateChange : result.getTerminatingInstances()) {
            LOGGER.info("Terminated instance: " + String.valueOf(instanceStateChange));
        }
    }

    @Override
    protected Set<String> getLaunchedInstanceIdsByTag(EngineRole engineRole) {
        HashSet<String> instanceIds = new HashSet<String>();
        try {
            ArrayList<String> tagValues = new ArrayList<String>();
            tagValues.add(this.model.getId());
            Filter filter = new Filter("tag:rampiva:engine:" + engineRole.name() + ":resourcePoolId", tagValues);
            DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest().withFilters(new Filter[]{filter});
            boolean done = false;
            while (!done) {
                DescribeInstancesResult describeInstancesResult = this.ec2.describeInstances(describeInstancesRequest);
                for (Reservation reservation : describeInstancesResult.getReservations()) {
                    for (Instance instance : reservation.getInstances()) {
                        instanceIds.add(instance.getInstanceId());
                    }
                }
                describeInstancesRequest.setNextToken(describeInstancesResult.getNextToken());
                if (describeInstancesResult.getNextToken() != null) continue;
                done = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get " + String.valueOf(engineRole) + " instance details", (Throwable)e);
            this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.CannotListInstances", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            this.ec2 = null;
        }
        return instanceIds;
    }

    @Override
    protected Set<String> getInstancesWithTags(EngineRole engineRole) {
        HashSet<String> instanceIds = new HashSet<String>();
        try {
            AwsResourcePoolSettings awsSettings = null;
            switch (engineRole) {
                case MAIN: {
                    awsSettings = this.model.getCloudSettings().getAwsSettings();
                    break;
                }
                case REMOTE: {
                    awsSettings = this.model.getCloudSettings().getRemoteAwsSettings();
                }
            }
            ArrayList<String> tagValues = new ArrayList<String>();
            tagValues.add(awsSettings.getTagValue());
            if (awsSettings.getTagName() == null || awsSettings.getTagName().length() == 0 || awsSettings.getTagValue() == null) {
                return instanceIds;
            }
            Filter filter = new Filter("tag:" + awsSettings.getTagName(), tagValues);
            DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest().withFilters(new Filter[]{filter});
            boolean done = false;
            while (!done) {
                DescribeInstancesResult describeInstancesResult = this.ec2.describeInstances(describeInstancesRequest);
                for (Reservation reservation : describeInstancesResult.getReservations()) {
                    for (Instance instance : reservation.getInstances()) {
                        instanceIds.add(instance.getInstanceId());
                    }
                }
                describeInstancesRequest.setNextToken(describeInstancesResult.getNextToken());
                if (describeInstancesResult.getNextToken() != null) continue;
                done = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get " + String.valueOf(engineRole) + " instance details", (Throwable)e);
            this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.CannotListInstances", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            this.ec2 = null;
        }
        return instanceIds;
    }
}

