/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.management.profile.AzureProfile;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.compute.models.PowerState;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.compute.models.VirtualMachineCustomImage;
import com.azure.resourcemanager.compute.models.VirtualMachineEvictionPolicyTypes;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkInterface;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.resources.ResourcePoolResource;
import com.nuix.automate.scheduler.utils.AzureEnv;
import com.nuix.automate.scheduler.utils.AzureEnvironmentUtils;
import com.nuix.automate.scheduler.workers.CloudResourcePoolWorker;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.EngineRole;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.resourcepool.AzureResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.CloudInstanceState;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AzureResourcePoolWorker
extends CloudResourcePoolWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AzureResourcePoolWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private AzureResourceManager azureResourceManager;
    private Set<VirtualMachine> vms;
    private Map<String, Thread> vmsCompletableTasks;
    private int pingCount = 0;
    private int errorCount = 0;
    private int maxErrorCount = 10;
    private long timerInterval;
    private String subscriptionId;

    public AzureResourcePoolWorker(SchedulerApplication schedulerApplication, ResourcePoolResource resourcePoolResource, ResourcePoolModel model) {
        super(schedulerApplication, resourcePoolResource, model);
        this.timerInterval = schedulerApplication.getConfiguration().getCloudPingInterval();
    }

    @Override
    public boolean getUsingRemoteWorkers() {
        if (this.model.getCloudSettings().getRemoteAzureSettings() != null) {
            if (this.model.getCloudSettings().getRemoteAzureSettings().getCustomVmImageId() != null && this.model.getCloudSettings().getRemoteAzureSettings().getCustomVmImageId().length() > 0) {
                return true;
            }
            if (this.model.getCloudSettings().getRemoteAzureSettings().getVmNames() != null && this.model.getCloudSettings().getRemoteAzureSettings().getVmNames().size() > 0) {
                return true;
            }
            if (this.model.getCloudSettings().getRemoteAzureSettings().getTagName() != null && this.model.getCloudSettings().getRemoteAzureSettings().getTagName().length() > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected String launchMainInstanceFromTemplate(JobModel job) {
        Set<String> instanceIds;
        if (this.model.getCloudSettings().getAzureSettings().getCustomVmImageId() != null && this.model.getCloudSettings().getAzureSettings().getCustomVmImageId().length() > 0 && (instanceIds = this.launchTemplate(this.model.getCloudSettings().getAzureSettings(), EngineRole.MAIN, job, 1)) != null && instanceIds.size() > 0) {
            return instanceIds.iterator().next();
        }
        return null;
    }

    @Override
    protected Set<String> launchRemoteInstancesFromTemplate(JobModel job, int count) {
        if (this.model.getCloudSettings().getRemoteAzureSettings().getCustomVmImageId() != null && this.model.getCloudSettings().getRemoteAzureSettings().getCustomVmImageId().length() > 0) {
            return this.launchTemplate(this.model.getCloudSettings().getRemoteAzureSettings(), EngineRole.REMOTE, job, count);
        }
        return null;
    }

    private Set<String> launchTemplate(AzureResourcePoolSettings azureResourcePoolSettings, EngineRole engineRole, JobModel job, int instancesCount) {
        HashSet<String> instanceIds = new HashSet<String>();
        String tagName = "automate:engine:" + engineRole.name() + ":resourcePoolId";
        String tagValue = this.model.getId();
        try {
            block18: for (int i = 0; i < instancesCount; ++i) {
                LOGGER.info("Launching new " + String.valueOf(engineRole) + " instance from template " + azureResourcePoolSettings.getCustomVmImageId());
                switch (engineRole) {
                    case MAIN: {
                        this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.LaunchingMainVMFromImage", new Object[]{azureResourcePoolSettings.getCustomVmImageId(), job.getName()}));
                        break;
                    }
                    case REMOTE: {
                        this.model.addLog(this.iu.getNumeralFormattedString("AzureResourcePoolWorker.LaunchingRemoteVMFromImage", (long)instancesCount, new Object[]{azureResourcePoolSettings.getCustomVmImageId(), job.getName()}));
                    }
                }
                String containerName = azureResourcePoolSettings.getCustomVmImageId() + "-" + UidUtils.getShortId((String)UidUtils.getRandom());
                if (azureResourcePoolSettings.getCustomVmPassword() == null || azureResourcePoolSettings.getCustomVmPassword().length() == 0) {
                    throw new IllegalArgumentException(this.iu.getString("CloudResourcePoolWorker.ReenterKey"));
                }
                LOGGER.info("Getting custom image ...");
                VirtualMachineCustomImage virtualMachineCustomImage = (VirtualMachineCustomImage)this.azureResourceManager.virtualMachineCustomImages().getByResourceGroup(azureResourcePoolSettings.getResourceGroupId(), azureResourcePoolSettings.getCustomVmImageId());
                LOGGER.info("Got custom image " + String.valueOf(virtualMachineCustomImage));
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.GotCustomVmImage", (Object)virtualMachineCustomImage));
                LOGGER.info("Getting network ...");
                Network network = (Network)this.azureResourceManager.networks().getByResourceGroup(azureResourcePoolSettings.getResourceGroupId(), azureResourcePoolSettings.getNetworkName());
                LOGGER.info("Got network " + network.id());
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.GotNetwork", (Object)FormattingUtils.getLastSubstring((String)network.id(), (String)"/")));
                NetworkSecurityGroup networkSecurityGroup = null;
                if (azureResourcePoolSettings.getNetworkSecurityGroup() != null && azureResourcePoolSettings.getNetworkSecurityGroup().length() > 0) {
                    networkSecurityGroup = (NetworkSecurityGroup)this.azureResourceManager.networkSecurityGroups().getByResourceGroup(azureResourcePoolSettings.getResourceGroupId(), azureResourcePoolSettings.getNetworkSecurityGroup());
                    LOGGER.info("Got networkSecurityGroup " + networkSecurityGroup.id());
                    this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.GotNetworkSecurityGroup", (Object)FormattingUtils.getLastSubstring((String)networkSecurityGroup.id(), (String)"/")));
                }
                boolean usePublicIp = this.schedulerApplication.getConfiguration().getAzureVmConnectUsingPublicIp();
                LOGGER.info("Creating network interface ...");
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.CreatingNetworkInterfaceOnNetwork", (Object)FormattingUtils.getLastSubstring((String)network.id(), (String)"/")));
                NetworkInterface networkInterface = null;
                NetworkInterface.DefinitionStages.WithCreate networkInterfaceWithCreate = ((NetworkInterface.DefinitionStages.WithPrimaryNetwork)((NetworkInterface.DefinitionStages.WithGroup)((NetworkInterface.DefinitionStages.Blank)this.azureResourceManager.networkInterfaces().define(containerName + "-nic")).withRegion(AzureEnvironmentUtils.getRegionIdFromNameOrLabel(azureResourcePoolSettings.getRegion()))).withExistingResourceGroup(azureResourcePoolSettings.getResourceGroupId())).withExistingPrimaryNetwork(network).withSubnet(azureResourcePoolSettings.getNetworkSubnetName()).withPrimaryPrivateIPAddressDynamic();
                if (networkSecurityGroup != null) {
                    networkInterfaceWithCreate = networkInterfaceWithCreate.withExistingNetworkSecurityGroup(networkSecurityGroup);
                }
                if (usePublicIp) {
                    networkInterfaceWithCreate = networkInterfaceWithCreate.withNewPrimaryPublicIPAddress();
                }
                networkInterface = (NetworkInterface)((NetworkInterface.DefinitionStages.WithCreate)networkInterfaceWithCreate.withTag(tagName, tagValue)).create();
                LOGGER.info("Created network interface " + networkInterface.id());
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.CreateNetworkInterface", (Object)FormattingUtils.getLastSubstring((String)networkInterface.id(), (String)"/")));
                VirtualMachine virtualMachine = null;
                try {
                    this.model.addLog(this.iu.getString("AzureResourcePoolWorker.CreatingVM"));
                    LOGGER.info("Creating virtual machine ...");
                    switch (azureResourcePoolSettings.getVmType()) {
                        case SPOT: {
                            virtualMachine = (VirtualMachine)((VirtualMachine.DefinitionStages.WithCreate)((VirtualMachine.DefinitionStages.WithNetwork)((VirtualMachine.DefinitionStages.WithGroup)((VirtualMachine.DefinitionStages.Blank)this.azureResourceManager.virtualMachines().define(containerName)).withRegion(AzureEnvironmentUtils.getRegionIdFromNameOrLabel(azureResourcePoolSettings.getRegion()))).withExistingResourceGroup(azureResourcePoolSettings.getResourceGroupId())).withExistingPrimaryNetworkInterface(networkInterface).withGeneralizedWindowsCustomImage(virtualMachineCustomImage.id()).withAdminUsername(azureResourcePoolSettings.getCustomVmUsername()).withAdminPassword(azureResourcePoolSettings.getCustomVmPassword()).withSpotPriority(VirtualMachineEvictionPolicyTypes.DELETE).withMaxPrice(Double.valueOf(1.0)).withSize(azureResourcePoolSettings.getVmSize()).withOSDiskSizeInGB(azureResourcePoolSettings.getDiskSize().intValue()).withTag(tagName, tagValue)).create();
                            break;
                        }
                        case ON_DEMAND: {
                            virtualMachine = (VirtualMachine)((VirtualMachine.DefinitionStages.WithCreate)((VirtualMachine.DefinitionStages.WithNetwork)((VirtualMachine.DefinitionStages.WithGroup)((VirtualMachine.DefinitionStages.Blank)this.azureResourceManager.virtualMachines().define(containerName)).withRegion(AzureEnvironmentUtils.getRegionIdFromNameOrLabel(azureResourcePoolSettings.getRegion()))).withExistingResourceGroup(azureResourcePoolSettings.getResourceGroupId())).withExistingPrimaryNetworkInterface(networkInterface).withGeneralizedWindowsCustomImage(virtualMachineCustomImage.id()).withAdminUsername(azureResourcePoolSettings.getCustomVmUsername()).withAdminPassword(azureResourcePoolSettings.getCustomVmPassword()).withSize(azureResourcePoolSettings.getVmSize()).withOSDiskSizeInGB(azureResourcePoolSettings.getDiskSize().intValue()).withTag(tagName, tagValue)).create();
                        }
                    }
                }
                catch (Exception e) {
                    this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.CannotCreateVm", (Object)e.getMessage()));
                    LOGGER.warn("Error creating VM, attempting to delete resources", (Throwable)e);
                    Exception lastDeletionException = null;
                    for (int deleteAttempt = 0; deleteAttempt < this.schedulerApplication.getConfiguration().getAzureVmMaxDeleteAttempts(); ++deleteAttempt) {
                        try {
                            String publicIpId = null;
                            if (usePublicIp) {
                                publicIpId = networkInterface.primaryIPConfiguration().getPublicIpAddress().id();
                            }
                            this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.AttemptingToDeleteNetworkInterface", (Object)FormattingUtils.getLastSubstring((String)networkInterface.id(), (String)"/")));
                            LOGGER.info("Attempt " + (deleteAttempt + 1) + "/" + this.schedulerApplication.getConfiguration().getAzureVmMaxDeleteAttempts() + " to delete network interface " + networkInterface.id());
                            this.azureResourceManager.networkInterfaces().deleteById(networkInterface.id());
                            if (publicIpId != null) {
                                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.AttemptingToDeletePublicIp", (Object)FormattingUtils.getLastSubstring((String)publicIpId, (String)"/")));
                                LOGGER.info("Attempt " + (deleteAttempt + 1) + "/" + this.schedulerApplication.getConfiguration().getAzureVmMaxDeleteAttempts() + " to delete public IP");
                                this.azureResourceManager.publicIpAddresses().deleteById(publicIpId);
                            }
                            this.model.addLog(this.iu.getString("AzureResourcePoolWorker.SuccessfullyDeletedNetworkResources"));
                            LOGGER.info("Successfully deleted VM resources");
                            lastDeletionException = null;
                            break;
                        }
                        catch (Exception e2) {
                            lastDeletionException = e2;
                            LOGGER.warn("Cannot delete network interface, retrying in " + this.schedulerApplication.getConfiguration().getAzureVmDeleteAttemptsInterval() + " ms ...", (Throwable)e2);
                            Thread.sleep(this.schedulerApplication.getConfiguration().getAzureVmDeleteAttemptsInterval());
                            continue;
                        }
                    }
                    if (lastDeletionException != null) {
                        this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.FailedDeletingNetworkResources", (Object)e.getMessage()));
                    }
                    throw e;
                }
                String vmId = virtualMachine.id();
                String vmName = vmId.substring(vmId.lastIndexOf(47) + 1);
                LOGGER.info("Launched " + String.valueOf(engineRole) + " VM " + vmName);
                instanceIds.add(vmName);
                switch (engineRole) {
                    case MAIN: {
                        this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.LaunchedMainVM", (Object)vmName));
                        continue block18;
                    }
                    case REMOTE: {
                        this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.LaunchedRemoteVM", (Object)vmName));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot start VM", (Throwable)e);
            this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.ErrorCreatingVm", (Object)FormattingUtils.getExceptionPrintableMessage((Exception)e)));
        }
        return instanceIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackInstanceWork(String instanceId, Thread t) {
        Map<String, Thread> map = this.vmsCompletableTasks;
        synchronized (map) {
            boolean taskCompleted;
            LOGGER.info(String.valueOf(this.model) + " Tracking task " + t.getName());
            Thread thread = this.vmsCompletableTasks.get(instanceId);
            if (thread != null) {
                LOGGER.error(String.valueOf(this.model) + " ERROR: Unexpected task in queue for " + instanceId);
            }
            try {
                if (t.isAlive()) {
                    t.join(1L);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error(String.valueOf(this.model) + " Cannot wait for task to complete");
            }
            boolean bl = taskCompleted = !t.isAlive();
            if (!taskCompleted) {
                this.vmsCompletableTasks.put(instanceId, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVmReadyForCommands(String instanceId) {
        Map<String, Thread> map = this.vmsCompletableTasks;
        synchronized (map) {
            boolean vmIsReady;
            Thread t = this.vmsCompletableTasks.get(instanceId);
            if (t == null) {
                return true;
            }
            try {
                if (t.isAlive()) {
                    t.join(1L);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error(String.valueOf(this.model) + " Cannot wait for task to complete");
            }
            boolean bl = vmIsReady = !t.isAlive();
            if (!vmIsReady) {
                LOGGER.info(String.valueOf(this.model) + " VM " + instanceId + " is busy with task: " + t.getName());
            } else {
                this.vmsCompletableTasks.remove(instanceId);
            }
            return vmIsReady;
        }
    }

    @Override
    public String instanceName() {
        return "VM";
    }

    @Override
    protected void initializeLicensedCloudClient() {
        if (this.model.getCloudSettings().getAzureSettings().getKey() == null || this.model.getCloudSettings().getAzureSettings().getKey().length() == 0) {
            this.model.getStatus().setError(this.iu.getString("CloudResourcePoolWorker.ReenterKey"));
            return;
        }
        int poolsPerSubscriptionId = 0;
        for (ResourcePoolModel resourcePool : this.schedulerApplication.getResourcePoolResource().getResourcePools()) {
            String subscriptionId;
            if (resourcePool.getCloudSettings() == null || !resourcePool.getActive().booleanValue() || resourcePool.getCloudSettings().getAzureSettings() == null || (subscriptionId = resourcePool.getCloudSettings().getAzureSettings().getSubscriptionId()) == null || !this.model.getCloudSettings().getAzureSettings().getSubscriptionId().equals(subscriptionId)) continue;
            ++poolsPerSubscriptionId;
        }
        long desiredTimerInterval = (long)poolsPerSubscriptionId * this.schedulerApplication.getConfiguration().getCloudPingInterval();
        if (this.timerInterval != desiredTimerInterval) {
            this.model.addLog(this.iu.getNumeralFormattedString("AzureResourcePoolWorker.UpdatingTimerInterval", (long)poolsPerSubscriptionId, (Object)(desiredTimerInterval / 1000L)));
            this.timerInterval = desiredTimerInterval;
        }
        ++this.pingCount;
        if (this.pingCount < poolsPerSubscriptionId) {
            return;
        }
        this.pingCount = 0;
        String currentCredentials = this.model.getCloudSettings().getAzureSettings().getKey() + ":" + this.model.getCloudSettings().getAzureSettings().getAppId() + ":" + this.model.getCloudSettings().getAzureSettings().getTenant() + ":" + this.model.getCloudSettings().getAzureSettings().getSubscriptionId() + ":" + this.model.getCloudSettings().getAzureSettings().getEnvironment() + ":" + this.model.getActive();
        if (this.previousCredentials == null || !currentCredentials.equals(this.previousCredentials)) {
            this.currentDelay = 0L;
            this.azureResourceManager = null;
            LOGGER.info(String.valueOf(this.model) + " Account settings changed");
        }
        if (this.azureResourceManager != null) {
            this.refreshVms();
            return;
        }
        if (this.vmsCompletableTasks != null) {
            LOGGER.info(String.valueOf(this.model) + " Cancelling previous tasks");
            for (String instanceId : this.vmsCompletableTasks.keySet()) {
                Thread t = this.vmsCompletableTasks.get(instanceId);
                if (t == null || !t.isAlive()) continue;
                LOGGER.info(String.valueOf(this.model) + " Interrupting " + t.getName());
                t.interrupt();
            }
        }
        this.vmsCompletableTasks = new ConcurrentHashMap<String, Thread>();
        long timeSinceLastAttempt = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.lastAttemptTime;
        if (timeSinceLastAttempt > this.currentDelay) {
            this.lastAttemptTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            AzureResourcePoolSettings azureSettings = this.model.getCloudSettings().getAzureSettings();
            ClientSecretCredential credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(azureSettings.getAppId())).clientSecret(azureSettings.getKey()).tenantId(azureSettings.getTenant())).build();
            AzureEnv environmnet = AzureEnvironmentUtils.resolveEnvironmentFromName(azureSettings.getEnvironment());
            this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.ConnectingToEnvironment", (Object)environmnet.toString()));
            AzureProfile azureProfile = new AzureProfile(azureSettings.getTenant(), azureSettings.getSubscriptionId(), environmnet.getAzureEnvironment());
            try {
                if (azureSettings.getSubscriptionId() != null && azureSettings.getSubscriptionId().length() > 0) {
                    this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.ConnectingToAzureSubscription", (Object)azureSettings.getSubscriptionId()));
                    this.azureResourceManager = ((AzureResourceManager.Configurable)AzureResourceManager.configure().withLogLevel(HttpLogDetailLevel.NONE)).authenticate((TokenCredential)credential, azureProfile).withSubscription(azureSettings.getSubscriptionId());
                } else {
                    this.model.addLog(this.iu.getString("AzureResourcePoolWorker.ConnectingToAzureSubscriptionDefault"));
                    this.azureResourceManager = ((AzureResourceManager.Configurable)AzureResourceManager.configure().withLogLevel(HttpLogDetailLevel.NONE)).authenticate((TokenCredential)credential, azureProfile).withDefaultSubscription();
                }
                if (this.azureResourceManager.getCurrentSubscription() == null || this.azureResourceManager.getCurrentSubscription().subscriptionId() == null) {
                    this.model.getStatus().setError(this.iu.getFormattedString("AzureResourcePoolWorker.SubscriptionNotFound", (Object)this.model.getCloudSettings().getAzureSettings().getSubscriptionId()));
                    throw new IOException(this.iu.getFormattedString("AzureResourcePoolWorker.SubscriptionNotFound", (Object)this.model.getCloudSettings().getAzureSettings().getSubscriptionId()));
                }
                this.subscriptionId = this.azureResourceManager.getCurrentSubscription().subscriptionId();
                LOGGER.info(String.valueOf(this.model) + " Connected to Azure subscription " + this.azureResourceManager.getCurrentSubscription().displayName());
                this.model.getStatus().resetOkMessage(this.iu.getString("CloudResourcePoolWorker.Connected"));
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.ConnectedToSubscription", new Object[]{this.azureResourceManager.getCurrentSubscription().subscriptionId(), this.azureResourceManager.getCurrentSubscription().displayName()}));
                this.refreshVms();
                this.currentDelay = 0L;
                this.cloudClientInitialized = true;
            }
            catch (Exception e) {
                this.cloudClientInitialized = false;
                this.model.getStatus().setError(this.iu.getFormattedString("AzureResourcePoolWorker.CannotConnect", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                LOGGER.error(String.valueOf(this.model) + " Cannot initialize Azure", (Throwable)e);
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.CannotConnect", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                this.azureResourceManager = null;
                this.currentDelay = this.currentDelay == 0L ? this.schedulerApplication.getConfiguration().getCloudInitialErrorDelay() : (this.currentDelay *= 2L);
                this.currentDelay = Math.min(this.currentDelay, MAX_DELAY);
                LOGGER.info(String.valueOf(this.model) + " Increasing delay to " + this.currentDelay);
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.IncreasingDelay", (Object)(this.currentDelay / 1000L)));
            }
            this.previousCredentials = currentCredentials;
        } else {
            this.cloudClientInitialized = false;
        }
    }

    @Override
    protected Set<String> getModelInstanceIds(EngineRole engineRole) {
        switch (engineRole) {
            case REMOTE: {
                if (this.model.getCloudSettings().getRemoteAzureSettings().getVmNames() == null) break;
                return this.model.getCloudSettings().getRemoteAzureSettings().getVmNames();
            }
            case MAIN: {
                if (this.model.getCloudSettings().getAzureSettings().getVmNames() == null) break;
                return this.model.getCloudSettings().getAzureSettings().getVmNames();
            }
        }
        return new HashSet<String>();
    }

    private void refreshVms() {
        LOGGER.debug("Refreshing VMs");
        try {
            new ConcurrentHashMap();
            this.vms = ConcurrentHashMap.newKeySet();
            this.azureResourceManager.virtualMachines().listAsync().map(virtualMachine -> {
                this.vms.add((VirtualMachine)virtualMachine);
                return virtualMachine;
            }).blockLast();
            this.cloudClientInitialized = true;
        }
        catch (Exception e) {
            this.cloudClientInitialized = false;
            LOGGER.error("Cannot refresh Azure VMs");
        }
        LOGGER.debug("Got " + this.vms.size() + " VMs");
    }

    private VirtualMachine getVm(String instanceId) {
        for (VirtualMachine vm : this.vms) {
            try {
                String vmId = vm.id();
                String vmName = vmId.substring(vmId.lastIndexOf(47) + 1);
                if (!instanceId.equals(vmId) && !instanceId.equals(vmName)) continue;
                return vm;
            }
            catch (Exception e) {
                LOGGER.error(String.valueOf(this.model) + " Cannot get VM " + String.valueOf(vm) + " name.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected String getInstancePublicDnsName(String instanceId) {
        block5: {
            try {
                VirtualMachine vm = this.getVm(instanceId);
                if (vm != null) {
                    if (this.schedulerApplication.getConfiguration().getAzureVmConnectUsingPublicIp() && vm.getPrimaryPublicIPAddress() != null && vm.getPrimaryPublicIPAddress().ipAddress() != null) {
                        return vm.getPrimaryPublicIPAddress().ipAddress();
                    }
                    if (this.schedulerApplication.getConfiguration().getAzureVmConnectUsingPrivateIp() && vm.getPrimaryNetworkInterface() != null && vm.getPrimaryNetworkInterface().primaryIPConfiguration() != null && vm.getPrimaryNetworkInterface().primaryIPConfiguration().privateIpAddress() != null) {
                        return vm.getPrimaryNetworkInterface().primaryIPConfiguration().privateIpAddress();
                    }
                    return instanceId;
                }
                this.errorCount = 0;
            }
            catch (Exception e) {
                LOGGER.error(String.valueOf(this.model) + " Cannot get instance " + instanceId + " public DNS/IP", (Throwable)e);
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.CannotGetVMDetails", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                ++this.errorCount;
                if (this.errorCount <= this.maxErrorCount) break block5;
                LOGGER.info("Detected " + this.errorCount + " consecutive errors, reconnecting");
                this.errorCount = 0;
                this.azureResourceManager = null;
            }
        }
        return null;
    }

    @Override
    protected Map<String, CloudInstanceState> getInstanceStates(Set<String> instanceIds) {
        HashMap<String, CloudInstanceState> results;
        block15: {
            results = new HashMap<String, CloudInstanceState>();
            try {
                for (String instanceId : instanceIds) {
                    if (instanceId == null) continue;
                    try {
                        VirtualMachine vm = this.getVm(instanceId);
                        if (vm == null) continue;
                        CloudInstanceState cloudInstanceState = CloudInstanceState.OTHER;
                        if (this.isVmReadyForCommands(instanceId) && vm.powerState() != null) {
                            if (vm.powerState().equals((Object)PowerState.RUNNING)) {
                                cloudInstanceState = CloudInstanceState.RUNNING;
                            } else if (vm.powerState().equals((Object)PowerState.STOPPED)) {
                                cloudInstanceState = CloudInstanceState.STOPPED;
                            } else if (vm.powerState().equals((Object)PowerState.STARTING)) {
                                cloudInstanceState = CloudInstanceState.PENDING;
                            } else if (vm.powerState().equals((Object)PowerState.DEALLOCATED)) {
                                cloudInstanceState = CloudInstanceState.STOPPED;
                            } else if (vm.powerState().equals((Object)PowerState.DEALLOCATING)) {
                                cloudInstanceState = CloudInstanceState.PENDING;
                            }
                        }
                        results.put(instanceId, cloudInstanceState);
                    }
                    catch (Exception e) {
                        LOGGER.error(String.valueOf(this.model) + " Cannot get instance " + instanceId + " state", (Throwable)e);
                        this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.CannotGetVMDetails", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                    }
                }
                this.errorCount = 0;
            }
            catch (Exception e) {
                LOGGER.error(String.valueOf(this.model) + " Cannot get instances state", (Throwable)e);
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.CannotGetVMDetails", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                ++this.errorCount;
                if (this.errorCount <= this.maxErrorCount) break block15;
                LOGGER.info("Detected " + this.errorCount + " consecutive errors, reconnecting");
                this.errorCount = 0;
                this.azureResourceManager = null;
            }
        }
        return results;
    }

    @Override
    protected void startInstance(String instanceId, EngineRole engineRole, JobModel job) {
        if (!this.isVmReadyForCommands(instanceId)) {
            LOGGER.info(String.valueOf(this.model) + " Skip trying to Start instance " + instanceId + " because it's busy");
            return;
        }
        VirtualMachine vm = this.getVm(instanceId);
        if (vm != null) {
            this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.StartingVm", (Object)instanceId));
            Thread thread = new Thread(() -> {
                LOGGER.info(String.valueOf(this.model) + " Start Starting VM " + instanceId + " async");
                vm.start();
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.StartedVm", (Object)instanceId));
                LOGGER.info(String.valueOf(this.model) + " Finished Starting VM " + instanceId + " async");
            });
            thread.setName("Instance " + instanceId + " start");
            thread.start();
            this.trackInstanceWork(instanceId, thread);
        }
    }

    @Override
    protected void stopInstance(String instanceId, EngineRole engineRole) {
        if (!this.isVmReadyForCommands(instanceId)) {
            LOGGER.info(String.valueOf(this.model) + " Skip trying to Deallocate instance " + instanceId + " because it's busy");
            return;
        }
        VirtualMachine vm = this.getVm(instanceId);
        if (vm != null) {
            this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.DeallocatingVm", (Object)instanceId));
            Thread thread = new Thread(() -> {
                LOGGER.info(String.valueOf(this.model) + " Start Deallocating VM " + instanceId + " async");
                vm.deallocate();
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.DeallocatedVm", (Object)instanceId));
                LOGGER.info(String.valueOf(this.model) + " Finished Deallocating VM " + instanceId + " async");
            });
            thread.setName("Instance " + instanceId + " deallocate");
            thread.start();
            this.trackInstanceWork(instanceId, thread);
        }
    }

    @Override
    protected void terminateInstance(String instanceId, EngineRole engineRole) {
        if (!this.isVmReadyForCommands(instanceId)) {
            LOGGER.info(String.valueOf(this.model) + " Skip trying to Delete instance " + instanceId + " because it's busy");
            return;
        }
        VirtualMachine vm = this.getVm(instanceId);
        if (vm != null) {
            this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.DeletingVm", (Object)instanceId));
            Thread thread = new Thread(() -> {
                String osDiskId = vm.osDiskId();
                String networkInterfaceId = vm.getPrimaryNetworkInterface().id();
                String publicIpId = null;
                PublicIpAddress publicIpAddress = vm.getPrimaryNetworkInterface().primaryIPConfiguration().getPublicIpAddress();
                if (publicIpAddress != null) {
                    publicIpId = publicIpAddress.id();
                }
                LOGGER.info(String.valueOf(this.model) + " Start Deleting VM " + instanceId);
                this.azureResourceManager.virtualMachines().deleteById(vm.id());
                try {
                    if (osDiskId != null) {
                        LOGGER.info(String.valueOf(this.model) + " Start Deleting VM Disk" + osDiskId);
                        this.azureResourceManager.disks().deleteById(osDiskId);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Cannot delete disk", (Throwable)e);
                    this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.WarningWhileDeleting", (Object)FormattingUtils.getExceptionPrintableMessage((Exception)e)));
                }
                try {
                    if (networkInterfaceId != null) {
                        LOGGER.info(String.valueOf(this.model) + " Start Deleting VM Network Interface" + networkInterfaceId);
                        this.azureResourceManager.networkInterfaces().deleteById(networkInterfaceId);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Cannot delete network interface", (Throwable)e);
                    this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.WarningWhileDeleting", (Object)FormattingUtils.getExceptionPrintableMessage((Exception)e)));
                }
                try {
                    if (publicIpId != null) {
                        LOGGER.info(String.valueOf(this.model) + " Start Deleting VM Public IP" + publicIpId);
                        this.azureResourceManager.publicIpAddresses().deleteById(publicIpId);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Cannot delete public IP", (Throwable)e);
                    this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.WarningWhileDeleting", (Object)FormattingUtils.getExceptionPrintableMessage((Exception)e)));
                }
                this.model.addLog(this.iu.getFormattedString("AzureResourcePoolWorker.DeletedVm", (Object)instanceId));
                LOGGER.info(String.valueOf(this.model) + " Finished deleting VM " + instanceId + " async");
            });
            thread.setName("Instance " + instanceId + " delete");
            thread.start();
            this.trackInstanceWork(instanceId, thread);
        }
    }

    @Override
    protected Set<String> getLaunchedInstanceIdsByTag(EngineRole engineRole) {
        HashSet<String> instanceIds = new HashSet<String>();
        try {
            String tagName = "automate:engine:" + engineRole.name() + ":resourcePoolId";
            String tagValue = this.model.getId();
            return this.getInstancesWithTags(tagName, tagValue);
        }
        catch (Exception e) {
            LOGGER.error("Cannot get " + String.valueOf(engineRole) + " instance details", (Throwable)e);
            this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.CannotListInstances", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            return instanceIds;
        }
    }

    @Override
    protected Set<String> getInstancesWithTags(EngineRole engineRole) {
        HashSet<String> instanceIds = new HashSet<String>();
        try {
            AzureResourcePoolSettings azureSettings = null;
            switch (engineRole) {
                case MAIN: {
                    azureSettings = this.model.getCloudSettings().getAzureSettings();
                    break;
                }
                case REMOTE: {
                    azureSettings = this.model.getCloudSettings().getRemoteAzureSettings();
                }
            }
            return this.getInstancesWithTags(azureSettings.getTagName(), azureSettings.getTagValue());
        }
        catch (Exception e) {
            LOGGER.error("Cannot get " + String.valueOf(engineRole) + " instances by tags", (Throwable)e);
            this.model.addLog(this.iu.getFormattedString("AwsResourcePoolWorker.CannotListInstances", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            return instanceIds;
        }
    }

    private Set<String> getInstancesWithTags(String filterTagName, String filterTagValue) {
        HashSet<String> instanceIds = new HashSet<String>();
        if (filterTagName == null || filterTagName.length() == 0 || filterTagValue == null) {
            return instanceIds;
        }
        for (VirtualMachine vm : this.vms) {
            try {
                String tagValue = (String)vm.tags().get(filterTagName);
                if (!filterTagValue.equals(tagValue)) continue;
                String vmId = vm.id();
                String vmName = vmId.substring(vmId.lastIndexOf(47) + 1);
                instanceIds.add(vmName);
            }
            catch (Exception e) {
                LOGGER.error(String.valueOf(this.model) + " Cannot test VM " + String.valueOf(vm) + " tags.", (Throwable)e);
            }
        }
        return instanceIds;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }
}

