/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.resources.ResourcePoolResource;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.utils.TagsUtil;
import com.nuix.automate.scheduler.workers.ResourcePoolWorker;
import com.nuix.automate.scheduler.workers.ServerWorker;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ServerException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.LocalizedEnum;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.EngineRole;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.api.resourcepool.InstanceIdleAction;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.server.ServerStatus;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.job.BootstrappableJob;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.job.RemoteWorkersSpecModel;
import com.nuix.automate.utils.models.internal.resourcepool.CloudInstanceState;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.ExecutionState;
import jakarta.ws.rs.core.Response;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class CloudResourcePoolWorker
extends ResourcePoolWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CloudResourcePoolWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private Map<String, String> jobsToMainInstances = new HashMap<String, String>();
    private Map<String, String> mainInstancesToJobs = new HashMap<String, String>();
    private Set<String> mainLaunchedInstanceIds = null;
    private Set<String> remoteLaunchedInstanceIds = new HashSet<String>();
    private boolean isLicensed;
    private Map<String, Long> serversFirstAddEngineDate = new HashMap<String, Long>();
    private Set<String> mainInstanceIds;
    protected String previousCredentials;
    protected long lastAttemptTime;
    protected long currentDelay;
    protected static long MAX_DELAY = 3600000L;
    protected static long MASK_SERVER_ERRORS_TIME = 300000L;
    protected boolean cloudClientInitialized;

    public abstract String instanceName();

    @Override
    public void onBeforeDelete() throws IllegalStateException {
        if (this.jobsToMainInstances.size() > 0) {
            throw new IllegalStateException(this.iu.getFormattedString("CloudResourcePoolWorker.PoolManagingActive", new Object[]{this.instanceName(), String.join((CharSequence)", ", this.jobsToMainInstances.values())}));
        }
        JobModel pendingJob = this.getUnassignedPendingJob();
        if (pendingJob != null) {
            throw new IllegalStateException(this.iu.getFormattedString("CloudResourcePoolWorker.PoolPendingHandlingJob", (Object)pendingJob.getName()));
        }
        try {
            this.timer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initializeCloudClient() {
        this.cloudClientInitialized = false;
        boolean isLicensed = false;
        try {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.CLOUD_RESOURCE_POOLS);
            isLicensed = true;
        }
        catch (LicenceValidationException e) {
            this.model.getStatus().reset();
            this.model.getStatus().setError(e.getMessage());
        }
        if (isLicensed) {
            this.initializeLicensedCloudClient();
            this.timeout = this.schedulerApplication.getConfiguration().getCloudResourcePoolTimeout();
        }
    }

    protected abstract void initializeLicensedCloudClient();

    protected abstract Set<String> getModelInstanceIds(EngineRole var1);

    public CloudResourcePoolWorker(SchedulerApplication schedulerApplication, ResourcePoolResource resourcePoolResource, ResourcePoolModel model) {
        super(schedulerApplication, resourcePoolResource, model);
        model.clearLog();
        this.timer.schedule((TimerTask)this, 0L, schedulerApplication.getConfiguration().getCloudPingInterval());
        this.timeout = schedulerApplication.getConfiguration().getCloudResourcePoolTimeout();
    }

    private void persistMainInstancesToJobs() {
        this.schedulerApplication.getSettingsResource().putCategorySetting("CloudResourcePoolInstances", this.model.getId(), this.mainInstancesToJobs);
    }

    private String getResourceName(String instanceId) {
        return this.model.getType().toString() + "-" + instanceId;
    }

    private ServerWorker getServerWorker(String instanceId) {
        for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
            if (!TagsUtil.hasTagValue(TagsUtil.CLOUD_INSTANCE_ID, instanceId, serverWorker.getModel().getTags()) || !TagsUtil.hasTagValue(TagsUtil.CLOUD_PROVIDER, this.model.getType().name(), serverWorker.getModel().getTags())) continue;
            return serverWorker;
        }
        return null;
    }

    protected abstract String launchMainInstanceFromTemplate(JobModel var1);

    protected abstract Set<String> launchRemoteInstancesFromTemplate(JobModel var1, int var2);

    protected abstract String getInstancePublicDnsName(String var1);

    private ServerWorker addServer(String instanceId, EngineRole engineRole) throws GeneralSecurityException {
        Response response;
        Server server = new Server();
        server.setName(this.getResourceName(instanceId));
        String serverPublicDnsName = this.getInstancePublicDnsName(instanceId);
        if (serverPublicDnsName == null) {
            this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.ServerDoesNotHavePublicIP", (Object)server));
            return null;
        }
        server.setUrl("https://" + serverPublicDnsName);
        server.setWhitelistedCertFingerprints(this.model.getCloudSettings().getWhitelistedCertFingerprints());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(TagsUtil.CLOUD_INSTANCE_ID, instanceId);
        tags.put(TagsUtil.CLOUD_PROVIDER, this.model.getType().name());
        tags.put(TagsUtil.RESOURCE_POOL_ID, this.model.getId());
        tags.put(TagsUtil.ENGINE_ROLE, engineRole.name());
        server.setTags(tags);
        SystemBearerUser user = new SystemBearerUser();
        LOGGER.info(String.valueOf(this.model) + " - Adding " + String.valueOf(server));
        Long serverFirstAddEngineDate = this.serversFirstAddEngineDate.get(instanceId);
        if (serverFirstAddEngineDate == null) {
            this.serversFirstAddEngineDate.put(instanceId, DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        }
        if (serverFirstAddEngineDate == null || DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - serverFirstAddEngineDate > MASK_SERVER_ERRORS_TIME) {
            this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.InitializingServer", (Object)server));
        }
        if ((response = this.schedulerApplication.getServerResource().addServer(user, server, false, true)).getEntity() instanceof TranslationResponseStatus) {
            TranslationResponseStatus statusModel = (TranslationResponseStatus)response.getEntity();
            StringBuilder errorMessage = new StringBuilder(statusModel.getKey());
            for (String key : statusModel.getValues().keySet()) {
                errorMessage.append(", ").append(key).append(": ").append((String)statusModel.getValues().get(key));
            }
            if (errorMessage.toString().contains("fingerprint") || serverFirstAddEngineDate != null && DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - serverFirstAddEngineDate > MASK_SERVER_ERRORS_TIME) {
                this.model.addLog(errorMessage.toString());
            }
            LOGGER.info(String.valueOf(this.model) + " - Error adding server, " + String.valueOf(errorMessage));
        }
        LOGGER.info("Server " + server.getName() + " status: " + response.getEntity().toString());
        return this.getServerWorker(instanceId);
    }

    private EngineModel getEngineModel(ServerWorker serverWorker, String instanceId) {
        String serverId = serverWorker.getModel().getId();
        Collection<EngineModel> engines = this.schedulerApplication.getSchedulerEnginesResource().getEnginesFromServerId(serverId);
        if (engines != null) {
            for (EngineModel engineModel : engines) {
                if (!TagsUtil.hasTagValue(TagsUtil.CLOUD_INSTANCE_ID, instanceId, engineModel.getTags()) || !TagsUtil.hasTagValue(TagsUtil.CLOUD_PROVIDER, this.model.getType().name(), engineModel.getTags())) continue;
                return engineModel;
            }
        }
        return null;
    }

    private EngineModel addEngine(ServerWorker serverWorker, String instanceId, EngineRole engineRole) {
        EngineModel engineModel = new EngineModel();
        engineModel.setName(this.getResourceName(instanceId));
        engineModel.setServerId(serverWorker.getModel().getId());
        engineModel.setSupportedExecutionMode(ExecutionMode.AUTOMATE_NUIX);
        switch (engineRole) {
            case MAIN: {
                engineModel.setTargetNuixWorkers(this.model.getCloudSettings().getTargetNuixWorkers());
                engineModel.setMinNuixWorkers(this.model.getCloudSettings().getMinNuixWorkers());
                engineModel.setNuixLicenceSourceId(this.model.getCloudSettings().getNuixLicenceSourceId());
                break;
            }
            case REMOTE: {
                engineModel.setTargetNuixWorkers(this.model.getCloudSettings().getRemoteTargetNuixWorkers());
                engineModel.setMinNuixWorkers(this.model.getCloudSettings().getRemoteMinNuixWorkers());
                engineModel.setNuixLicenceSourceId(this.model.getCloudSettings().getRemoteNuixLicenceSourceId());
            }
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(TagsUtil.CLOUD_INSTANCE_ID, instanceId);
        tags.put(TagsUtil.CLOUD_PROVIDER, this.model.getType().name());
        tags.put(TagsUtil.RESOURCE_POOL_ID, this.model.getId());
        tags.put(TagsUtil.ENGINE_ROLE, engineRole.name());
        engineModel.setTags(tags);
        SystemBearerUser user = new SystemBearerUser();
        this.schedulerApplication.getSchedulerEnginesResource().schedulerAddEngine(user, engineModel);
        return this.getEngineModel(serverWorker, instanceId);
    }

    protected abstract Map<String, CloudInstanceState> getInstanceStates(Set<String> var1);

    protected abstract void startInstance(String var1, EngineRole var2, JobModel var3);

    private void removeServer(String instanceId) {
        SystemBearerUser user = new SystemBearerUser();
        ServerWorker serverWorker = this.getServerWorker(instanceId);
        if (serverWorker != null) {
            LOGGER.info("Removing server " + serverWorker.getModel().getName());
            this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.RemovingServer", (Object)serverWorker.getModel().getName()));
            this.schedulerApplication.getServerResource().deleteServer(user, serverWorker.getModel().getId());
        }
        this.serversFirstAddEngineDate.remove(instanceId);
    }

    protected abstract void stopInstance(String var1, EngineRole var2);

    protected abstract void terminateInstance(String var1, EngineRole var2);

    private void submitJobToEngine(ServerWorker serverWorker, JobModel jobModel, EngineModel engineModel) {
        LOGGER.info(String.valueOf(this.model) + " - Preparing to send " + String.valueOf(jobModel) + " to " + String.valueOf(engineModel));
        if (engineModel.getStatus() == EngineStatus.STANDBY) {
            this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.SendingJob", new Object[]{jobModel.getName(), engineModel.getName()}));
            LOGGER.info(String.valueOf(this.model) + " - Bootstraping  " + String.valueOf(jobModel) + " to " + String.valueOf(engineModel));
            try {
                jobModel.setLastStateChangedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
                jobModel.setEngineId(engineModel.getId());
                this.resolveObjectNames(serverWorker, jobModel, engineModel);
                BootstrappableJob bootstrappableJob = this.schedulerApplication.getJobResource().getBootstrappableJob(jobModel);
                if (!this.getUsingRemoteWorkers()) {
                    bootstrappableJob.getJobModel().setRemoteWorkersSpec(new RemoteWorkersSpecModel());
                }
                serverWorker.bootstrapJob(engineModel.getId(), bootstrappableJob);
                this.ranJob = true;
            }
            catch (ServerException e) {
                LOGGER.error(String.valueOf(this.model) + " Cannot send " + String.valueOf(jobModel) + " to " + String.valueOf(engineModel), (Throwable)e);
                this.schedulerApplication.getJobResource().clearJobBootstrapState(jobModel.getId());
                this.schedulerApplication.getJobResource().resolveJobNames(jobModel);
            }
        } else {
            LOGGER.warn(String.valueOf(this.model) + " Cannot send " + String.valueOf(jobModel) + " to " + String.valueOf(engineModel) + " did not initialize in time");
        }
    }

    private JobModel getUnassignedPendingJob() {
        JobModel pendingJob;
        block5: {
            pendingJob = null;
            try {
                if (this.model.getActive() == null || !this.model.getActive().booleanValue()) break block5;
                BootstrappableJob bootstrappableJob = null;
                try {
                    bootstrappableJob = this.schedulerApplication.getJobResource().getNotStartedJobForResourcePool(this.model.getId(), false);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot get bootstrappable Job", (Throwable)e);
                }
                if (bootstrappableJob != null && (pendingJob = bootstrappableJob.getJobModel()) != null && this.jobsToMainInstances.containsKey(pendingJob.getId())) {
                    pendingJob = null;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot get unassigned job", (Throwable)e);
            }
        }
        return pendingJob;
    }

    protected abstract Set<String> getLaunchedInstanceIdsByTag(EngineRole var1);

    protected abstract Set<String> getInstancesWithTags(EngineRole var1);

    @Override
    protected void manageWork() {
        if (!this.model.getActive().booleanValue()) {
            return;
        }
        try {
            JobModel pendingJob;
            CloudInstanceState state;
            String instanceUrl;
            ServerWorker serverWorker;
            this.initializeCloudClient();
            if (!this.cloudClientInitialized) {
                return;
            }
            if (this.mainLaunchedInstanceIds == null) {
                this.mainLaunchedInstanceIds = new HashSet<String>();
                Map storedMainInstancesToJobs = this.schedulerApplication.getSettingsResource().getCategorySetting("CloudResourcePoolInstances", this.model.getId(), Map.class);
                if (storedMainInstancesToJobs != null) {
                    HashSet<String> dissapearedInstances = new HashSet<String>();
                    Map<String, CloudInstanceState> mainLaunchedInstanceStates = this.getInstanceStates(storedMainInstancesToJobs.keySet());
                    for (Map.Entry entry : storedMainInstancesToJobs.entrySet()) {
                        String instanceId = (String)entry.getKey();
                        String jobId = (String)entry.getValue();
                        boolean pairActive = true;
                        CloudInstanceState instanceState = mainLaunchedInstanceStates.get(instanceId);
                        if (instanceState != null) {
                            if (instanceState.equals((Object)CloudInstanceState.TERMINATED)) {
                                pairActive = false;
                            }
                        } else {
                            pairActive = false;
                        }
                        if (!pairActive) {
                            LOGGER.info("Instance " + instanceId + " previously tracked could not be found");
                            dissapearedInstances.add(instanceId);
                            continue;
                        }
                        this.mainInstancesToJobs.put((String)entry.getKey(), (String)entry.getValue());
                        this.jobsToMainInstances.put((String)entry.getValue(), (String)entry.getKey());
                        serverWorker = this.getServerWorker(instanceId);
                        if (serverWorker != null && serverWorker.getModel().getStatus() != ServerStatus.INITIALIZED) {
                            instanceUrl = "https://" + this.getInstancePublicDnsName(instanceId);
                            if (!serverWorker.getModel().getUrl().equals(instanceUrl)) {
                                LOGGER.info(this.instanceName() + " " + instanceId + " had associated server with incorrect URL");
                                this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.ServerChangedUrl", (Object)serverWorker.getModel().getName()));
                                this.removeServer(instanceId);
                                serverWorker = null;
                            }
                        }
                        if (serverWorker != null) continue;
                        try {
                            serverWorker = this.addServer(instanceId, EngineRole.MAIN);
                        }
                        catch (GeneralSecurityException e) {
                            LOGGER.warn("Cannot add server");
                        }
                        if (serverWorker == null) continue;
                        for (EngineModel engineModel : serverWorker.getEngineModels()) {
                            try {
                                serverWorker.deleteEngine(engineModel.getId());
                            }
                            catch (Exception e) {
                                LOGGER.error("Cannot remove engine", (Throwable)e);
                            }
                        }
                    }
                    for (String string : dissapearedInstances) {
                        storedMainInstancesToJobs.remove(string);
                    }
                    this.schedulerApplication.getSettingsResource().putCategorySetting("CloudResourcePoolInstances", this.model.getId(), storedMainInstancesToJobs);
                }
            }
            HashSet<String> seenInstanceIds = new HashSet<String>();
            this.mainInstanceIds = new HashSet<String>();
            this.mainInstanceIds.addAll(this.getModelInstanceIds(EngineRole.MAIN));
            this.mainInstanceIds.addAll(this.mainLaunchedInstanceIds);
            this.mainInstanceIds.addAll(this.getLaunchedInstanceIdsByTag(EngineRole.MAIN));
            this.mainInstanceIds.addAll(this.getInstancesWithTags(EngineRole.MAIN));
            int runningOrPendingCount = 0;
            Map<String, CloudInstanceState> instanceStates = this.getInstanceStates(this.mainInstanceIds);
            for (String instanceId : this.mainInstanceIds) {
                String previouslyAssignedJobId;
                state = instanceStates.get(instanceId);
                if (state == null || !state.equals((Object)CloudInstanceState.TERMINATED) || (previouslyAssignedJobId = this.mainInstancesToJobs.get(instanceId)) == null) continue;
                JobDetailsModel jobModel = this.schedulerApplication.getJobResource().getJobDetailsModel(previouslyAssignedJobId);
                if (jobModel != null && jobModel.getSettings().getExecutionState() == ExecutionState.PENDING) {
                    jobModel.getSettings().setExecutionState(ExecutionState.NOT_STARTED);
                }
                this.jobsToMainInstances.remove(previouslyAssignedJobId);
                this.mainInstancesToJobs.remove(instanceId);
                this.persistMainInstancesToJobs();
            }
            for (String instanceId : this.mainInstanceIds) {
                pendingJob = this.getUnassignedPendingJob();
                try {
                    state = instanceStates.get(instanceId);
                    if (state == null) {
                        LOGGER.error(this.instanceName() + " " + instanceId + " was not found");
                        this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.InstanceNotFound", new Object[]{this.instanceName(), instanceId}));
                        continue;
                    }
                    if (!state.equals((Object)CloudInstanceState.TERMINATED)) {
                        seenInstanceIds.add(instanceId);
                    }
                    if (state.equals((Object)CloudInstanceState.RUNNING)) {
                        ++runningOrPendingCount;
                        String jobId = this.mainInstancesToJobs.get(instanceId);
                        if (jobId != null) {
                            JobDetailsModel jobDetails = this.schedulerApplication.getJobResource().getJobDetailsModel(jobId);
                            if (jobDetails == null) {
                                LOGGER.info("Job " + jobId + " was removed from the queue before it could start");
                                this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.JobRemovedBeforeCouldStart", (Object)jobId));
                                this.jobsToMainInstances.remove(jobId);
                                this.mainInstancesToJobs.remove(instanceId);
                                this.persistMainInstancesToJobs();
                                jobId = null;
                            }
                            if (!this.model.getId().equals(jobDetails.getSettings().getResourcePoolId())) {
                                LOGGER.info("Job " + jobDetails.getSettings().getName() + " was switched to a different resource pool");
                                this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.JobSwitchedToDifferentPool", (Object)jobDetails.getSettings().getName()));
                                this.jobsToMainInstances.remove(jobId);
                                this.mainInstancesToJobs.remove(instanceId);
                                this.persistMainInstancesToJobs();
                                jobId = null;
                            } else {
                                if (jobDetails.getSettings().getExecutionState() == ExecutionState.ERROR || jobDetails.getSettings().getExecutionState() == ExecutionState.STOPPED || jobDetails.getSettings().getExecutionState() == ExecutionState.FINISHED || jobDetails.getSettings().getExecutionState() == ExecutionState.CANCELLED) {
                                    LOGGER.info(this.instanceName() + " " + instanceId + " is running but job " + jobId + " completed");
                                    this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.JobAssignedToInstanceEnded", new Object[]{jobDetails.getSettings().getName(), instanceId, new LocalizedEnum((Enum)jobDetails.getSettings().getExecutionState()).toString()}));
                                    this.mainInstancesToJobs.remove(instanceId);
                                    this.jobsToMainInstances.remove(jobId);
                                    this.persistMainInstancesToJobs();
                                    if (this.model.getCloudSettings().getForceIdleActionBetweenJobs() == null || !this.model.getCloudSettings().getForceIdleActionBetweenJobs().booleanValue()) continue;
                                    if (this.model.getCloudSettings().getInstanceIdleAction() == InstanceIdleAction.STOP) {
                                        this.removeServer(instanceId);
                                        this.stopInstance(instanceId, EngineRole.MAIN);
                                        continue;
                                    }
                                    if (this.model.getCloudSettings().getInstanceIdleAction() != InstanceIdleAction.TERMINATE) continue;
                                    this.mainLaunchedInstanceIds.remove(instanceId);
                                    this.removeServer(instanceId);
                                    this.terminateInstance(instanceId, EngineRole.MAIN);
                                    continue;
                                }
                                if (jobDetails.getSettings().getExecutionState() == ExecutionState.NOT_STARTED || jobDetails.getSettings().getExecutionState() == ExecutionState.PENDING) {
                                    jobDetails.getSettings().setExecutionState(ExecutionState.PENDING);
                                    serverWorker = this.getServerWorker(instanceId);
                                    if (serverWorker != null && serverWorker.getModel().getStatus() != ServerStatus.INITIALIZED) {
                                        instanceUrl = "https://" + this.getInstancePublicDnsName(instanceId);
                                        if (!serverWorker.getModel().getUrl().equals(instanceUrl)) {
                                            LOGGER.info(this.instanceName() + " " + instanceId + " had associated server with incorrect URL");
                                            this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.ServerChangedUrl", (Object)serverWorker.getModel().getName()));
                                            this.removeServer(instanceId);
                                            serverWorker = null;
                                        }
                                    }
                                    if (serverWorker == null && (serverWorker = this.addServer(instanceId, EngineRole.MAIN)) != null) {
                                        LOGGER.info("Server " + instanceId + " was added. Removing old engines.");
                                        this.deleteServerEngines(serverWorker);
                                    }
                                    if (serverWorker != null && !serverWorker.isUserDataDirSyncActive()) {
                                        EngineModel engineModel = this.getEngineModel(serverWorker, instanceId);
                                        if (engineModel == null) {
                                            LOGGER.info("Preparing to add engine to server " + instanceId + ". Removing old engines.");
                                            this.deleteServerEngines(serverWorker);
                                            engineModel = this.addEngine(serverWorker, instanceId, EngineRole.MAIN);
                                        } else {
                                            EngineModel updatedEngineModel = new EngineModel(engineModel);
                                            updatedEngineModel.setTargetNuixWorkers(this.model.getCloudSettings().getTargetNuixWorkers());
                                            updatedEngineModel.setMinNuixWorkers(this.model.getCloudSettings().getMinNuixWorkers());
                                            updatedEngineModel.setNuixLicenceSourceId(this.model.getCloudSettings().getNuixLicenceSourceId());
                                            updatedEngineModel.setSupportedExecutionMode(ExecutionMode.AUTOMATE_NUIX);
                                            try {
                                                serverWorker.updateEngine(engineModel.getId(), updatedEngineModel);
                                                serverWorker.reloadEnginesFromServer();
                                            }
                                            catch (ServerException serverException) {
                                                // empty catch block
                                            }
                                        }
                                        if (engineModel != null) {
                                            this.submitJobToEngine(serverWorker, jobDetails.getSettings(), engineModel);
                                        }
                                    }
                                }
                            }
                        }
                        if (jobId != null) continue;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Instance " + instanceId + " is running and no jobs are assigned to it");
                        }
                        if (pendingJob != null) {
                            LOGGER.info("Assigning pending job " + pendingJob.getName() + " to running " + this.instanceName() + " " + instanceId);
                            this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.AssigningPendingJobToRunning", new Object[]{pendingJob.getName(), this.instanceName(), instanceId}));
                            this.jobsToMainInstances.put(pendingJob.getId(), instanceId);
                            this.mainInstancesToJobs.put(instanceId, pendingJob.getId());
                            this.persistMainInstancesToJobs();
                            continue;
                        }
                        if (this.model.getCloudSettings().getInstanceIdleAction() == InstanceIdleAction.STOP) {
                            this.removeServer(instanceId);
                            this.stopInstance(instanceId, EngineRole.MAIN);
                            continue;
                        }
                        if (this.model.getCloudSettings().getInstanceIdleAction() != InstanceIdleAction.TERMINATE) continue;
                        this.mainLaunchedInstanceIds.remove(instanceId);
                        this.removeServer(instanceId);
                        this.terminateInstance(instanceId, EngineRole.MAIN);
                        continue;
                    }
                    if (state.equals((Object)CloudInstanceState.STOPPED)) {
                        if (pendingJob == null) continue;
                        LOGGER.info("Assigning pending job " + String.valueOf(pendingJob) + " to stopped " + this.instanceName() + " " + instanceId);
                        this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.AssigningPendingJobToStopped", new Object[]{pendingJob.getName(), this.instanceName(), instanceId}));
                        this.jobsToMainInstances.put(pendingJob.getId(), instanceId);
                        this.mainInstancesToJobs.put(instanceId, pendingJob.getId());
                        this.persistMainInstancesToJobs();
                        this.startInstance(instanceId, EngineRole.MAIN, pendingJob);
                        continue;
                    }
                    if (!state.equals((Object)CloudInstanceState.PENDING)) continue;
                    ++runningOrPendingCount;
                }
                catch (Exception e) {
                    LOGGER.error("Cannot handle " + this.instanceName() + " " + instanceId, (Throwable)e);
                    this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.CannotHandleInstance", new Object[]{this.instanceName(), instanceId, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                }
            }
            pendingJob = this.getUnassignedPendingJob();
            if (pendingJob != null) {
                String assignedInstanceId;
                String launchedInstanceId;
                boolean launchAzureInstance;
                boolean bl = this.model.getCloudSettings().getAwsSettings() != null && this.model.getCloudSettings().getAwsSettings().getLaunchTemplateId() != null && (this.model.getCloudSettings().getAwsSettings().getMaxConcurrentInstances() == null || this.model.getCloudSettings().getAwsSettings().getMaxConcurrentInstances() > runningOrPendingCount);
                boolean bl2 = launchAzureInstance = this.model.getCloudSettings().getAzureSettings() != null && this.model.getCloudSettings().getAzureSettings().getCustomVmImageId() != null && (this.model.getCloudSettings().getAzureSettings().getMaxConcurrentInstances() == null || this.model.getCloudSettings().getAzureSettings().getMaxConcurrentInstances() > runningOrPendingCount);
                if ((bl || launchAzureInstance) && (launchedInstanceId = this.launchMainInstanceFromTemplate(pendingJob)) != null) {
                    ++runningOrPendingCount;
                    this.mainLaunchedInstanceIds.add(launchedInstanceId);
                    seenInstanceIds.add(launchedInstanceId);
                    this.jobsToMainInstances.put(pendingJob.getId(), launchedInstanceId);
                    this.mainInstancesToJobs.put(launchedInstanceId, pendingJob.getId());
                    this.persistMainInstancesToJobs();
                    if (pendingJob.getExecutionState() == ExecutionState.NOT_STARTED) {
                        pendingJob.setExecutionState(ExecutionState.PENDING);
                    }
                }
                if ((assignedInstanceId = this.jobsToMainInstances.get(pendingJob.getId())) != null && !seenInstanceIds.contains(assignedInstanceId)) {
                    LOGGER.info("Job " + pendingJob.getName() + " assigned " + this.instanceName() + " " + assignedInstanceId + " disappeared, untracking.");
                    this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.JobAssignedDisappeared", new Object[]{pendingJob.getName(), this.instanceName(), assignedInstanceId}));
                    this.jobsToMainInstances.remove(pendingJob.getId());
                    if (pendingJob.getExecutionState() == ExecutionState.PENDING) {
                        pendingJob.setExecutionState(ExecutionState.NOT_STARTED);
                    }
                    this.mainInstancesToJobs.remove(assignedInstanceId);
                    this.persistMainInstancesToJobs();
                }
            }
            for (ServerWorker serverWorker2 : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
                String originatingInstanceId;
                if (!TagsUtil.hasTagValue(TagsUtil.RESOURCE_POOL_ID, this.model.getId(), serverWorker2.getModel().getTags()) || !TagsUtil.hasTagValue(TagsUtil.ENGINE_ROLE, EngineRole.MAIN.name(), serverWorker2.getModel().getTags()) || (originatingInstanceId = (String)serverWorker2.getModel().getTags().get(TagsUtil.CLOUD_INSTANCE_ID)) == null || seenInstanceIds.contains(originatingInstanceId)) continue;
                LOGGER.info("Detected orphaned server " + serverWorker2.getModel().getName());
                this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.DetectedOrphanedServer", (Object)serverWorker2.getModel().getName()));
                this.removeServer(originatingInstanceId);
            }
            this.handleRemoteEngines();
        }
        catch (Throwable e) {
            LOGGER.error("Cannot manage work", e);
            this.model.addLog(ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
        }
    }

    private void deleteServerEngines(ServerWorker serverWorker) {
        try {
            serverWorker.reloadEnginesFromServer();
            for (EngineModel engineModel : serverWorker.getEngineModels()) {
                try {
                    serverWorker.deleteEngine(engineModel.getId());
                }
                catch (Exception e) {
                    LOGGER.error("Cannot remove engine", (Throwable)e);
                }
            }
        }
        catch (ServerException e) {
            LOGGER.error("Cannot get server engines", (Throwable)e);
        }
    }

    private void handleRemoteEngines() {
        if (!this.cloudClientInitialized) {
            return;
        }
        HashSet<String> seenInstanceIds = new HashSet<String>();
        HashSet<String> instanceIds = new HashSet<String>();
        instanceIds.addAll(this.getModelInstanceIds(EngineRole.REMOTE));
        instanceIds.addAll(this.remoteLaunchedInstanceIds);
        instanceIds.addAll(this.getLaunchedInstanceIdsByTag(EngineRole.REMOTE));
        instanceIds.addAll(this.getInstancesWithTags(EngineRole.REMOTE));
        for (String instanceId : instanceIds) {
            if (!this.mainInstanceIds.contains(instanceId)) continue;
            LOGGER.debug("Ignoring Remote Worker instance " + instanceId + " because it also has the role Engine");
        }
        instanceIds.removeAll(this.mainInstanceIds);
        Map<String, CloudInstanceState> instanceStates = this.getInstanceStates(instanceIds);
        int runningOrPendingCount = 0;
        JobDetailsModel jobRequireRemoteEngines = null;
        if (this.model.getCloudSettings().getUseRemoteEngines().booleanValue()) {
            List<JobDetailsModel> runningJobs = this.getRunningJobs();
            for (JobDetailsModel runningJob : runningJobs) {
                if (!this.schedulerApplication.getJobResource().jobHasUnfulfilledWorkers(runningJob)) continue;
                jobRequireRemoteEngines = runningJob;
                break;
            }
        }
        boolean remoteInstancesEligibleForIdleAction = true;
        long backlogJobsCount = -1L;
        long runningJobsCount = -1L;
        if (this.model.getCloudSettings().getRemoteNoIdleBeforeFirstJob().booleanValue() && !this.ranJob) {
            remoteInstancesEligibleForIdleAction = false;
        } else if (this.model.getCloudSettings().getRemoteNoIdleDuringJob().booleanValue()) {
            backlogJobsCount = this.schedulerApplication.getJobResource().getBacklogJobsForResourcePoolCount(this.model.getId());
            runningJobsCount = this.schedulerApplication.getJobResource().getRunningJobsForResourcePoolCount(this.model.getId());
            if (backlogJobsCount > 0L) {
                remoteInstancesEligibleForIdleAction = false;
            } else if (runningJobsCount > 0L) {
                remoteInstancesEligibleForIdleAction = false;
            }
        }
        for (String instanceId : instanceIds) {
            try {
                CloudInstanceState state = instanceStates.get(instanceId);
                if (state == null) {
                    LOGGER.error(this.instanceName() + " " + instanceId + " was not found");
                    this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.InstanceNotFound", new Object[]{this.instanceName(), instanceId}));
                    continue;
                }
                if (!state.equals((Object)CloudInstanceState.TERMINATED)) {
                    seenInstanceIds.add(instanceId);
                }
                if (jobRequireRemoteEngines != null) {
                    if (state.equals((Object)CloudInstanceState.RUNNING)) {
                        ++runningOrPendingCount;
                        ServerWorker serverWorker = this.getServerWorker(instanceId);
                        if (serverWorker != null && serverWorker.getModel().getStatus() != ServerStatus.INITIALIZED) {
                            String instanceUrl = "https://" + this.getInstancePublicDnsName(instanceId);
                            if (!serverWorker.getModel().getUrl().equals(instanceUrl)) {
                                LOGGER.info(this.instanceName() + " " + instanceId + " had associated server with incorrect URL");
                                this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.ServerChangedUrl", (Object)serverWorker.getModel().getName()));
                                this.removeServer(instanceId);
                                serverWorker = null;
                            }
                        }
                        if (serverWorker == null) {
                            LOGGER.info(this.instanceName() + " " + instanceId + " adding remote server");
                            serverWorker = this.addServer(instanceId, EngineRole.REMOTE);
                            if (serverWorker != null) {
                                for (EngineModel engineModel : serverWorker.getEngineModels()) {
                                    try {
                                        LOGGER.info(this.instanceName() + " " + instanceId + " removing server engine");
                                        serverWorker.deleteEngine(engineModel.getId());
                                    }
                                    catch (Exception e) {
                                        LOGGER.error("Cannot remove engine", (Throwable)e);
                                    }
                                }
                            }
                        }
                        if (serverWorker == null) continue;
                        EngineModel engineModel = this.getEngineModel(serverWorker, instanceId);
                        if (engineModel == null) {
                            LOGGER.info(this.instanceName() + " " + instanceId + " adding server remote engine");
                            LOGGER.info("Preparing to add remote engine to server " + instanceId + ". Removing old engines.");
                            this.deleteServerEngines(serverWorker);
                            engineModel = this.addEngine(serverWorker, instanceId, EngineRole.REMOTE);
                        } else if (!engineModel.getStatus().equals((Object)EngineStatus.RUNNING)) {
                            LOGGER.info(this.instanceName() + " " + instanceId + " updating remote engine settings");
                            EngineModel updatedEngineModel = new EngineModel(engineModel);
                            updatedEngineModel.setTargetNuixWorkers(this.model.getCloudSettings().getRemoteTargetNuixWorkers());
                            updatedEngineModel.setMinNuixWorkers(this.model.getCloudSettings().getRemoteMinNuixWorkers());
                            updatedEngineModel.setNuixLicenceSourceId(this.model.getCloudSettings().getRemoteNuixLicenceSourceId());
                            updatedEngineModel.setSupportedExecutionMode(ExecutionMode.AUTOMATE_NUIX);
                            try {
                                serverWorker.updateEngine(engineModel.getId(), updatedEngineModel);
                            }
                            catch (ServerException serverException) {
                                // empty catch block
                            }
                        }
                        if (engineModel == null || engineModel.getStatus() != EngineStatus.STANDBY) continue;
                        try {
                            engineModel.setWorkerAgentOnly(true);
                            serverWorker.joinRemoteJob(engineModel.getId(), jobRequireRemoteEngines);
                            this.model.addLog(this.iu.getFormattedString("CloudResourcePool.AssigningRemoteEngineToJob", new Object[]{engineModel.getName(), jobRequireRemoteEngines.getSettings().getName()}));
                            LOGGER.info(String.valueOf(engineModel) + " asked to join remote " + String.valueOf(jobRequireRemoteEngines.getSettings()));
                        }
                        catch (Exception e) {
                            LOGGER.info(String.valueOf(engineModel) + " cannot join remote " + String.valueOf(jobRequireRemoteEngines.getSettings()));
                        }
                        continue;
                    }
                    if (state.equals((Object)CloudInstanceState.STOPPED)) {
                        ++runningOrPendingCount;
                        LOGGER.info(this.instanceName() + " " + instanceId + " starting remote server");
                        this.startInstance(instanceId, EngineRole.REMOTE, jobRequireRemoteEngines.getSettings());
                        continue;
                    }
                    if (!state.equals((Object)CloudInstanceState.PENDING)) continue;
                    ++runningOrPendingCount;
                    continue;
                }
                if (state.equals((Object)CloudInstanceState.RUNNING) && remoteInstancesEligibleForIdleAction) {
                    if (this.model.getCloudSettings().getRemoteInstanceIdleAction() == InstanceIdleAction.STOP) {
                        this.removeServer(instanceId);
                        this.stopInstance(instanceId, EngineRole.REMOTE);
                    } else if (this.model.getCloudSettings().getRemoteInstanceIdleAction() == InstanceIdleAction.TERMINATE) {
                        this.removeServer(instanceId);
                        this.remoteLaunchedInstanceIds.remove(instanceId);
                        this.terminateInstance(instanceId, EngineRole.REMOTE);
                    }
                }
                if (!state.equals((Object)CloudInstanceState.STOPPED) || !remoteInstancesEligibleForIdleAction || this.model.getCloudSettings().getRemoteInstanceIdleAction() != InstanceIdleAction.TERMINATE) continue;
                this.removeServer(instanceId);
                this.remoteLaunchedInstanceIds.remove(instanceId);
                this.terminateInstance(instanceId, EngineRole.REMOTE);
            }
            catch (Exception e) {
                LOGGER.error("Cannot handle " + this.instanceName() + " " + instanceId, (Throwable)e);
                this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.CannotHandleInstance", new Object[]{this.instanceName(), instanceId, ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
            }
        }
        if (jobRequireRemoteEngines != null) {
            Set<String> launchedInstanceIds;
            int instancesRequired;
            boolean launchAzureInstance;
            boolean launchAwsInstance = this.model.getCloudSettings().getRemoteAwsSettings() != null && this.model.getCloudSettings().getRemoteAwsSettings().getLaunchTemplateId() != null && this.model.getCloudSettings().getRemoteAwsSettings().getMaxConcurrentInstances() != null;
            boolean bl = launchAzureInstance = this.model.getCloudSettings().getRemoteAzureSettings() != null && this.model.getCloudSettings().getRemoteAzureSettings().getCustomVmImageId() != null && this.model.getCloudSettings().getRemoteAzureSettings().getMaxConcurrentInstances() != null;
            if ((launchAwsInstance || launchAzureInstance) && (instancesRequired = this.model.getCloudSettings().getRemoteAwsSettings().getMaxConcurrentInstances() - runningOrPendingCount) > 0 && (launchedInstanceIds = this.launchRemoteInstancesFromTemplate(jobRequireRemoteEngines.getSettings(), instancesRequired)) != null) {
                for (String launchedInstanceId : launchedInstanceIds) {
                    ++runningOrPendingCount;
                    this.remoteLaunchedInstanceIds.add(launchedInstanceId);
                    seenInstanceIds.add(launchedInstanceId);
                }
            }
        }
        for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
            String originatingInstanceId;
            if (!TagsUtil.hasTagValue(TagsUtil.RESOURCE_POOL_ID, this.model.getId(), serverWorker.getModel().getTags()) || !TagsUtil.hasTagValue(TagsUtil.ENGINE_ROLE, EngineRole.REMOTE.name(), serverWorker.getModel().getTags()) || (originatingInstanceId = (String)serverWorker.getModel().getTags().get(TagsUtil.CLOUD_INSTANCE_ID)) == null || seenInstanceIds.contains(originatingInstanceId)) continue;
            LOGGER.info("Detected orphaned server " + serverWorker.getModel().getName());
            this.model.addLog(this.iu.getFormattedString("CloudResourcePoolWorker.DetectedOrphanedServer", (Object)serverWorker.getModel().getName()));
            this.removeServer(originatingInstanceId);
        }
    }
}

