/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.workers.ServerWorker;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.Command;
import com.nuix.automate.utils.models.api.engine.EngineCommand;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;

public class EngineErrorExecutionWorker
extends TimerTask {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(EngineErrorExecutionWorker.class);
    private final SchedulerApplication schedulerApplication;
    private final long initKillThreshold;
    private final Set<String> engineErrorStartTimes = new HashSet<String>();

    public EngineErrorExecutionWorker(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.initKillThreshold = schedulerApplication.getConfiguration().getEngineErrorJobInitAbortThreshold();
    }

    @Override
    public void run() {
        try {
            for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
                for (EngineModel engine : serverWorker.getEngineModels()) {
                    String engineId = engine.getId();
                    String runningJobId = engine.getRunningJobId();
                    if (runningJobId == null) {
                        runningJobId = engine.getBootstrappingJobId();
                    }
                    if (runningJobId == null) {
                        for (JobDetailsModel jobDetailsModel : this.schedulerApplication.getJobResource().getNonFinishedJobs()) {
                            if (jobDetailsModel == null || jobDetailsModel.getSettings() == null || !engineId.equals(jobDetailsModel.getSettings().getEngineId())) continue;
                            runningJobId = jobDetailsModel.getSettings().getId();
                            break;
                        }
                    }
                    if (engine.getStatus() == EngineStatus.ERROR && runningJobId != null || this.engineErrorStartTimes.contains(engineId) && engine.getStatus() != EngineStatus.RUNNING) {
                        this.engineErrorStartTimes.add(engineId);
                        if ((long)engine.getJobInitFailureCount() < this.initKillThreshold) continue;
                        LOGGER.error("Engine " + engineId + " has reached the job init failure threshold of " + this.initKillThreshold + ", killing job " + runningJobId);
                        if (runningJobId != null) {
                            this.schedulerApplication.getJobResource().clearJobBootstrapState(runningJobId);
                        }
                        EngineCommand shutdownCommand = new EngineCommand();
                        shutdownCommand.setCommand(Command.SHUTDOWN);
                        serverWorker.sendEngineCommand(engineId, shutdownCommand);
                        this.engineErrorStartTimes.remove(engineId);
                        continue;
                    }
                    this.engineErrorStartTimes.remove(engineId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error", (Throwable)e);
        }
    }

    private void killWithDelay(ServerWorker serverWorker, String runningJobId, String engineId, long errorDuration) {
    }
}

