/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.cache.CachedObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class FileImageWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FileImageWorker.class);
    private SchedulerApplication schedulerApplication;
    private Map<String, CachedObject<byte[]>> fileImageCache;

    public FileImageWorker(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.fileImageCache = new ConcurrentHashMap<String, CachedObject<byte[]>>();
    }

    public byte[] getFileImage(String extension) {
        CachedObject cachedImage = this.fileImageCache.get(extension);
        boolean cacheExpired = false;
        if (cachedImage != null && DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() > cachedImage.getExpirationMs()) {
            cacheExpired = true;
        }
        if (cacheExpired || cachedImage == null) {
            cachedImage = new CachedObject();
            cachedImage.setObject(null);
            cachedImage.setExpirationMs(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + 600000L);
            this.fileImageCache.put(extension, (CachedObject<byte[]>)cachedImage);
        }
        return (byte[])cachedImage.getObject();
    }
}

