/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.dropwizard.utils.models.UserServiceClient;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.google.GoogleOidcUserServiceClient;
import com.nuix.automate.scheduler.workers.UserServiceWorker;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.userservice.GoogleChatSpace;
import com.nuix.automate.utils.models.api.userservice.GoogleDrive;
import com.nuix.automate.utils.models.api.userservice.GoogleGroup;
import com.nuix.automate.utils.models.api.userservice.GoogleOrgUnit;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.io.IOException;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class GoogleUserServiceWorker
extends UserServiceWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GoogleUserServiceWorker.class);

    public GoogleUserServiceWorker(SchedulerApplication schedulerApplication, UserService userService) {
        super(schedulerApplication, userService);
    }

    @Override
    public int synchronizeObjects(UserServiceClient userServiceClient) {
        GoogleOidcUserServiceClient googleUserServiceClient = (GoogleOidcUserServiceClient)userServiceClient;
        int synchronizedObjectsCount = 0;
        try {
            synchronizedObjectsCount += this.synchronizeGroups(googleUserServiceClient);
        }
        catch (Exception e) {
            LOGGER.error("Could not synchronize " + String.valueOf(this.userService) + " Google Groups", (Throwable)e);
        }
        try {
            synchronizedObjectsCount += this.synchronizeOrgUnits(googleUserServiceClient);
        }
        catch (Exception e) {
            LOGGER.error("Could not synchronize " + String.valueOf(this.userService) + " Google OrgUnits", (Throwable)e);
        }
        try {
            synchronizedObjectsCount += this.synchronizeChatSpaces(googleUserServiceClient);
        }
        catch (Exception e) {
            LOGGER.error("Could not synchronize " + String.valueOf(this.userService) + " Google ChatSpaces", (Throwable)e);
        }
        try {
            synchronizedObjectsCount += this.synchronizeSharedDrives(googleUserServiceClient);
        }
        catch (Exception e) {
            LOGGER.error("Could not synchronize " + String.valueOf(this.userService) + " Google SharedDrives", (Throwable)e);
        }
        return synchronizedObjectsCount;
    }

    private int synchronizeGroups(GoogleOidcUserServiceClient googleOidcUserServiceClient) throws IOException {
        LOGGER.info("Querying " + String.valueOf(this.userService) + " google groups");
        long startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        List<GoogleGroup> serviceGroups = googleOidcUserServiceClient.getGroups();
        long endMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Querying " + String.valueOf(this.userService) + " groups took " + (endMs - startMs) / 1000L + " s");
        LOGGER.info("Google OIDC Authentication Service " + this.userService.getName() + " found " + serviceGroups.size() + " Groups");
        return this.persistUserServiceObjects(UserServiceObjectType.GOOGLE_GROUP, serviceGroups);
    }

    private int synchronizeOrgUnits(GoogleOidcUserServiceClient googleOidcUserServiceClient) throws IOException {
        LOGGER.info("Querying " + String.valueOf(this.userService) + " google orgUnits");
        long startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        List<GoogleOrgUnit> serviceOrgUnits = googleOidcUserServiceClient.getOrgUnits();
        long endMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Querying " + String.valueOf(this.userService) + " orgUnits took " + (endMs - startMs) / 1000L + " s");
        LOGGER.info("Google OIDC Authentication Service " + this.userService.getName() + " found " + serviceOrgUnits.size() + " OrgUnits");
        return this.persistUserServiceObjects(UserServiceObjectType.GOOGLE_ORG_UNIT, serviceOrgUnits);
    }

    private int synchronizeChatSpaces(GoogleOidcUserServiceClient googleOidcUserServiceClient) throws IOException {
        LOGGER.info("Querying " + String.valueOf(this.userService) + " google chat spaces");
        long startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        List<GoogleChatSpace> serviceChatSpaces = googleOidcUserServiceClient.getChatSpaces();
        long endMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Querying " + String.valueOf(this.userService) + " chat spaces took " + (endMs - startMs) / 1000L + " s");
        LOGGER.info("Google OIDC Authentication Service " + this.userService.getName() + " found " + serviceChatSpaces.size() + " Chat Spaces");
        return this.persistUserServiceObjects(UserServiceObjectType.GOOGLE_CHAT_SPACE, serviceChatSpaces);
    }

    private int synchronizeSharedDrives(GoogleOidcUserServiceClient googleOidcUserServiceClient) throws IOException {
        LOGGER.info("Querying " + String.valueOf(this.userService) + " google shared drives");
        long startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        List<GoogleDrive> serviceDrives = googleOidcUserServiceClient.getSharedDrives();
        long endMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Querying " + String.valueOf(this.userService) + " shared drives took " + (endMs - startMs) / 1000L + " s");
        LOGGER.info("Google OIDC Authentication Service " + this.userService.getName() + " found " + serviceDrives.size() + " Shared Drives");
        return this.persistUserServiceObjects(UserServiceObjectType.GOOGLE_SHARED_DRIVE, serviceDrives);
    }
}

