/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.ClsUtils;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import jakarta.ws.rs.client.Client;
import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;

public class NuixLicenceSourceWorker
extends TimerTask
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixLicenceSourceWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private NuixLicenseSourceModel model;
    private Client client;
    Semaphore pingServerSemaphore;
    protected Timer timer;

    public void initializeClient() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot close previous client", (Throwable)e);
        }
        try {
            this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)("NuixLicenseSourceWorker-" + this.model.getId() + "-worker"), (Set)this.model.getWhitelistedCertFingerprints(), (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
        }
        catch (Exception e) {
            LOGGER.error("Cannot create client", (Throwable)e);
        }
    }

    public NuixLicenceSourceWorker(SchedulerApplication schedulerApplication, NuixLicenseSourceModel licenceSourceModel) {
        this.schedulerApplication = schedulerApplication;
        this.model = licenceSourceModel;
        this.initializeClient();
        this.pingServerSemaphore = new Semaphore(1);
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)this, 0L, schedulerApplication.getConfiguration().getNuixLicensePingInterval());
    }

    @Override
    public void run() {
        boolean lockAvailable = this.pingServerSemaphore.tryAcquire();
        if (lockAvailable) {
            Thread pingServerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (NuixLicenceSourceWorker.this.model.getStatus().getCode() == State.ERROR) {
                            NuixLicenceSourceWorker.this.model.getStatus().reset();
                        }
                        NuixLicenceSourceWorker.this.pingLicenceSource();
                    }
                    catch (Throwable t) {
                        LOGGER.error(String.valueOf(NuixLicenceSourceWorker.this.model) + " ping error", t);
                    }
                }
            });
            pingServerThread.setDaemon(true);
            pingServerThread.setName("Engine License Source - ping");
            pingServerThread.start();
            try {
                pingServerThread.join(this.schedulerApplication.getConfiguration().getNuixLicenseSourceTimeout());
                if (pingServerThread.isAlive()) {
                    LOGGER.error(String.valueOf(this.model) + " ping did not complete");
                    LOGGER.warn(String.valueOf(this.model) + " stack trace:");
                    for (StackTraceElement stackTraceElement : pingServerThread.getStackTrace()) {
                        LOGGER.warn("\t" + stackTraceElement.toString());
                    }
                    LOGGER.warn(String.valueOf(this.model) + " Interrupting");
                    pingServerThread.interrupt();
                    pingServerThread.join(this.schedulerApplication.getConfiguration().getNuixLicenseSourceTimeout());
                    if (pingServerThread.isAlive()) {
                        LOGGER.error(String.valueOf(this.model) + " ping thread did not interrupt");
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.error(String.valueOf(this.model) + " cannot wait for ping thread to complete", (Throwable)e);
                this.model.setProfiles(null);
                this.model.getStatus().reset();
                this.model.getStatus().setError(this.iu.getString("Generic.CannotQueryDetails.TimeOut"));
            }
            this.pingServerSemaphore.release();
        } else {
            LOGGER.warn(String.valueOf(this.model) + " ping lock not available");
        }
    }

    public void pingLicenceSource() {
        if (this.model.getStatus() != null && State.ERROR.equals((Object)this.model.getStatus().getCode()) && !this.schedulerApplication.getConfiguration().getPingNuixLicenseIfError()) {
            return;
        }
        if (!this.schedulerApplication.getConfiguration().getPingNuixLicenseIfValid()) {
            return;
        }
        switch (this.model.getSourceType()) {
            case CLS: {
                try {
                    ClsUtils.testLicenceSource(this.model, true);
                }
                catch (Exception exception) {}
                break;
            }
            case NMS: {
                try {
                    this.schedulerApplication.getNmsUtils().testLicenceSource(this.model, this.client, true);
                }
                catch (Exception exception) {}
                break;
            }
            case DONGLE: {
                break;
            }
            case NONE: {
                break;
            }
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.NUIX_LICENSE_SOURCES, "");
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        catch (Exception e) {
            LOGGER.warn(String.valueOf(this.model) + " cannot cancel timer");
        }
    }
}

