/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.UrlJwkProvider;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.OidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.scheduler.workers.ClientUrlStreamHandler;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.UserServiceType;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.models.internal.user.MicrosoftOAuthVersion;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import javax.net.ssl.SSLHandshakeException;

public class OidcWellKnownConfigurationWorker
extends TimerTask
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OidcWellKnownConfigurationWorker.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final Semaphore pingServerSemaphore;
    private final Timer timer;
    private OidcUserService model;
    private Client client;
    private JwkProvider jwkProvider;
    private Map<String, Object> wellKnownConfiguration;

    public OidcWellKnownConfigurationWorker(SchedulerApplication schedulerApplication, OidcUserService model) {
        this.schedulerApplication = schedulerApplication;
        this.model = model;
        this.wellKnownConfiguration = new HashMap<String, Object>();
        this.pingServerSemaphore = new Semaphore(1);
        this.initializeClient();
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)this, 0L, 60000L);
    }

    public void setOidcUserService(OidcUserService model) {
        this.model = model;
        try {
            if (model.getStatus().getCode() == State.ERROR) {
                model.getStatus().reset();
            }
            this.pingWellKnownConfiguration();
        }
        catch (Exception e) {
            LOGGER.error(String.valueOf(model) + " ping error", (Throwable)e);
            model.getStatus().setError("Unable to ping, " + this.handleCertificateException(e));
        }
    }

    private void initializeClient() {
        this.safeCloseClient();
        try {
            this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)("OIDCAuthenticationServiceWorker-" + this.model.getId()), (Set)this.model.getWhitelistedCertFingerprints(), (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
        }
        catch (Exception e) {
            LOGGER.error("Cannot create client", (Throwable)e);
        }
    }

    public Map<String, Object> getWellKnownConfiguration() {
        return this.wellKnownConfiguration;
    }

    public JwkProvider getJwkProvider() {
        return this.jwkProvider;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.safeCloseClient();
        }
        catch (Exception e) {
            LOGGER.warn(String.valueOf(this.model) + " cannot cancel timer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safeCloseClient() {
        OidcWellKnownConfigurationWorker oidcWellKnownConfigurationWorker = this;
        synchronized (oidcWellKnownConfigurationWorker) {
            block6: {
                if (this.client != null) {
                    try {
                        this.client.close();
                        this.client = null;
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) break block6;
                        LOGGER.debug("Unable to close client", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void run() {
        if (!this.model.getEnabled().booleanValue()) {
            return;
        }
        boolean lockAvailable = this.pingServerSemaphore.tryAcquire();
        if (lockAvailable) {
            Thread pingServerThread = new Thread(() -> {
                try {
                    if (this.model.getStatus().getCode() == State.ERROR) {
                        this.model.getStatus().reset();
                    }
                    if (this.model.getEnabled().booleanValue()) {
                        this.pingWellKnownConfiguration();
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.valueOf(this.model) + " ping error", (Throwable)e);
                    this.model.getStatus().setError("Unable to ping, " + this.handleCertificateException(e));
                }
            });
            pingServerThread.setDaemon(true);
            pingServerThread.setName("Authentication Service (" + this.model.getName() + ") - ping");
            pingServerThread.start();
            try {
                pingServerThread.join(60000L);
                if (pingServerThread.isAlive()) {
                    LOGGER.error(String.valueOf(this.model) + " ping did not complete");
                    LOGGER.warn(String.valueOf(this.model) + " stack trace:");
                    for (StackTraceElement stackTraceElement : pingServerThread.getStackTrace()) {
                        LOGGER.warn("\t" + stackTraceElement.toString());
                    }
                    LOGGER.warn(String.valueOf(this.model) + " Interrupting");
                    pingServerThread.interrupt();
                    pingServerThread.join(60000L);
                    if (pingServerThread.isAlive()) {
                        LOGGER.error(String.valueOf(this.model) + " ping thread did not interrupt");
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.error(String.valueOf(this.model) + " cannot wait for ping thread to complete", (Throwable)e);
                this.model.getStatus().reset();
                this.model.getStatus().setError(iu.getString("Generic.CannotQueryDetails.TimeOut"));
            }
            this.pingServerSemaphore.release();
        } else {
            LOGGER.warn(String.valueOf(this.model) + " ping lock not available");
        }
    }

    private void pingWellKnownConfiguration() {
        this.pingWellKnownConfiguration(this.schedulerApplication.getUserServiceResource().getOidcUserServiceClient(this.model.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void pingWellKnownConfiguration(OidcUserServiceClient oidcUserServiceClient) {
        String wellKnownConfigurationUri = this.getWellKnownConfigurationUri();
        Map updatedWellKnownConfiguration = null;
        OidcWellKnownConfigurationWorker oidcWellKnownConfigurationWorker = this;
        synchronized (oidcWellKnownConfigurationWorker) {
            if (this.client != null) {
                Response response = null;
                try {
                    response = this.client.target(wellKnownConfigurationUri).request(new String[]{"application/json"}).get();
                }
                catch (Exception e) {
                    this.initializeClient();
                    response = this.client.target(wellKnownConfigurationUri).request(new String[]{"application/json"}).get();
                }
                if (response.getStatus() != 200) {
                    String error = (String)response.readEntity(String.class);
                    this.model.getStatus().setError(iu.getFormattedString("UserService.OIDC.InvalidWellKnownConfiguration", new Object[]{response.getStatus(), error}));
                } else {
                    updatedWellKnownConfiguration = (Map)response.readEntity(Map.class);
                }
            }
            if (this.wellKnownConfiguration == null || updatedWellKnownConfiguration != null && updatedWellKnownConfiguration != this.wellKnownConfiguration) {
                this.wellKnownConfiguration = updatedWellKnownConfiguration;
                this.loadJwtKeys();
                if (oidcUserServiceClient != null) {
                    oidcUserServiceClient.updateWellKnownConfiguration(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJwtKeys() {
        OidcWellKnownConfigurationWorker oidcWellKnownConfigurationWorker = this;
        synchronized (oidcWellKnownConfigurationWorker) {
            try {
                String context = this.wellKnownConfiguration.get("jwks_uri").toString();
                WebTarget webTarget = this.client.target(context);
                Invocation.Builder invocationBuilder = webTarget.request();
                Response response = invocationBuilder.get();
                String content = (String)response.readEntity(String.class);
                response.close();
                URL clientUrl = new URL(null, context, new ClientUrlStreamHandler(content));
                this.jwkProvider = new UrlJwkProvider(clientUrl);
            }
            catch (MalformedURLException e) {
                this.jwkProvider = null;
                LOGGER.error("Cannot load JWK Provider", (Throwable)e);
            }
        }
    }

    private String getWellKnownConfigurationUri() {
        if (this.model.getUserServiceType() == UserServiceType.OIDC) {
            return this.model.getWellKnownConfiguration();
        }
        if (this.model.getUserServiceType() == UserServiceType.MICROSOFT) {
            MicrosoftUserService microsoftUserService = (MicrosoftUserService)this.model;
            String openIdConfiguration = microsoftUserService.getoAuthVersion() == MicrosoftOAuthVersion.V1 ? "/.well-known/openid-configuration" : "/v2.0/.well-known/openid-configuration";
            return microsoftUserService.getAuthorityUrl() + microsoftUserService.getTenant() + openIdConfiguration;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleCertificateException(Exception e) {
        if (e.getCause() != null && e.getCause() instanceof SSLHandshakeException || e.getMessage().contains("SSLHandshakeException")) {
            try (Response response = null;){
                Client dummyClient = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)("OIDCAuthenticationServiceWorker-" + this.model.getId() + "-dummyFingerprint"), new HashSet<String>(List.of("Invalid")), (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
                response = dummyClient.target(this.getWellKnownConfigurationUri()).request(new String[]{"application/json"}).get();
            }
        }
        return iu.getFormattedString("LicenseUtils.CouldNotInitializeServer", (Object)e.getLocalizedMessage());
    }
}

