/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.google.gson.reflect.TypeToken;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.resources.ResourcePoolResource;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.utils.TagsUtil;
import com.nuix.automate.scheduler.workers.ServerWorker;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.engine.EngineRole;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.api.resourcepool.ResourcePool;
import com.nuix.automate.utils.models.api.server.MaintenanceStatus;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;

public abstract class ResourcePoolWorker
extends TimerTask {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ResourcePoolWorker.class);
    protected SchedulerApplication schedulerApplication;
    protected ResourcePoolResource resourcePoolResource;
    protected ResourcePoolModel model;
    protected Semaphore pingSemaphore;
    protected Timer timer;
    protected long timeout;
    protected boolean ranJob;

    public abstract void onBeforeDelete() throws IllegalStateException;

    public abstract boolean getUsingRemoteWorkers();

    public Set<String> getEngineIds(EngineRole engineRole) {
        Set<String> engineIds = new HashSet();
        if (Boolean.TRUE.equals(this.model.getAutoRegistrationEnabled())) {
            for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
                Type setType;
                HashSet engineRoleSet;
                String engineRoles;
                if (!TagsUtil.hasTagValue(TagsUtil.AUTO_REGISTER_RESOURCE_POOL_ID, this.model.getId(), serverWorker.getModel().getTags()) || (engineRoles = (String)serverWorker.getModel().getTags().get(TagsUtil.ENGINE_ROLES)) == null || !(engineRoleSet = (HashSet)SerializationUtils.fromJson((String)engineRoles, (Type)(setType = new TypeToken<HashSet<EngineRole>>(){}.getType()))).contains(engineRole) || !TagsUtil.hasTagValue(TagsUtil.AUTO_REGISTER_RESOURCE_POOL_ID, this.model.getId(), serverWorker.getModel().getTags())) continue;
                for (EngineModel engineModel : serverWorker.getEngineModels()) {
                    engineIds.add(engineModel.getId());
                }
            }
        } else {
            switch (engineRole) {
                case MAIN: {
                    engineIds = this.model.getEngineIds();
                    break;
                }
                case REMOTE: {
                    engineIds = this.model.getRemoteEngineIds();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected EngineRole " + String.valueOf(engineRole));
                }
            }
        }
        if (engineIds == null) {
            engineIds = new HashSet();
        }
        return engineIds;
    }

    public ResourcePoolWorker(SchedulerApplication schedulerApplication, ResourcePoolResource resourcePoolResource, ResourcePoolModel resourcePool) {
        this.schedulerApplication = schedulerApplication;
        this.resourcePoolResource = resourcePoolResource;
        this.model = resourcePool;
        this.pingSemaphore = new Semaphore(1);
        this.timer = new Timer(true);
        this.timeout = schedulerApplication.getConfiguration().getResourcePoolTimeout();
        this.ranJob = false;
    }

    public void ping() {
        String previousError = null;
        if (this.model != null && this.model.getStatus() != null && this.model.getStatus().getCode().equals((Object)State.ERROR)) {
            previousError = this.model.getStatus().getMessage();
        }
        if (!this.schedulerApplication.getInitializing() || this.schedulerApplication.getJobResource() != null) {
            this.manageWork();
        }
        if (this.model != null && this.model.getStatus() != null && this.model.getStatus().getCode().equals((Object)State.ERROR) && previousError == null) {
            ResourcePool eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), this.model);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.RESOURCE_POOL_ERROR, eventResult);
        }
    }

    public void setResourcePoolModel(ResourcePoolModel model) {
        this.model = model;
        if (model.getActive() != null && model.getActive().equals(false)) {
            this.ranJob = false;
        }
    }

    protected abstract void manageWork();

    protected List<JobDetailsModel> getRunningJobs() {
        ArrayList<JobDetailsModel> runningJobs = new ArrayList<JobDetailsModel>();
        if (this.schedulerApplication.getJobResource() != null) {
            if (this.schedulerApplication.getServerResource() != null) {
                for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
                    if (serverWorker.getModel().getMaintenanceStatus() != MaintenanceStatus.NONE) continue;
                    for (EngineModel engineModel : serverWorker.getEngineModels()) {
                        if (engineModel.getWorkerAgentOnly() || !engineModel.getStatus().equals((Object)EngineStatus.RUNNING)) continue;
                        String jobId = engineModel.getRunningJobId();
                        JobDetailsModel job = this.schedulerApplication.getJobResource().getJobDetailsModel(jobId);
                        if (job == null) {
                            LOGGER.error("Unable to retrieve job with " + jobId);
                            continue;
                        }
                        if (!job.getSettings().getResourcePoolId().equals(this.model.getId())) continue;
                        runningJobs.add(job);
                    }
                }
            }
            runningJobs.sort(Comparator.comparing(o -> o.getSettings().getPriority()));
            Collections.reverse(runningJobs);
        }
        return runningJobs;
    }

    protected void resolveObjectNames(ServerWorker serverWorker, JobModel jobModel, EngineModel engineModel) {
        ExecutionProfileModel executionProfile;
        Client client;
        Matter matter;
        jobModel.setResourcePoolName(this.model.getName());
        jobModel.setEngineId(engineModel.getId());
        jobModel.setEngineName(engineModel.getName());
        jobModel.setServerId(serverWorker.getModel().getId());
        jobModel.setServerName(serverWorker.getModel().getName());
        if (jobModel.getMatterId() != null && (matter = this.schedulerApplication.getClientResource().getMatter(jobModel.getMatterId())) != null) {
            jobModel.setMatterName(matter.getName());
            jobModel.setMatterReference(matter.getReference());
        }
        if (jobModel.getClientId() != null && (client = this.schedulerApplication.getClientMatterDao().getClient(jobModel.getClientId())) != null) {
            jobModel.setClientName(client.getName());
            jobModel.setClientReference(client.getReference());
        }
        if (jobModel.getExecutionProfileId() != null && (executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(jobModel.getExecutionProfileId())) != null) {
            jobModel.setExecutionProfileName(executionProfile.getName());
        }
    }

    protected void resetObjectNames(JobModel jobModel) {
        jobModel.setExecutionProfileName(null);
        jobModel.setResourcePoolName(null);
        jobModel.setEngineName(null);
        jobModel.setServerName(null);
        jobModel.setMatterName(null);
        jobModel.setClientName(null);
        jobModel.setMatterReference(null);
        jobModel.setClientReference(null);
    }

    @Override
    public void run() {
        boolean lockAvailable = this.pingSemaphore.tryAcquire();
        if (lockAvailable) {
            Thread pingServerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ResourcePoolWorker.this.ping();
                    }
                    catch (Throwable t) {
                        LOGGER.error(String.valueOf(ResourcePoolWorker.this.model) + " ping error", t);
                    }
                }
            });
            pingServerThread.setDaemon(true);
            pingServerThread.setName("Resource Pool Worker - ping");
            pingServerThread.start();
            try {
                pingServerThread.join(this.timeout);
                if (pingServerThread.isAlive()) {
                    LOGGER.error(String.valueOf(this.model) + " ping did not complete");
                    LOGGER.warn(String.valueOf(this.model) + " stack trace:");
                    for (StackTraceElement stackTraceElement : pingServerThread.getStackTrace()) {
                        LOGGER.warn("\t" + stackTraceElement.toString());
                    }
                    LOGGER.warn(String.valueOf(this.model) + " Interrupting");
                    pingServerThread.interrupt();
                    pingServerThread.join(this.schedulerApplication.getConfiguration().getResourcePoolTimeout());
                    if (pingServerThread.isAlive()) {
                        LOGGER.error(String.valueOf(this.model) + " ping thread did not interrupt");
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.error(String.valueOf(this.model) + " cannot wait for ping thread to complete", (Throwable)e);
            }
            this.pingSemaphore.release();
        } else {
            LOGGER.warn(String.valueOf(this.model) + " ping lock not available");
        }
    }
}

