/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.dropwizard.utils.models.UserServiceClient;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.ldap.LdapClient;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ThreadPoolUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.api.user.UserServiceType;
import com.nuix.automate.utils.models.api.userservice.UpdateUsersResponse;
import com.nuix.automate.utils.models.api.userservice.UserServiceObject;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class UserServiceWorker
implements Runnable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserServiceWorker.class);
    private static final ScheduledThreadPoolExecutor userServiceScheduledThreadPool = ThreadPoolUtils.createScheduledThreadPoolExecutor((String)UserServiceWorker.class.getSimpleName(), (int)4);
    protected final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    protected final SchedulerApplication schedulerApplication;
    protected final UserService userService;
    protected ScheduledFuture<?> scheduledFuture;
    private Semaphore runSemaphore;

    public UserServiceWorker(SchedulerApplication schedulerApplication, UserService userService) {
        this.schedulerApplication = schedulerApplication;
        this.userService = userService;
        this.reset(schedulerApplication.getConfiguration().getUserServiceWorkerBootDelay());
        this.runSemaphore = new Semaphore(1);
    }

    public boolean tryRun() {
        boolean lockAvailable = this.runSemaphore.tryAcquire();
        if (lockAvailable) {
            try {
                LOGGER.info(String.valueOf(this.userService) + " explicit sync lock is available");
            }
            finally {
                this.runSemaphore.release();
            }
        } else {
            return false;
        }
        if (this.userService.getEnabled().booleanValue()) {
            this.run();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryUpdateUsers(Map<String, Integer> columnIndex, List<Object[]> records, UpdateUsersResponse response) {
        boolean lockAvailable = this.runSemaphore.tryAcquire();
        if (lockAvailable) {
            try {
                Map<String, UserAccount> applicationCachedUsers = this.schedulerApplication.getUserServiceResource().getUsers();
                HashMap<String, UserAccount> userAccountsByName = new HashMap<String, UserAccount>();
                for (UserAccount userAccount : applicationCachedUsers.values()) {
                    if (!userAccount.getUserServiceId().equals(this.userService.getId())) continue;
                    userAccountsByName.put(userAccount.getName(), userAccount);
                }
                ArrayList<UserAccount> usersToPersist = new ArrayList<UserAccount>();
                for (Object[] record : records) {
                    try {
                        UserAccount existingUser;
                        String newUserId;
                        String exchangeGuid = record[columnIndex.get("ExchangeGuid")].toString();
                        String externalDirectoryObjectId = record[columnIndex.get("ExternalDirectoryObjectId")].toString();
                        String userPrincipalName = record[columnIndex.get("UserPrincipalName")].toString();
                        String displayName = record[columnIndex.get("DisplayName")].toString();
                        String primarySmtpAddress = record[columnIndex.get("PrimarySmtpAddress")].toString();
                        if (externalDirectoryObjectId.trim().isEmpty()) {
                            newUserId = exchangeGuid;
                            existingUser = applicationCachedUsers.get(exchangeGuid);
                            if (existingUser == null) {
                                existingUser = (UserAccount)userAccountsByName.get(userPrincipalName);
                            }
                        } else {
                            newUserId = externalDirectoryObjectId;
                            existingUser = applicationCachedUsers.get(exchangeGuid);
                            if (existingUser == null) {
                                existingUser = (UserAccount)userAccountsByName.get(userPrincipalName);
                            }
                        }
                        if (existingUser != null) {
                            response.incrementUsersSkipped();
                            continue;
                        }
                        response.incrementUsersAdded();
                        UserAccount userAccount = new UserAccount();
                        userAccount.setUserServiceId(this.userService.getId());
                        userAccount.setUserAccountState(UserAccountState.DELETED);
                        userAccount.setPlatform(UserAccountPlatform.MANUAL_UPLOAD);
                        userAccount.setId(newUserId);
                        userAccount.setName(userPrincipalName);
                        userAccount.setEmail(primarySmtpAddress);
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put("displayName", displayName);
                        userAccount.setAttributes(attributes);
                        applicationCachedUsers.put(userAccount.getId(), userAccount);
                        usersToPersist.add(userAccount);
                    }
                    catch (Exception e) {
                        response.incrementInvalidEntries();
                        LOGGER.warn("Error handling CSV row", (Throwable)e);
                    }
                }
                LOGGER.info("Persisting " + usersToPersist.size() + " updated users from CSV ...");
                this.schedulerApplication.getUsersDao().addOrUpdateUsers(usersToPersist);
            }
            catch (Exception e) {
                LOGGER.error("Error updating users " + this.userService.getName(), (Throwable)e);
            }
            finally {
                this.runSemaphore.release();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean lockAvailable = this.runSemaphore.tryAcquire();
        if (lockAvailable) {
            try {
                UserServiceClient userServiceClient = this.schedulerApplication.getUserServiceResource().getUserServiceClient(this.userService.getId());
                if (this.userService.getUserServiceType() == UserServiceType.MANAGED) {
                    return;
                }
                Status status = this.userService.getStatus();
                if (status.getCode() == State.ERROR || status.getCode() == State.WARNING) {
                    status.reset();
                }
                int synchronizedObjectsCount = 0;
                boolean successfulSynchronize = false;
                if (Boolean.TRUE.equals(this.userService.getSynchronizeUsers())) {
                    try {
                        synchronizedObjectsCount += this.synchronizeUsers(userServiceClient);
                        successfulSynchronize = true;
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not synchronize " + String.valueOf(this.userService) + " users", (Throwable)e);
                        this.userService.getStatus().setError(this.iu.getFormattedString("UsersResource.ScheduledQueryError", new Object[]{this.userService.getName(), e}));
                    }
                }
                if (Boolean.TRUE.equals(this.userService.getSynchronizeObjects()) || userServiceClient instanceof LdapClient && Boolean.TRUE.equals(this.userService.getSynchronizeComputers())) {
                    try {
                        synchronizedObjectsCount += this.synchronizeObjects(userServiceClient);
                        successfulSynchronize = true;
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not synchronize " + String.valueOf(this.userService) + " objects", (Throwable)e);
                        this.userService.getStatus().setError(this.iu.getFormattedString("UsersResource.ScheduledQueryError", new Object[]{this.userService.getName(), e}));
                    }
                }
                if (successfulSynchronize) {
                    this.userService.setObjectCount(Integer.valueOf(synchronizedObjectsCount));
                    this.userService.setLastSynchronized(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
                    this.schedulerApplication.getSchedulerConfigurationDao().updateUserService(this.userService);
                }
                ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
                ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATION, this.userService.getId());
                ResponseCache.getInstance().resetKeyId(CacheKey.USERS);
            }
            catch (Exception e) {
                LOGGER.error("Error in scheduled query for " + this.userService.getName(), (Throwable)e);
                this.userService.getStatus().setError(this.iu.getFormattedString("UsersResource.ScheduledQueryError", new Object[]{this.userService.getName(), e}));
            }
            finally {
                this.runSemaphore.release();
            }
        } else {
            LOGGER.warn(String.valueOf(this.userService) + " run lock not available");
        }
    }

    public int synchronizeUsers(UserServiceClient userServiceClient) throws Exception {
        LOGGER.info("Querying " + String.valueOf(this.userService) + " accounts");
        long startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        List serviceUserAccounts = userServiceClient.getUserAccounts(this.userService, false, false);
        List inactiveServiceUserAccounts = userServiceClient.getUserAccounts(this.userService, false, true);
        long endMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Querying " + String.valueOf(this.userService) + " accounts took " + (endMs - startMs) / 1000L + " s");
        if (serviceUserAccounts != null) {
            UserAccount applicationCacheAccount;
            LOGGER.info("Authentication Service " + this.userService.getName() + " found " + serviceUserAccounts.size() + " active users and " + inactiveServiceUserAccounts.size() + " inactive users");
            HashSet<String> serviceUserAccountIds = new HashSet<String>();
            Map<String, UserAccount> applicationCachedUsers = this.schedulerApplication.getUserServiceResource().getUsers();
            ArrayList<UserAccount> newServiceUsers = new ArrayList<UserAccount>();
            HashMap<String, UserAccount> changedExistingUsers = new HashMap<String, UserAccount>();
            int count = 0;
            for (UserAccount serviceUserAccount : serviceUserAccounts) {
                if (count % 500 == 0) {
                    this.userService.setUpdateMessage(this.iu.getFormattedString("UserServiceWorker.ValidateUsers", (Object)count));
                }
                ++count;
                if (applicationCachedUsers.containsKey(serviceUserAccount.getId())) {
                    applicationCacheAccount = applicationCachedUsers.get(serviceUserAccount.getId());
                    if (!applicationCacheAccount.equals((Object)serviceUserAccount)) {
                        changedExistingUsers.put(serviceUserAccount.getId(), serviceUserAccount);
                    }
                } else {
                    newServiceUsers.add(serviceUserAccount);
                }
                serviceUserAccountIds.add(serviceUserAccount.getId());
                applicationCachedUsers.put(serviceUserAccount.getId(), serviceUserAccount);
                serviceUserAccount.setUserAccountState(UserAccountState.ACTIVE);
            }
            for (UserAccount serviceUserAccount : inactiveServiceUserAccounts) {
                if (count % 500 == 0) {
                    this.userService.setUpdateMessage(this.iu.getFormattedString("UserServiceWorker.ValidateUsers", (Object)count));
                }
                ++count;
                if (applicationCachedUsers.containsKey(serviceUserAccount.getId())) {
                    applicationCacheAccount = applicationCachedUsers.get(serviceUserAccount.getId());
                    if (!applicationCacheAccount.equals((Object)serviceUserAccount)) {
                        changedExistingUsers.put(serviceUserAccount.getId(), serviceUserAccount);
                    }
                } else {
                    newServiceUsers.add(serviceUserAccount);
                }
                serviceUserAccountIds.add(serviceUserAccount.getId());
                applicationCachedUsers.put(serviceUserAccount.getId(), serviceUserAccount);
                serviceUserAccount.setUserAccountState(UserAccountState.INACTIVE);
            }
            for (UserAccount applicationCachedUser : applicationCachedUsers.values()) {
                if (!this.userService.getId().equals(applicationCachedUser.getUserServiceId()) || serviceUserAccountIds.contains(applicationCachedUser.getId()) || applicationCachedUser.getUserAccountState() == UserAccountState.DELETED) continue;
                applicationCachedUser.setUserAccountState(UserAccountState.DELETED);
                changedExistingUsers.put(applicationCachedUser.getId(), applicationCachedUser);
            }
            startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            int persistedUsers = 0;
            LOGGER.info("New users: " + newServiceUsers.size());
            HashSet<UserAccount> usersToPersist = new HashSet<UserAccount>(newServiceUsers);
            LOGGER.info("Changed users: " + changedExistingUsers.values().size());
            usersToPersist.addAll(changedExistingUsers.values());
            LOGGER.info("Persisting " + usersToPersist.size() + " new/changed users ...");
            this.userService.setUpdateMessage(this.iu.getFormattedString("UserServiceWorker.PersistUsers", (Object)persistedUsers));
            this.schedulerApplication.getUsersDao().addOrUpdateUsers(usersToPersist);
            this.userService.setUpdateMessage(this.iu.getFormattedString("UserServiceWorker.PersistUsers", (Object)(persistedUsers += newServiceUsers.size())));
            endMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            LOGGER.info("Persisting " + String.valueOf(this.userService) + " " + persistedUsers + " accounts took " + (endMs - startMs) / 1000L + " s");
            this.userService.setUpdateMessage(null);
            LOGGER.info("Authentication Service " + this.userService.getName() + " found " + serviceUserAccountIds.size() + " unique users");
            return serviceUserAccountIds.size();
        }
        return 0;
    }

    public int synchronizeObjects(UserServiceClient userServiceClient) {
        return 0;
    }

    protected <T extends UserServiceObject> int persistUserServiceObjects(UserServiceObjectType objectType, List<T> userServiceObjects) {
        HashSet<String> userServiceObjectIds = new HashSet<String>();
        Map allCachedObjects = this.schedulerApplication.getUserServiceResource().getAllUserServiceObjects(objectType);
        Map userServiceCachedObjects = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(objectType, this.userService.getId());
        ArrayList<Object> newObjects = new ArrayList<Object>();
        HashMap<String, Object> changedExistingObjects = new HashMap<String, Object>();
        int count = 0;
        for (Object object : userServiceObjects) {
            if (count % 500 == 0) {
                this.userService.setUpdateMessage(this.iu.getFormattedString("UserServiceWorker.Validate" + String.valueOf(objectType), (Object)count));
            }
            ++count;
            if (allCachedObjects.containsKey(object.getId())) {
                UserServiceObject cachedObject = (UserServiceObject)allCachedObjects.get(object.getId());
                if (!cachedObject.equals(object)) {
                    changedExistingObjects.put(object.getId(), object);
                }
            } else {
                newObjects.add(object);
            }
            userServiceObjectIds.add(object.getId());
            userServiceCachedObjects.put(object.getId(), object);
        }
        ArrayList<String> disappearedObjectIds = new ArrayList<String>();
        for (UserServiceObject cachedObject : userServiceCachedObjects.values()) {
            if (userServiceObjectIds.contains(cachedObject.getId())) continue;
            disappearedObjectIds.add(cachedObject.getId());
        }
        for (String disappearedObjectId : disappearedObjectIds) {
            userServiceCachedObjects.remove(disappearedObjectId);
        }
        long startMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        int persistedObjects = 0;
        String objectPrintableNamePlural = objectType.toLocalizedString() + "s";
        LOGGER.info("Deleting " + disappearedObjectIds.size() + " disappeared " + objectPrintableNamePlural + " ...");
        this.schedulerApplication.getUsersDao().deleteUserServiceObjects(disappearedObjectIds);
        int deletedObjects = disappearedObjectIds.size();
        LOGGER.info("New " + objectPrintableNamePlural + ": " + newObjects.size());
        ArrayList<UserServiceObject> objectsToPersist = new ArrayList<UserServiceObject>(newObjects);
        LOGGER.info("Changed " + objectPrintableNamePlural + ": " + changedExistingObjects.values().size());
        objectsToPersist.addAll(changedExistingObjects.values());
        LOGGER.info("Persisting " + objectsToPersist.size() + " new/changed " + objectPrintableNamePlural + " ...");
        this.userService.setUpdateMessage(this.iu.getFormattedString("UserServiceWorker.Persist" + String.valueOf(objectType), (Object)persistedObjects));
        this.schedulerApplication.getUsersDao().addOrUpdateUserServiceObjects(objectsToPersist);
        this.userService.setUpdateMessage(this.iu.getFormattedString("UserServiceWorker.Persist" + String.valueOf(objectType), (Object)(persistedObjects += newObjects.size())));
        long endMs = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Persisting " + String.valueOf(this.userService) + " " + persistedObjects + "-" + deletedObjects + " " + objectPrintableNamePlural + " took " + (endMs - startMs) / 1000L + " s");
        this.userService.setUpdateMessage(null);
        LOGGER.info("Authentication Service " + this.userService.getName() + " found " + userServiceObjectIds.size() + " unique " + objectPrintableNamePlural);
        return userServiceObjectIds.size();
    }

    public void reset() {
        if (this.schedulerApplication.getApplicationStarted()) {
            this.reset(0L);
        } else {
            this.reset(this.schedulerApplication.getConfiguration().getUserServiceWorkerBootDelay());
        }
    }

    public void reset(long delaySeconds) {
        this.cancel();
        if (this.userService.isSynchronizeActive()) {
            LOGGER.info("Resetting " + this.userService.getName() + " scheduled user query");
            this.scheduledFuture = this.userService.getSearchDelay() != null ? userServiceScheduledThreadPool.scheduleAtFixedRate(this, delaySeconds, this.userService.getSearchDelay() * 60, TimeUnit.SECONDS) : userServiceScheduledThreadPool.scheduleAtFixedRate(this, delaySeconds, Integer.MAX_VALUE, TimeUnit.SECONDS);
        } else {
            this.userService.getStatus().reset();
        }
    }

    public void cancel() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(true);
        }
    }
}

