/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workers;

import com.nuix.automate.dropwizard.utils.resources.VersionResources;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.HeadersCaptureInterceptor;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.webhook.Webhook;
import com.nuix.automate.utils.models.api.webhook.WebhookCall;
import com.nuix.automate.utils.models.api.webhook.WebhookEvent;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.DatatypeConverter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class WebhookWorker
extends TimerTask {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WebhookWorker.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private Timer timer;
    private Set<WebhookEvent> unsatisfiedEvents = new HashSet<WebhookEvent>();
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZoneUTC().withLocale(Locale.US);

    public WebhookWorker(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        Map<String, List<WebhookEvent>> webhooksEvents = schedulerApplication.getWebhookResource().getWebhookEvents();
        for (List<WebhookEvent> webhookEvents : webhooksEvents.values()) {
            for (WebhookEvent webhookEvent : webhookEvents) {
                int attemptNumber;
                WebhookCall lastCall;
                List calls;
                if (webhookEvent.getStatus().getCode().equals((Object)State.ERROR) || (calls = webhookEvent.getCalls()) == null || calls.size() <= 0 || (lastCall = (WebhookCall)calls.get(calls.size() - 1)).isSuccessful() || (attemptNumber = lastCall.getAttemptNumber()) >= schedulerApplication.getConfiguration().getDisableWebhookAfterFailedCallbacks()) continue;
                this.unsatisfiedEvents.add(webhookEvent);
                LOGGER.info("Detected incomplete Webhook Event " + String.valueOf(webhookEvent.getTriggerType()) + " " + webhookEvent.getId() + " call #" + attemptNumber);
            }
        }
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)this, 1000L, 1000L);
    }

    private Object cleanUpRampivaObjects(Object eventObject) {
        Object finalEvent = eventObject;
        if (eventObject instanceof JobDetailsModel) {
            JobDetailsModel jobDetailsModel = new JobDetailsModel((JobDetailsModel)eventObject, true, false);
            jobDetailsModel.getSettings().setSessionParametersKeyId(null);
            finalEvent = jobDetailsModel;
        }
        if (finalEvent instanceof UserPermissionModel) {
            UserPermissionModel userPermissionModel = (UserPermissionModel)finalEvent;
            userPermissionModel.setUserPermissions(null);
            finalEvent = userPermissionModel;
        }
        return finalEvent;
    }

    public void triggerEvent(EventType.Type eventType, Object eventObject, String triggeredByUser) {
        boolean eventMatchesWebhook = false;
        Object cleanObject = this.cleanUpRampivaObjects(eventObject);
        ArrayList<Webhook> webhooks = new ArrayList<Webhook>(this.schedulerApplication.getWebhookResource().getWebhooks());
        for (Webhook webhook : webhooks) {
            if (webhook == null || webhook.getActive() == null || !webhook.getActive().booleanValue() || webhook.getTriggers() == null || !webhook.getTriggers().contains(eventType)) continue;
            eventMatchesWebhook = true;
            this.triggerEventOnWebhook(webhook, eventType, cleanObject, triggeredByUser);
        }
        if (eventMatchesWebhook && eventType.equals((Object)EventType.Type.SERVICE_SCHEDULER_STOPPED)) {
            LOGGER.info("Processing webhook events before closing");
            this.handleEventCalls();
            LOGGER.info("Waiting for events");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Cannot wait", (Throwable)e);
            }
        }
    }

    public void triggerEvent(EventType.Type eventType, Object eventObject) {
        this.triggerEvent(eventType, eventObject, BuiltInPrincipalIdentifiers.SYSTEM_USER.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerEventOnWebhook(Webhook webhook, EventType.Type eventType, Object eventObject, String triggeredByUser) {
        WebhookEvent event = new WebhookEvent();
        event.setId(UidUtils.getRandom());
        event.setTriggeredByUser(triggeredByUser);
        event.setTriggerType(eventType);
        event.setWebhookId(webhook.getId());
        event.setEpoch(DateTime.now().getMillis());
        event.setBody(SerializationUtils.toJson((Object)eventObject));
        event.setObjectType(eventObject.getClass().getSimpleName());
        event.setStatus(new Status());
        event.getStatus().resetOkMessage("");
        ArrayList calls = new ArrayList();
        event.setCalls(calls);
        LOGGER.info(webhook.toString() + " triggered by event " + String.valueOf(eventType) + " " + event.getId());
        this.schedulerApplication.getWebhookResource().addWebhookEvent(webhook.getId(), event);
        Set<WebhookEvent> set = this.unsatisfiedEvents;
        synchronized (set) {
            this.unsatisfiedEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEventCalls() {
        Set<WebhookEvent> set = this.unsatisfiedEvents;
        synchronized (set) {
            for (WebhookEvent event : new ArrayList<WebhookEvent>(this.unsatisfiedEvents)) {
                this.handleEvent(event);
            }
        }
    }

    private void handleEvent(WebhookEvent event) {
        ArrayList<WebhookCall> calls = event.getCalls();
        Webhook webhook = this.schedulerApplication.getWebhookResource().getWebhookRegistration(event.getWebhookId());
        if (webhook == null || !webhook.getActive().booleanValue()) {
            this.unsatisfiedEvents.remove(event);
            return;
        }
        WebhookCall lastCall = null;
        if (calls != null && calls.size() > 0 && (lastCall = (WebhookCall)calls.get(calls.size() - 1)).isInProgress()) {
            return;
        }
        int attemptNumber = 1;
        if (lastCall != null) {
            attemptNumber = lastCall.getAttemptNumber() + 1;
            long millisPassed = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - lastCall.getRequestEpoch();
            long baseFrequency = this.schedulerApplication.getConfiguration().getWebhookInitialDelayOnFailure();
            long exponentialBackOffInterval = (long)(Math.pow(2.0, attemptNumber - 1) * (double)baseFrequency);
            if (millisPassed < exponentialBackOffInterval) {
                return;
            }
        }
        WebhookCall call = new WebhookCall();
        call.setAttemptNumber(attemptNumber);
        if (calls == null) {
            calls = new ArrayList<WebhookCall>();
            event.setCalls(calls);
        }
        calls.add(call);
        call.setId(UidUtils.getRandom());
        int finalAttemptNumber = attemptNumber;
        Thread startTriggerThread = new Thread(() -> {
            block28: {
                try {
                    OkHttpClient client;
                    call.setRequestEpoch(Long.valueOf(DateTime.now().getMillis()));
                    String postBody = event.getBody();
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)postBody);
                    String username = "N/A";
                    if (event.getTriggeredByUser() != null) {
                        username = event.getTriggeredByUser();
                    }
                    Request request = new Request.Builder().url(webhook.getCallbackAddress()).post(requestBody).header("X-Event-Type", event.getTriggerType().toString()).header("X-Object-Type", event.getObjectType()).header("X-Event-Time", RFC1123_DATE_TIME_FORMATTER.print((ReadableInstant)new DateTime(event.getEpoch(), DateTimeZone.UTC))).header("X-Event-Epoch", "" + event.getEpoch()).header("X-Event-Id", event.getId()).header("X-Triggered-By", username).header("X-Hook-Id", webhook.getId()).header("X-Request-Id", call.getId()).header("X-Hmac-Sha512", SecurityUtils.computeHmacHex((String)postBody, (String)webhook.getSignatureKey())).header("X-Attempt-Number", "" + call.getAttemptNumber()).header("User-Agent", "Automate " + VersionResources.getVersion()).build();
                    LOGGER.info("Webhook Event " + String.valueOf(event.getTriggerType()) + " " + event.getId() + " call #" + call.getAttemptNumber() + " attempt");
                    if (!event.getTriggerType().equals((Object)EventType.Type.AUTOMATE_LICENSE_ERROR)) {
                        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.API_ADVANCED);
                    }
                    HashSet<String> fingerprints = new HashSet<String>();
                    if (webhook.getWhitelistedCertFingerprints() != null) {
                        for (String fingerprint : webhook.getWhitelistedCertFingerprints()) {
                            if (fingerprint == null || fingerprint.trim().length() <= 0) continue;
                            fingerprints.add(fingerprint.trim().toLowerCase());
                        }
                    }
                    if (fingerprints.size() == 0) {
                        client = new OkHttpClient.Builder().addNetworkInterceptor((Interceptor)new HeadersCaptureInterceptor(call)).build();
                    } else {
                        X509TrustManager trustManager = DropwizardRestClientFactory.getTrustManager(fingerprints);
                        SSLContext sslContext = SSLContext.getInstance("TLS");
                        sslContext.init(null, new TrustManager[]{trustManager}, null);
                        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                        client = new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, trustManager).addNetworkInterceptor((Interceptor)new HeadersCaptureInterceptor(call)).hostnameVerifier((hostname, session) -> {
                            try {
                                Certificate[] certificates = session.getPeerCertificates();
                                Certificate certificate = certificates[certificates.length - 1];
                                String fingerprint = DatatypeConverter.printHexBinary((byte[])MessageDigest.getInstance("SHA-256").digest(certificate.getEncoded())).toLowerCase();
                                LOGGER.info("Verifying host " + hostname + " with certificate " + fingerprint);
                                return true;
                            }
                            catch (NoSuchAlgorithmException | CertificateEncodingException | SSLPeerUnverifiedException e) {
                                return false;
                            }
                        }).build();
                    }
                    Call webCall = client.newCall(request);
                    this.schedulerApplication.getWebhookResource().persistWebhookEvent(event);
                    okhttp3.Response response = webCall.execute();
                    call.setResponseEpoch(Long.valueOf(response.receivedResponseAtMillis()));
                    call.setResponseStatus(response.code());
                    StringBuilder stringBuilder = new StringBuilder();
                    Headers headers = response.headers();
                    for (String headerName : headers.names()) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append("\n");
                        }
                        stringBuilder.append(headerName);
                        stringBuilder.append(": ");
                        stringBuilder.append(headers.get(headerName));
                    }
                    call.setResponseHeaders(stringBuilder.toString());
                    call.setResponseBody(response.body().string());
                    if (call.isSuccessful()) {
                        LOGGER.info("Webhook Event " + String.valueOf(event.getTriggerType()) + " " + event.getId() + " call #" + call.getAttemptNumber() + " response HTTP/" + call.getResponseStatus());
                    } else {
                        LOGGER.error("Webhook Event " + String.valueOf(event.getTriggerType()) + " " + event.getId() + " call #" + call.getAttemptNumber() + " response HTTP/" + call.getResponseStatus());
                    }
                }
                catch (Throwable t) {
                    Throwable certificateFingerprintException = null;
                    if (t instanceof SSLHandshakeException) {
                        HashSet<String> dummyFingerprints = new HashSet<String>();
                        dummyFingerprints.add("Invalid");
                        try (Response certificateResponse = null;){
                            Client dummyClient = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)("Webhook-" + webhook.getId() + "-dummyFingerprint"), dummyFingerprints, (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
                            WebTarget webTarget = dummyClient.target(webhook.getCallbackAddress());
                            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
                            certificateResponse = invocationBuilder.get();
                        }
                    }
                    call.setResponseEpoch(Long.valueOf(DateTime.now().getMillis()));
                    call.setResponseStatus(599);
                    Object exceptionMessage = ExceptionUtils.getExceptionPrintableMessage((Throwable)t) + (String)(certificateFingerprintException != null ? ", " + certificateFingerprintException.getLocalizedMessage() : "");
                    exceptionMessage = ((String)exceptionMessage).replace("., ", ", ");
                    String exceptionBody = ExceptionUtils.getExceptionPrintableMessage((Throwable)t) + (String)(certificateFingerprintException != null ? "\n" + certificateFingerprintException.getLocalizedMessage() : "");
                    call.setResponseBody(exceptionBody);
                    event.getStatus().setWarningMessage((String)exceptionMessage);
                    LOGGER.error("Webhook Event " + String.valueOf(event.getTriggerType()) + " " + event.getId() + " call #" + call.getAttemptNumber() + " failed", t);
                    if (certificateFingerprintException == null) break block28;
                    LOGGER.error(certificateFingerprintException.getLocalizedMessage());
                }
            }
            if (!call.isSuccessful()) {
                if (call.getResponseStatus() != 599) {
                    event.getStatus().setWarningMessage(this.iu.getFormattedString("WebhookCall.Message.ErrorResponse", (Object)("" + call.getResponseStatus())));
                }
                if (finalAttemptNumber >= this.schedulerApplication.getConfiguration().getDisableWebhookAfterFailedCallbacks()) {
                    LOGGER.error("Disabling " + String.valueOf(webhook) + " due to " + finalAttemptNumber + " failed attempts");
                    event.getStatus().setError(this.iu.getString("WebhookCall.Message.GiveUp"));
                    this.schedulerApplication.getWebhookResource().failWebhook(webhook.getId());
                } else {
                    this.schedulerApplication.getWebhookResource().setWebhookWarning(webhook.getId());
                }
            } else {
                event.getStatus().resetOkMessage("");
                Set<WebhookEvent> set = this.unsatisfiedEvents;
                synchronized (set) {
                    this.unsatisfiedEvents.remove(event);
                }
                this.schedulerApplication.getWebhookResource().clearWebhookErrors(webhook.getId());
            }
            this.schedulerApplication.getWebhookResource().persistWebhookEvent(event);
        });
        startTriggerThread.setDaemon(false);
        startTriggerThread.start();
    }

    @Override
    public void run() {
        this.handleEventCalls();
    }
}

