/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.workflow;

import com.google.gson.annotations.JsonAdapter;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.serialization.OperationListAdapter;
import com.nuix.automate.workflow.core.execution.workflow.OperationList;
import com.nuix.automate.workflow.core.execution.workflow.Workflow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WorkflowBuilderSubmission
extends UserPermissionModel {
    @Schema(description="Library ID", example="11111111-1111-1111-1111-111111111111")
    private String libraryId;
    @Schema(description="Workflow ID", example="11111111-1111-1111-1111-111111111111")
    private String workflowId;
    @Schema(description="Workflow Name", example="Standard Processing")
    private String workflowName;
    @Schema(description="Workflow Execution Mode")
    private ExecutionMode explicitExecutionMode;
    @Schema(description="Workflow Name", example="True")
    private Boolean enabled;
    @Schema(description="Workflow Description", example="This workflow processes data using standard settings")
    private String description;
    @Schema(description="Workflow Prerequisites")
    private List<String> prerequisites;
    @Schema(description="Workflow Usage", example="This workflow is used to process data")
    private String usage;
    @Schema(description="Workflow Operations")
    @JsonAdapter(value=OperationListAdapter.class)
    private OperationList operations;
    @Schema(description="Last Modified (Epoch)", example="1641034800000")
    private Long lastModified;
    @Schema(description="icon")
    private String icon;

    public WorkflowBuilderSubmission() {
    }

    public WorkflowBuilderSubmission(Workflow workflow) {
        this.description = workflow.getDescription();
        this.usage = workflow.getUsage();
        this.prerequisites = new ArrayList<String>(workflow.getPrerequisites());
        this.operations = new OperationList((Collection)workflow.getOperations());
    }

    public String getLibraryId() {
        return this.libraryId;
    }

    public void setLibraryId(String libraryId) {
        this.libraryId = libraryId;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public ExecutionMode getExplicitExecutionMode() {
        return this.explicitExecutionMode;
    }

    public void setExplicitExecutionMode(ExecutionMode explicitExecutionMode) {
        this.explicitExecutionMode = explicitExecutionMode;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(List<String> prerequisites) {
        this.prerequisites = prerequisites;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public OperationList getOperations() {
        return this.operations;
    }

    public void setOperations(OperationList operations) {
        this.operations = operations;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }
}

