/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.events;

import com.google.common.io.Files;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LogLevel;
import com.nuix.automate.workflow.core.execution.events.WorkflowExecutionProgressEvent;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.ScriptParameters;
import com.nuix.automate.workflow.core.execution.script.ScriptWorkflowExecution;
import com.nuix.automate.workflow.core.execution.workflow.UserCancelledException;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecutionEvent;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecutionListener;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.general.LineOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptWorkflowExecutionListener
implements WorkflowExecutionListener {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WorkflowExecutionListener.class);
    private ExecutionContext executionContext;
    private ScriptContext simpleScriptContext;
    private ScriptEngine scriptEngine;
    private ScriptWorkflowExecution scriptWorkflowExecution;
    private Invocable invocable;
    private final String WORKFLOW_EXECUTION_PROGRESS = "onWorkflowExecutionProgress";
    private final String OPERATION_FINISHED = "onOperationFinished";
    private final String WORKFLOW_EXECUTION_STATE_CHANGED = "onWorkflowExecutionStateChanged";

    public ScriptWorkflowExecutionListener(String scriptLocation, ExecutionContext executionContext) {
        this.executionContext = executionContext;
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        String fileExtension = Files.getFileExtension((String)scriptLocation).toLowerCase();
        switch (Files.getFileExtension((String)scriptLocation).toLowerCase()) {
            case "py": {
                this.scriptEngine = scriptEngineManager.getEngineByName("python");
                break;
            }
            case "js": {
                this.scriptEngine = scriptEngineManager.getEngineByName("ECMAScript");
                break;
            }
            case "rb": {
                this.scriptEngine = scriptEngineManager.getEngineByName("ruby");
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot initialize Workflow Execution script. Unsupported script file extension " + fileExtension);
            }
        }
        this.simpleScriptContext = this.scriptEngine.getContext();
        this.simpleScriptContext.setAttribute("AUTOMATE_VERSION", executionContext.getVersion(), 100);
        if (executionContext.nuixVersion != null) {
            this.simpleScriptContext.setAttribute("NUIX_VERSION", executionContext.nuixVersion.toString(), 100);
        }
        ScriptParameters scriptParameters = new ScriptParameters(executionContext, null);
        this.simpleScriptContext.setAttribute("parameters", scriptParameters, 100);
        this.simpleScriptContext.setAttribute("$parameters", scriptParameters, 100);
        this.scriptWorkflowExecution = new ScriptWorkflowExecution(executionContext.workflowExecution);
        this.simpleScriptContext.setAttribute("workflowExecution", this.scriptWorkflowExecution, 100);
        this.simpleScriptContext.setAttribute("$workflowExecution", this.scriptWorkflowExecution, 100);
        this.simpleScriptContext.setAttribute("workflow_execution", this.scriptWorkflowExecution, 100);
        this.simpleScriptContext.setAttribute("$workflow_execution", this.scriptWorkflowExecution, 100);
        LineOutputStream lineOutputStream = new LineOutputStream();
        lineOutputStream.addListener(line -> {
            LOGGER.info(line);
            executionContext.workflowExecution.log("> " + line);
        });
        this.simpleScriptContext.setWriter(new PrintWriter(lineOutputStream, true));
        LineOutputStream lineErrorOutputStream = new LineOutputStream();
        lineErrorOutputStream.addListener(line -> executionContext.workflowExecution.log(line, LogLevel.WARNING));
        this.simpleScriptContext.setErrorWriter(new PrintWriter(lineErrorOutputStream, true));
        File file = new File(scriptLocation);
        this.simpleScriptContext.setAttribute("javax.script.filename", file.getAbsolutePath(), 100);
        try {
            LOGGER.info("Initializing execution script");
            Compilable compilable = (Compilable)((Object)this.scriptEngine);
            CompiledScript compiledCode = compilable.compile(FileUtils.readFileWithAutodetectEncoding((File)new File(scriptLocation)));
            compiledCode.eval();
            this.invocable = (Invocable)((Object)this.scriptEngine);
            LOGGER.info("Script initialized successfully");
        }
        catch (IOException | ScriptException e) {
            LOGGER.error("Cannot register script", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void beforeWorkflowExecutionInitialized(WorkflowExecutionEvent workflowExecutionEvent) {
    }

    @Override
    public void workflowExecutionInitialized(WorkflowExecutionEvent workflowExecutionEvent) {
    }

    @Override
    public void workflowExecutionStateChanged(WorkflowExecutionEvent workflowExecutionEvent, ExecutionState executionState) {
        int executionPosition = -1;
        try {
            executionPosition = this.executionContext.workflowExecution.getWorkflowExecutionPosition();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.triggerCallback(executionPosition, "onWorkflowExecutionStateChanged");
    }

    @Override
    public void workflowExecutionProgress(WorkflowExecutionEvent workflowExecutionEvent, int operationWithProgressPosition) {
        this.triggerCallback(operationWithProgressPosition, "onWorkflowExecutionProgress");
    }

    @Override
    public void workflowExecutionPrerequisiteError(WorkflowExecutionEvent workflowExecutionEvent, String errorTitle, String errorMessage, String detailedHtmlErrorMessage, Exception e) {
    }

    @Override
    public void workflowExecutionLog(WorkflowExecutionEvent workflowExecutionEvent, String logMessage, LogLevel logLevel) {
    }

    @Override
    public void beforeOperationStart(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
    }

    @Override
    public void afterOperationSkipped(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
    }

    @Override
    public void afterOperationFinish(WorkflowExecutionEvent workflowExecutionEvent, Operation operation, boolean operationIsLast) {
        this.triggerCallback(this.executionContext.workflowExecution.getWorkflowExecutionPosition(), "onWorkflowExecutionProgress");
        this.triggerCallback(this.executionContext.workflowExecution.getWorkflowExecutionPosition(), "onOperationFinished");
    }

    @Override
    public void afterOperationError(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
    }

    @Override
    public void onOperationWarning(WorkflowExecutionEvent workflowExecutionEvent, Operation operation, String message) {
    }

    @Override
    public void onConfigurationPrompt(WorkflowExecutionEvent workflowExecutionEvent, Operation operation) {
    }

    @Override
    public void onUseCasePrompt(WorkflowExecutionEvent workflowExecutionEvent, ExecutionContext context, Operation operation) throws UserCancelledException {
    }

    void triggerCallback(int operationWithProgressPosition, String callbackName) {
        Operation operation = null;
        try {
            operation = this.executionContext.workflowExecution.getWorkflow().getOperations().get(operationWithProgressPosition);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (operation == null) {
            try {
                operation = this.executionContext.workflowExecution.getWorkflow().getOperations().get(this.executionContext.workflowExecution.getWorkflowExecutionPosition());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        WorkflowExecutionProgressEvent workflowExecutionProgressEvent = new WorkflowExecutionProgressEvent(this.scriptWorkflowExecution, operation, this.scriptWorkflowExecution);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Calling script workflowExecutionProgress " + String.valueOf(workflowExecutionProgressEvent));
        }
        if (this.invocable != null) {
            try {
                this.invocable.invokeFunction(callbackName, workflowExecutionProgressEvent);
            }
            catch (ScriptException e) {
                LOGGER.error("Cannot call Workflow Execution script function " + callbackName, (Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

