/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.ecc.internal.EccCollectionStrategy;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRadioButtonGroup;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.RadioButtonValue;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.ConfigureEccConnectionOperation;
import com.nuix.automate.workflow.core.execution.operations.EccOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.SetEccCaseOperation;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FormFieldRadioButtonGroup(name="useCollectionSourcesFileRadioButtonGroup", radioButton="useCollectionSourcesFile", values={@RadioButtonValue(value="true", component="collectionSourcesFileLocation"), @RadioButtonValue(value="false", component="collectionComputerSources")})
@OperationMetadata(alias=OperationAlias.ADD_COLLECTION_SOURCES_TO_ECC_COLLECTION, mode=ExecutionMode.AUTOMATE_NATIVE)
@OperationTags(value={@OperationTag(name="Platform", value={"ECC"}), @OperationTag(name="Category", value={"CONFIGURATION"})})
@OperationParameters(value={@OperationParameter(label="computerIds", parameter="{ecc_computer_ids}"), @OperationParameter(label="computerNames", parameter="{ecc_computer_names}")})
public class AddCollectionSourcesToEccCollectionOperation
extends EccOperation {
    @FormField
    public EccCollectionStrategy collectionStrategy;
    @FormField(enableOn={@OnField(name="collectionStrategy", value={"CUSTOM_PATH"})})
    public List<String> collectionCustomPaths;
    @FormField
    public boolean useCollectionSourcesFile;
    @FormField(enableOn={@OnField(name="useCollectionSourcesFile", value={"false"})})
    @ExcludeFromPrintableOptions
    public List<String> collectionComputerSources;
    @FormField(enableOn={@OnField(name="useCollectionSourcesFile")})
    public String collectionSourcesFileLocation;

    public boolean getDisplayCollectionSources() {
        return !this.useCollectionSourcesFile;
    }

    public boolean getDisplayCollectionSourcesFileLocation() {
        return this.useCollectionSourcesFile;
    }

    public AddCollectionSourcesToEccCollectionOperation() {
        this.requiresCase = false;
        this.useCollectionSourcesFile = false;
        this.collectionStrategy = EccCollectionStrategy.PREDEFINED;
        this.collectionCustomPaths = new ArrayList<String>();
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("AddCollectionSourcesToEccCollectionOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        boolean detectedConfigureEccConnectionOperation = false;
        boolean detectedSetEccCaseOperation = false;
        for (int i = 0; i < this.executionContext.workflowExecution.getWorkflow().getOperations().size(); ++i) {
            Operation o = this.executionContext.workflowExecution.getWorkflow().getOperations().get(i);
            if (o instanceof ConfigureEccConnectionOperation) {
                detectedConfigureEccConnectionOperation = true;
            }
            if (o instanceof SetEccCaseOperation) {
                detectedSetEccCaseOperation = true;
            }
            if (o == this) break;
        }
        if (!detectedConfigureEccConnectionOperation) {
            prerequisites.add(this.iu.getString("EccOperation.Prerequisites.MissingEccConnection"));
        }
        if (!detectedSetEccCaseOperation) {
            prerequisites.add(this.iu.getString("EccOperation.Prerequisites.MissingEccCase"));
        }
        if (this.useCollectionSourcesFile && (this.collectionSourcesFileLocation == null || this.collectionSourcesFileLocation.trim().equals(""))) {
            prerequisites.add(this.iu.getString("AddCollectionSourcesToEccCollectionOperation.Prerequisites.CollectionSourceFile"));
        }
        if (!(this.useCollectionSourcesFile || this.collectionComputerSources != null && this.collectionComputerSources.size() != 0)) {
            prerequisites.add(this.iu.getString("AddCollectionSourcesToEccCollectionOperation.Prerequisites.AtleastOneSource"));
        }
        return prerequisites;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        return features;
    }
}

