/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.ecc.internal.EccCollectableSource;
import com.nuix.automate.utils.ecc.internal.EccCollectableSources;
import com.nuix.automate.utils.ecc.internal.EccCollectionSource;
import com.nuix.automate.utils.ecc.internal.EccIdentifierType;
import com.nuix.automate.utils.ecc.internal.EccUtils;
import com.nuix.automate.utils.ecc.responses.computers.Computer;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.AddCollectionSourcesToEccCollectionOperation;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AddCollectionSourcesToEccCollectionOperationImplementation
extends AddCollectionSourcesToEccCollectionOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddCollectionSourcesToEccCollectionOperation.class);
    private transient double percentageComplete;
    private transient String stageName;
    private transient EccUtils utils;

    @Override
    protected void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("AddCollectionSourcesToEccCollectionOperation.Stage.InitializingCollectionSource");
                this.percentageComplete = 0.15;
                this.utils = EccUtils.getInstance();
                this.initializeEccClient();
                ArrayList<EccCollectionSource> eccCollectionSources = new ArrayList<EccCollectionSource>();
                ArrayList<String> computerSources = new ArrayList<String>(this.collectionComputerSources);
                if (this.useCollectionSourcesFile) {
                    this.collectionSourcesFileLocation = this.executionContext.evalParameters(this.collectionSourcesFileLocation, this);
                    this.addExecutionLog(this.iu.getFormattedString("AddCollectionSourcesToEccCollectionOperation.Log.CollectionSourcesFile", (Object)this.collectionSourcesFileLocation));
                    Path path = Paths.get(this.collectionSourcesFileLocation, new String[0]);
                    computerSources = new ArrayList();
                    List names = FileUtils.loadVariableColumnDetectFormatFile((File)path.toFile());
                    Iterator iterator = names.iterator();
                    while (iterator.hasNext()) {
                        Object[] name = (Object[])iterator.next();
                        computerSources.add(name[0].toString());
                    }
                }
                ArrayList<String> evaluatedCollectionComputerSources = new ArrayList<String>();
                for (String computerName : computerSources) {
                    List<String> evaluatedComputerName = this.executionContext.evalOneOrManyStringParameter(computerName, this);
                    evaluatedCollectionComputerSources.addAll(evaluatedComputerName);
                }
                for (String computerName : evaluatedCollectionComputerSources) {
                    EccCollectionSource source = new EccCollectionSource();
                    source.setSourceIdentifier(computerName);
                    source.setSourceIdentifierType(EccIdentifierType.NAME);
                    source.setSourceCollectionStrategy(this.collectionStrategy);
                    source.setSourceCollectionCustomPaths(this.collectionCustomPaths);
                    eccCollectionSources.add(source);
                }
                this.stageName = this.iu.getString("AddCollectionSourcesToEccCollectionOperation.Stage.InitializingCollectionSource");
                this.percentageComplete = 0.3;
                HashMap<Integer, Computer> computerMap = new HashMap<Integer, Computer>();
                List<Computer> computers = this.eccRestClient.getComputers();
                if (computers == null || computers.size() == 0) {
                    throw new Exception(this.iu.getString("AddCollectionSourcesToEccCollectionOperation.Error.NoComputers"));
                }
                for (Computer computer : computers) {
                    computerMap.put(computer.getId(), computer);
                }
                ArrayList<EccCollectableSource> eccCollectableSources = new ArrayList<EccCollectableSource>();
                for (EccCollectionSource eccCollectionSource : eccCollectionSources) {
                    List filteredComputers = this.utils.filterAllComputers(computerMap.values(), eccCollectionSource.getSourceIdentifierType(), eccCollectionSource.getSourceIdentifier());
                    if (filteredComputers != null) {
                        ArrayList<String> computerIds = new ArrayList<String>();
                        for (Computer computer : filteredComputers) {
                            eccCollectableSources.add(new EccCollectableSource(eccCollectionSource, computer));
                            computerIds.add(String.valueOf(computer.getId()));
                        }
                        if (filteredComputers.size() <= 1) continue;
                        this.addExecutionLog(this.iu.getFormattedString("AddCollectionSourcesToEccCollectionOperation.Log.MultipleComputerSameName", new Object[]{((Computer)filteredComputers.get(0)).getName(), String.join((CharSequence)", ", computerIds)}));
                        continue;
                    }
                    this.addWarning(this.iu.getFormattedString("AddCollectionSourcesToEccCollectionOperation.Warning.ComputerDoesNotExist", new Object[]{eccCollectionSource.getSourceIdentifierType().toString(), eccCollectionSource.getSourceIdentifier()}));
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (EccCollectableSource eccCollectableSource : eccCollectableSources) {
                    hashMap.put(String.valueOf(eccCollectableSource.getId()), eccCollectableSource.getName());
                }
                if (hashMap.size() > 0) {
                    this.addExecutionLog(this.iu.getFormattedString("AddCollectionSourcesToEccCollectionOperation.Log.Computers", (Object)hashMap.size()));
                }
                if (eccCollectableSources.size() > 0) {
                    this.addExecutionLog(this.iu.getFormattedString("AddCollectionSourcesToEccCollectionOperation.Log.TotalSources", (Object)eccCollectableSources.size()));
                }
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_computer_ids}", SerializationUtils.toJson(hashMap.keySet()))));
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{ecc_computer_names}", SerializationUtils.toJson(hashMap.values()))));
                EccCollectableSources eccCollectableSources2 = new EccCollectableSources();
                eccCollectableSources2.setSources(eccCollectableSources);
                this.executionContext.getExecutionCustomParameters().put(this.trackParameter((Parameter)new StaticParameter("{wfn_ecc_collection_sources}", SerializationUtils.toJson((Object)eccCollectableSources2))));
                this.percentageComplete = 0.99;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    protected double getPercentageComplete() {
        return this.percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            result = (String)result + " / " + this.stageName;
        }
        return result;
    }
}

