/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.ComparisonOperator;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldHelper;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.workflow.DatasetMetadata;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.DatasetOperation;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.operations.RemoteWorkerBasedOperation;
import com.nuix.automate.workflow.core.execution.options.addevidence.LoadfileType;
import com.nuix.automate.workflow.core.execution.options.addevidence.SourceScope;
import com.nuix.automate.workflow.core.execution.options.addevidence.VaultLinkedExportIngestionMethod;
import com.nuix.automate.workflow.core.execution.workflow.Feature;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

@OperationMetadata(alias=OperationAlias.ADD_EVIDENCE, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"LOAD"})})
@OperationParameters(value={@OperationParameter(label="queryRetrieveItemsAdded", parameter="batch-load-guid:{last_batch_load_guid}"), @OperationParameter(label="alternativeQueryRetrieveItemsAdded", parameter="(guid:{last_evidence_guid} OR path-guid:{last_evidence_guid})"), @OperationParameter(label="keywordRetrieveLastEvidenceName", parameter="{last_evidence_name}"), @OperationParameter(parameter="{vault_duplicate_families_tag_name}")})
@FormFieldRow(name="duplicateFamilyTagNameRow", children={"tagDuplicateFamilies", "duplicateFamilyTagName"}, visibleOn={@OnField(name="useLinkedFilePlaceholderForDuplicateFamilies")})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class AddEvidenceOperation
extends Operation
implements DatasetOperation,
RemoteWorkerBasedOperation {
    @FormField(helpers={@FormFieldHelper(location="#_add_evidence_from_sharepoint", value={"SHAREPOINT"}), @FormFieldHelper(location="#_add_evidence_from_exchange", value={"EXCHANGE"}), @FormFieldHelper(location="#_add_evidence_from_ev", value={"ENTERPRISE_VAULT"}), @FormFieldHelper(location="#_add_evidence_from_s3", value={"S3"}), @FormFieldHelper(location="#_add_evidence_from_sql_server", value={"SQL_SERVER"}), @FormFieldHelper(location="#_add_evidence_from_oracle", value={"ORACLE"}), @FormFieldHelper(location="#_add_evidence_from_documentum", value={"DOCUMENTUM"}), @FormFieldHelper(location="#_add_evidence_from_dropbox", value={"DROPBOX"}), @FormFieldHelper(location="#_add_evidence_from_ssh", value={"SSH"}), @FormFieldHelper(location="#_add_evidence_from_historical_twitter", value={"HISTORICAL_TWITTER"}), @FormFieldHelper(location="#_add_evidence_from_microsoft_graph", value={"MICROSOFT_GRAPH"}), @FormFieldHelper(location="#_add_evidence_from_evidence_listing", value={"EVIDENCE_LISTING"}), @FormFieldHelper(location="#_add_evidence_from_google_vault_export", value={"GOOGLE_VAULT_EXPORT"})})
    public SourceScope sourceScope;
    @FormField(visibleOn={@OnField(name="sourceScope", value={"GOOGLE_VAULT_EXPORT"})})
    public VaultLinkedExportIngestionMethod linkedExportIngestionMethod;
    @FormField(visibleOn={@OnField(name="linkedExportIngestionMethod", value={"ADD_AS_CHILD_ITEM"})})
    public int linkedFileAddAsFamilyItemLimit = 10;
    @FormField(visibleOn={@OnField(name="linkedExportIngestionMethod", value={"ADD_AS_CHILD_ITEM"})})
    @ExcludeFromPrintableOptions
    public boolean useLinkedFilePlaceholderForDuplicateFamilies = true;
    @FormField
    public boolean tagDuplicateFamilies = true;
    @FormField
    public String duplicateFamilyTagName = "Automate|Google Vault|Duplicates";
    @FormField(visibleOn={@OnField(name="sourceScope", value={"GOOGLE_VAULT_EXPORT"})})
    public boolean associateGoogleVaultMetadata = true;
    @FormField(visibleOn={@OnField(name="sourceScope", value={"PATH_ITEM", "PATH_CONTENTS", "PATH_CONTENTS_AS_SEPARATE_EVIDENCE", "EVIDENCE_LISTING", "DATASET", "LOADFILE", "GOOGLE_VAULT_EXPORT"})})
    public String source = "";
    @FormField(visibleOn={@OnField(name="sourceScope", value={"LOADFILE"})})
    public LoadfileType loadfileType = LoadfileType.CSV;
    @FormField(visibleOn={@OnField(name="sourceScope", comparisonOperator=ComparisonOperator.NOT_EQUAL, value={"PATH_CONTENTS_AS_SEPARATE_EVIDENCE", "EVIDENCE_LISTING", "DATASET", "GOOGLE_VAULT_EXPORT"})})
    public String evidenceName = "Evidence 1";
    @FormField(visibleOn={@OnField(name="sourceScope", value={"PATH_CONTENTS_AS_SEPARATE_EVIDENCE"})}, required=false)
    public String evidenceNamePrefix;
    @FormField(visibleOn={@OnField(name="sourceScope", value={"EVIDENCE_LISTING"})})
    @ExcludeFromPrintableOptions
    public boolean omitEvidenceFolderName;
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.TIMEZONE_IDS)
    public String timeZoneId = null;
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.CHARSETS)
    public String sourceEncoding;
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.CHARSETS)
    public String zipEncoding;
    @FormField(required=false, componentType=FieldComponentType.NUIX_PROFILE, allowedValuesDynamicType=DynamicValuesType.METADATA_IMPORT_PROFILES)
    public String metadataImportProfile;
    @ExcludeFromPrintableOptions
    public boolean predefined = true;
    @FormField(required=false, columnFields={@FormFieldColumn(label="name"), @FormFieldColumn(label="value")})
    @ExcludeFromPrintableOptions
    public List<Object[]> customMetadata;

    public AddEvidenceOperation() {
        this.sourceScope = SourceScope.PATH_ITEM;
        this.sourceEncoding = Charset.defaultCharset().name();
        this.zipEncoding = Charset.defaultCharset().name();
        this.timeZoneId = TimeZone.getDefault().getID();
        this.customMetadata = new ArrayList<Object[]>();
        this.linkedExportIngestionMethod = VaultLinkedExportIngestionMethod.ADD_AS_EVIDENCE_WITH_PLACEHOLDERS;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("AddEvidenceOperation.Property.Name");
    }

    @Override
    public void normalize() {
        super.normalize();
        HashMap<String, String> sourceEncodingMapping = new HashMap<String, String>();
        sourceEncodingMapping.put("ADOBE_STANDARD_ENCODING", "Adobe-Standard-Encoding");
        sourceEncodingMapping.put("WINDOWS_1252", "windows-1252");
        sourceEncodingMapping.put("CP_850", "IBM850");
        sourceEncodingMapping.put("UTF_8", "UTF-8");
        String normalizedEncoding = (String)sourceEncodingMapping.get(this.sourceEncoding);
        if (normalizedEncoding != null) {
            this.sourceEncoding = normalizedEncoding;
        }
        ArrayList<Object[]> normalizedCustomMetatada = new ArrayList<Object[]>();
        if (this.customMetadata != null) {
            for (Object[] customMetadataItem : this.customMetadata) {
                if (customMetadataItem.length <= 1 || customMetadataItem[0].toString().length() <= 0 && customMetadataItem[1].toString().length() <= 0) continue;
                normalizedCustomMetatada.add(customMetadataItem);
            }
        }
        this.customMetadata = normalizedCustomMetatada;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.predefined) {
            if (this.source.trim().length() == 0 && (SourceScope.usesSourcePath(this.sourceScope) || this.sourceScope == SourceScope.DATASET)) {
                prerequisites.add(this.iu.getString("AddEvidenceOperation.Prerequisites.SourcePathRequired"));
            }
            if (this.evidenceName.trim().length() == 0 && SourceScope.usesEvidenceName(this.sourceScope)) {
                prerequisites.add(this.iu.getString("AddEvidenceOperation.Prerequisites.EvidenceNameRequired"));
            }
        }
        if (!(activity != Operation.PrerequisitesActivity.RUN_UNATTENDED && activity != Operation.PrerequisitesActivity.SUBMIT_UNATTENDED || this.predefined)) {
            prerequisites.add(this.iu.getString("AddEvidenceOperation.Prerequisites.PredefinedRequired"));
        }
        if (SourceScope.isNetworkScope(this.sourceScope)) {
            if (this.sourceScope == SourceScope.MICROSOFT_GRAPH && !this.executionContext.versionGreaterOrEqualTo("9.0.0")) {
                prerequisites.add(this.iu.getFormattedString("AddEvidenceOperation.Prerequisites.SourceScopeRequiresNewerVersion", new Object[]{this.sourceScope, "9.0.0"}));
            } else if (!this.executionContext.versionGreaterOrEqualTo("8.0.0")) {
                prerequisites.add(this.iu.getFormattedString("AddEvidenceOperation.Prerequisites.SourceScopeRequiresNewerVersion", new Object[]{this.sourceScope, "8.0.0"}));
            }
        }
        return prerequisites;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.LOAD;
    }

    @Override
    public Set<Feature> getRequiredFeatures() {
        HashSet<Feature> features = new HashSet<Feature>();
        if (this.predefined) {
            features.add(Feature.NUIX);
        } else {
            features.add(Feature.NUIX_WORKSTATION);
        }
        return features;
    }

    @Override
    public void setDatasetsMetadata(Map<String, DatasetMetadata> datasetsMetadata) {
    }

    @Override
    public String getProcessingJobGuid() {
        return null;
    }

    @Override
    public Integer getWorkerMemory() {
        return null;
    }

    @Override
    public Integer getAddedWorkerCount() {
        return null;
    }
}

