/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldRow;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.addevidencerepository.CustodianMode;
import com.nuix.automate.workflow.core.execution.options.addevidencerepository.EvidenceNameMode;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

@FormFieldRow(name="evidenceNamingRow", children={"evidenceNameUsePrefix", "evidenceNamePrefix"})
@OperationMetadata(alias=OperationAlias.ADD_EVIDENCE_REPOSITORY, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"LOAD"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class AddEvidenceRepositoryOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddEvidenceRepositoryOperation.class);
    @FormField
    public String source = "";
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    @ExcludeFromPrintableOptions
    public CustodianMode custodianMode = CustodianMode.NO_CUSTODIANS;
    @FormField(min=1.0, enableOn={@OnField(name="custodianMode", value={"CUSTODIAN_AT_LEVEL"})})
    @ExcludeFromPrintableOptions
    public int custodianLevel = 2;
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    public EvidenceNameMode evidenceNameMode = EvidenceNameMode.FROM_CONTENT;
    @FormField
    public boolean evidenceNameUsePrefix = false;
    @FormField(enableOn={@OnField(name="evidenceNameUsePrefix")})
    public String evidenceNamePrefix = this.iu.getString("AddEvidenceRepositoryOperation.Property.Evidence");
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.TIMEZONE_IDS)
    public String timeZoneId = TimeZone.getDefault().getID();
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.CHARSETS)
    public String sourceEncoding = "UTF-8";
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.ISO_LANGUAGES)
    public String sourceLanguageLocale = Locale.getDefault().getLanguage();
    @FormField(componentType=FieldComponentType.DROPDOWN, allowedValuesDynamicType=DynamicValuesType.ISO_COUNTRIES)
    public String sourceLocalCountry = Locale.getDefault().getCountry();

    @Override
    public String getOperationName() {
        return this.iu.getString("AddEvidenceRepositoryOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.source == null || this.source.trim().length() == 0) {
            prerequisites.add(this.iu.getString("AddEvidenceRepositoryOperation.Prerequisites.RepositoryPathMustBeSpecified"));
        }
        return prerequisites;
    }
}

