/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroups;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.models.internal.formbuilder.PositionLabel;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.List;

@FormFieldGroups(value={@FormFieldGroup(name="newClusterRunOptions", children={"groupSimilarItemsByGroup", "resemblanceThreshold"}, visibleOn={@OnField(name="createIfNotExists")}), @FormFieldGroup(name="groupSimilarItemsByGroup", children={"useChainedNearDuplicates", "useEmailThreads"}, styled=false, positionLabel=@PositionLabel(left="groupSimilarItemsBy"))})
@OperationMetadata(alias=OperationAlias.ADD_ITEMS_TO_CLUSTER_RUN, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"CULLING"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class AddItemsToClusterRunOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddItemsToClusterRunOperation.class);
    @FormField(required=false)
    public String scope = "path-guid:{last_evidence_guid} AND flag:audited";
    @FormField
    public String clusterRunName = "Cluster run";
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    @ExcludeFromPrintableOptions
    public boolean createIfNotExists = true;
    @FormField
    public boolean useChainedNearDuplicates = true;
    @FormField
    public boolean useEmailThreads = false;
    @FormField(min=0.01, max=1.0)
    public double resemblanceThreshold = 0.85;

    @Override
    public String getOperationName() {
        return this.iu.getString("AddItemsToClusterRunOperation.Property.Name");
    }

    @Override
    public OperationAlias getOperationAlias() {
        return OperationAlias.ADD_ITEMS_TO_CLUSTER_RUN;
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.clusterRunName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("AddItemsToClusterRunOperation.Prerequisites.ClusterRunNameMustBeSpecified"));
        }
        if (!this.useEmailThreads && !this.useChainedNearDuplicates) {
            prerequisites.add(this.iu.getString("AddItemsToClusterRunOperation.Prerequisites.AtLeastOneOptionMustBeSelected"));
        }
        if (this.resemblanceThreshold > 1.0 || this.resemblanceThreshold < 0.0) {
            prerequisites.add(this.iu.getString("AddItemsToClusterRunOperation.Prerequisites.ThresholdMustBeBetween"));
        }
        return prerequisites;
    }
}

