/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldColumn;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

@OperationMetadata(alias=OperationAlias.ADD_TO_COMPOUND_CASE, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"MANAGEMENT"})})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class AddToCompoundCaseOperation
extends Operation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddToCompoundCaseOperation.class);
    @FormField(columnFields={@FormFieldColumn(label="locations")})
    public List<String> childCaseLocations = new ArrayList<String>();
    @FormField
    public boolean skipReloadingCompoundCase = false;

    @Override
    public String getOperationName() {
        return this.iu.getString("AddToCompoundCaseOperation.Property.Name");
    }

    @Override
    public void normalize() {
        super.normalize();
        LinkedHashSet<String> normalizedLocations = new LinkedHashSet<String>();
        for (String location : this.childCaseLocations) {
            String normalizedLocation = location.trim();
            if (normalizedLocation.length() <= 0) continue;
            normalizedLocations.add(normalizedLocation);
        }
        this.childCaseLocations.clear();
        this.childCaseLocations.addAll(normalizedLocations);
    }
}

