/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.models.internal.formbuilder.FieldComponentType;
import com.nuix.automate.utils.models.internal.formbuilder.FormField;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldGroup;
import com.nuix.automate.utils.models.internal.formbuilder.OnField;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.workflow.core.execution.annotations.ExcludeFromPrintableOptions;
import com.nuix.automate.workflow.core.execution.annotations.OperationLicenseModule;
import com.nuix.automate.workflow.core.execution.annotations.OperationMetadata;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameter;
import com.nuix.automate.workflow.core.execution.annotations.OperationParameters;
import com.nuix.automate.workflow.core.execution.annotations.OperationTag;
import com.nuix.automate.workflow.core.execution.annotations.OperationTags;
import com.nuix.automate.workflow.core.execution.operations.Operation;
import com.nuix.automate.workflow.core.execution.options.itemset.DeduplicateBy;
import com.nuix.automate.workflow.core.execution.options.itemset.DeduplicationMethod;
import com.nuix.automate.workflow.core.execution.options.itemset.InclusionStrategy;
import java.util.List;

@FormFieldGroup(name="createItemSetGroup", children={"deduplicateBy", "deduplicationMethod", "itemSetDescription"}, visibleOn={@OnField(name="createIfNotExists")})
@OperationMetadata(alias=OperationAlias.ADD_TO_ITEMSET, mode=ExecutionMode.AUTOMATE_NUIX)
@OperationTags(value={@OperationTag(name="Platform", value={"NUIX_ENGINE"}), @OperationTag(name="Category", value={"DEDUPLICATION"})})
@OperationParameters(value={@OperationParameter(label="queryRetrieveDeduplicatedOriginalItems", parameter="item-set-batch:\"{last_item_set_originals_batch}\""), @OperationParameter(label="queryRetrieveAllDeduplicatedOriginal", parameter="item-set-originals:\"{last_item_set_name}\"")})
@OperationLicenseModule(module=ModuleType.WORKFLOW_ENGINE)
public class AddToItemSetOperation
extends Operation {
    @FormField(required=false)
    public String scope = "path-guid:{last_evidence_guid} AND flag:audited";
    @FormField
    public String itemSetName = "All Items";
    @FormField(allowedValues={"SELECTED_ITEMS"})
    @ExcludeFromPrintableOptions
    public InclusionStrategy inclusionStrategy = InclusionStrategy.SELECTED_ITEMS;
    @FormField
    public String batchName = "{date_time}";
    @FormField(componentType=FieldComponentType.RADIO_BUTTON)
    @ExcludeFromPrintableOptions
    public boolean createIfNotExists = true;
    @FormField
    public DeduplicateBy deduplicateBy;
    @FormField
    public DeduplicationMethod deduplicationMethod = DeduplicationMethod.MD5;
    @FormField(componentType=FieldComponentType.TEXTAREA, required=false)
    public String itemSetDescription = "";

    public AddToItemSetOperation() {
        this.deduplicateBy = DeduplicateBy.FAMILY;
    }

    @Override
    public String getOperationName() {
        return this.iu.getString("AddToItemSetOperation.Property.Name");
    }

    @Override
    public List<String> getPrerequisites(Operation.PrerequisitesActivity activity) {
        List<String> prerequisites = super.getPrerequisites(activity);
        if (this.itemSetName.trim().length() == 0) {
            prerequisites.add(this.iu.getString("AddToItemSetOperation.Prerequisites.ItemSetNameMustBeSpecified"));
        }
        return prerequisites;
    }
}

