/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.operations.AddToItemSetOperation;
import com.nuix.automate.workflow.core.execution.options.itemset.DeduplicateBy;
import com.nuix.automate.workflow.core.execution.options.itemset.DeduplicationMethod;
import com.nuix.automate.workflow.core.nuix.CustomDeduplicationField;
import com.nuix.automate.workflow.core.nuix.CustomItemExpression;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import nuix.Item;
import nuix.ItemEventCallback;
import nuix.ItemSet;
import nuix.ItemSetBatch;

public class AddToItemSetOperationImplementation
extends AddToItemSetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AddToItemSetOperation.class);
    private transient ItemSet itemSet;
    private transient Set<Item> items;
    private transient DeduplicationMethod itemSetDeduplicationMethod;
    private transient Map itemSetSettings;
    private transient Set<Item> topLevelItems;
    private transient Set<Item> nonTopLevelItems;
    private transient int stageId;
    private transient int stageCount;
    private transient long addToItemSetItemsProcessed;
    private transient long addToItemSetItemsTotal;
    private transient String addToItemSetItemsStageName;
    private transient String stageName;
    private transient StageType stageType;
    private transient double stageProgress;
    private transient AtomicLong itemsProcessed = new AtomicLong(0L);
    private transient long stageTotalCount;

    public boolean usingLegacyWorkaround() {
        return this.executionContext.nuixVersion.compareTo(new Version("7.4.0")) < 0;
    }

    private Boolean batchExists(String batchName, ItemSet nuixItemSet) {
        Collection batches = nuixItemSet.getBatches();
        for (ItemSetBatch batch : batches) {
            if (!batch.getName().equals(batchName)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startTriggered() throws Exception {
        Version requiredNuixVersion;
        this.executionContext.closeAllTabs();
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.items = this.executionContext.nuixCase.searchUnsorted(NuixUtils.addAndQuery(this.scope, "has-exclusion:0"));
        this.itemSetName = this.executionContext.evalParameters(this.itemSetName, this);
        this.itemSet = this.executionContext.nuixCase.findItemSetByName(this.itemSetName);
        boolean itemSetExisted = this.itemSet != null;
        long itemsInOriginalScope = this.items.size();
        this.addExecutionLog(this.iu.getFormattedString("AddToItemSetOperation.Log.ItemSetName", (Object)this.itemSetName));
        this.addExecutionLog(this.iu.getFormattedString("AddToItemSetOperation.Log.ItemSetExistedBefore", (Object)(itemSetExisted ? this.iu.getString("General.Yes") : this.iu.getString("General.No"))));
        this.addExecutionLog(this.iu.getFormattedString("AddToItemSetOperation.Log.ScopeQuery", (Object)this.scope));
        this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.ScopeCount", itemsInOriginalScope));
        LOGGER.info("Scope count: " + itemsInOriginalScope);
        if (!itemSetExisted) {
            LOGGER.info("Itemset '" + this.itemSetName + "' does not exist");
            if (!this.createIfNotExists) throw new Exception(this.iu.getFormattedString("AddToItemSetOperation.Exception.ItemSetDoesNotExist", (Object)this.itemSetName));
            LOGGER.info("Building itemset properties");
            this.itemSetSettings = new HashMap();
            LOGGER.info("Setting property 'deduplication' to '" + this.deduplicationMethod.toNuixString() + "'");
            this.itemSetSettings.put("deduplication", this.deduplicationMethod.toNuixString());
            LOGGER.info("Setting property 'deduplicateBy' to '" + this.deduplicateBy.toNuixString() + "'");
            this.itemSetSettings.put("deduplicateBy", this.deduplicateBy.toNuixString());
            LOGGER.info("Creating itemset '" + this.itemSetName + "'");
            this.itemSet = this.executionContext.nuixCase.createItemSet(this.itemSetName, this.itemSetSettings);
            String scriptedDeduplicationSuffix = "";
            if (this.deduplicationMethod == DeduplicationMethod.MESSAGE_ID) {
                scriptedDeduplicationSuffix = "Enter description here...\n[DO NOT MODIFY - Automate Custom Deduplication Method: Message ID]\n";
            } else if (this.deduplicationMethod == DeduplicationMethod.MESSAGE_ID_MD5) {
                scriptedDeduplicationSuffix = "Enter description here...\n[DO NOT MODIFY - Automate Custom Deduplication Method: Message ID MD5]\n";
            } else if (this.deduplicationMethod == DeduplicationMethod.MESSAGE_ID_MD5_CUSTODIAN) {
                scriptedDeduplicationSuffix = "Enter description here...\n[DO NOT MODIFY - Automate Custom Deduplication Method: Message ID MD5 per Custodian]\n";
            } else if (this.deduplicationMethod == DeduplicationMethod.MAPI_SEARCH_KEY) {
                scriptedDeduplicationSuffix = "Enter description here...\n[DO NOT MODIFY - Automate Custom Deduplication Method: Mapi Search Key]\n";
            }
            try {
                this.itemSetDescription = this.executionContext.evalParameters(this.itemSetDescription, this);
            }
            catch (ParameterException e) {
                this.addWarning(e.getLocalizedMessage());
            }
            this.itemSet.setDescription(this.itemSetDescription + scriptedDeduplicationSuffix);
        } else {
            requiredNuixVersion = new Version("7.0.0");
            int requiredVersionSatisfied = this.executionContext.nuixVersion.compareTo(requiredNuixVersion);
            if (requiredVersionSatisfied >= 0) {
                String nuixDeduplicationMethod;
                Map itemSetSettings = this.itemSet.getSettings();
                if (!itemSetSettings.get("deduplicateBy").equals(this.deduplicateBy.toNuixString())) {
                    DeduplicateBy conflictingDeduplicateBy = DeduplicateBy.getDeduplicateBy(itemSetSettings.get("deduplicateBy").toString());
                    Object warning = "Existing item set conflicting setting took precedence - Deduplicate items: ";
                    warning = conflictingDeduplicateBy == null ? (String)warning + String.valueOf(itemSetSettings.get("deduplicateBy")) : (String)warning + String.valueOf((Object)conflictingDeduplicateBy);
                    this.addWarning((String)warning);
                }
                if (!(nuixDeduplicationMethod = itemSetSettings.get("deduplication").toString().toLowerCase()).equals(this.deduplicationMethod.toNuixString().toLowerCase()) && !nuixDeduplicationMethod.equals(this.deduplicationMethod.name().toLowerCase())) {
                    DeduplicationMethod conflictingDeduplicationMethod = DeduplicationMethod.getDeduplicationMethod(itemSetSettings.get("deduplication").toString());
                    String userPrintableConflictingMethod = conflictingDeduplicationMethod == null ? String.valueOf(itemSetSettings.get("deduplication")) : String.valueOf((Object)conflictingDeduplicationMethod);
                    this.addWarning(this.iu.getFormattedString("AddToItemSetOperation.Warning.ConflictingSetting", (Object)userPrintableConflictingMethod));
                }
            }
        }
        if (this.itemSet == null) throw new Exception(this.iu.getFormattedString("AddToItemSetOperation.Exception.ItemSetCreationFailed", (Object)this.itemSetName));
        LOGGER.info("Itemset '" + this.itemSetName + "' found");
        requiredNuixVersion = new Version("7.0.0");
        int requiredVersionSatisfied = this.executionContext.nuixVersion.compareTo(requiredNuixVersion);
        if (requiredVersionSatisfied >= 0) {
            this.itemSetSettings = this.itemSet.getSettings();
            for (Object itemSetSettingKey : this.itemSetSettings.keySet()) {
                try {
                    LOGGER.info("ItemSet property '" + String.valueOf(itemSetSettingKey) + "' has value '" + String.valueOf(this.itemSetSettings.get(itemSetSettingKey)) + "'");
                }
                catch (Exception e) {
                    LOGGER.info("ItemSet property '" + String.valueOf(itemSetSettingKey) + "' has unknown value");
                }
            }
        }
        if (this.itemSetSettings != null) {
            this.itemSetDeduplicationMethod = DeduplicationMethod.getDeduplicationMethod(this.itemSetSettings.get("deduplication").toString());
            if (this.itemSetDeduplicationMethod == DeduplicationMethod.MESSAGE_ID_MD5) {
                if (this.itemSet.getDescription().contains("Custom Deduplication Method: Mapi Search Key")) {
                    this.itemSetDeduplicationMethod = DeduplicationMethod.MAPI_SEARCH_KEY;
                    LOGGER.info("Detected custom scripted deduplication method: " + String.valueOf((Object)this.itemSetDeduplicationMethod));
                } else if (this.itemSet.getDescription().contains("Custom Deduplication Method: Message ID MD5 per Custodian")) {
                    this.itemSetDeduplicationMethod = DeduplicationMethod.MESSAGE_ID_MD5_CUSTODIAN;
                    LOGGER.info("Detected custom scripted deduplication method: " + String.valueOf((Object)this.itemSetDeduplicationMethod));
                } else if (this.itemSet.getDescription().contains("Custom Deduplication Method: Message ID MD5")) {
                    this.itemSetDeduplicationMethod = DeduplicationMethod.MESSAGE_ID_MD5;
                    LOGGER.info("Detected custom scripted deduplication method: " + String.valueOf((Object)this.itemSetDeduplicationMethod));
                } else if (this.itemSet.getDescription().contains("Custom Deduplication Method: Message ID")) {
                    this.itemSetDeduplicationMethod = DeduplicationMethod.MESSAGE_ID;
                    LOGGER.info("Detected custom scripted deduplication method: " + String.valueOf((Object)this.itemSetDeduplicationMethod));
                } else {
                    LOGGER.warn("Cannot detect custom scripted deduplication method, defaulting to: " + String.valueOf((Object)this.itemSetDeduplicationMethod));
                }
            }
            if (this.itemSetDeduplicationMethod != this.deduplicationMethod) {
                this.addWarning(this.iu.getFormattedString("AddToItemSetOperation.Warning.ConflictingSetting", (Object)this.itemSetDeduplicationMethod));
                this.deduplicationMethod = this.itemSetDeduplicationMethod;
            }
        }
        this.addExecutionLog(this.iu.getFormattedString("AddToItemSetOperation.Log.InclusionStrategy", (Object)this.inclusionStrategy));
        CustomDeduplicationField customDeduplicationField = CustomDeduplicationField.getFromDeduplicationMethod(this.itemSetDeduplicationMethod);
        if (customDeduplicationField != null) {
            LOGGER.info("Custom " + String.valueOf((Object)customDeduplicationField) + " Deduplication");
            this.addToItemSetWithCustomFieldDeduplication(customDeduplicationField);
            return;
        } else {
            this.addToItemSetWithNuixDeduplication();
        }
    }

    private void addToItemSetWithNuixDeduplication() throws IOException {
        this.stageCount = 2;
        this.stageId = 0;
        this.stageType = StageType.QUERY;
        this.stageProgress = 0.0;
        new Thread(() -> {
            try {
                LOGGER.info("Applying inclusion strategy " + this.inclusionStrategy.toString());
                switch (this.inclusionStrategy) {
                    case SELECTED_ITEMS: {
                        --this.stageCount;
                        break;
                    }
                    case SELECTED_ITEMS_AND_DESCENDANTS: {
                        this.stageName = this.iu.getString("AddToItemSetOperation.Stage.ApplyingInclusionStrategy");
                        this.items = ItemsUtils.findItemsAndMaterialDescendants(this.items);
                        LOGGER.info("Scope items and descendants :" + this.items.size());
                        ++this.stageId;
                        break;
                    }
                    case TOP_LEVEL_ITEMS: {
                        this.stageName = this.iu.getString("AddToItemSetOperation.Stage.ApplyingInclusionStrategy");
                        this.items = this.executionContext.nuixUtilities.getItemUtility().findTopLevelItems(this.items);
                        LOGGER.info("Scope top-level items: " + this.items.size());
                        ++this.stageId;
                        break;
                    }
                    case TOP_LEVEL_ITEMS_AND_DESCENDANTS: {
                        this.stageName = this.iu.getString("AddToItemSetOperation.Stage.ApplyingInclusionStrategy");
                        this.items = this.executionContext.nuixUtilities.getItemUtility().findFamilies(this.items);
                        LOGGER.info("Scope top-level items and descendants: " + this.items.size());
                        ++this.stageId;
                    }
                }
                this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.InclusionStrategyCount", (long)this.items.size()));
                this.addToItemSetItemsTotal = this.items.size();
                this.addToItemSetItemsProcessed = 0L;
                this.stageType = StageType.DEDUPLICATE;
                this.stageName = this.iu.getString("AddToItemSetOperation.Stage.DeduplicatingItemSet");
                this.addExecutionLog(this.iu.getFormattedString("AddToItemSetOperation.Log.DeduplicateItems", (Object)this.deduplicateBy));
                this.addExecutionLog(this.iu.getFormattedString("AddToItemSetOperation.Log.DeduplicationMethod", (Object)this.deduplicationMethod));
                Hashtable<String, String> itemSetBatchSettings = new Hashtable<String, String>();
                try {
                    this.getUniqueBatchName();
                }
                catch (ParameterException e) {
                    LOGGER.error("Cannot get valid batch name", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                itemSetBatchSettings.put("batch", this.batchName);
                ItemEventCallback callback = itemEventInfo -> {
                    this.addToItemSetItemsStageName = itemEventInfo.getStage();
                    this.addToItemSetItemsProcessed = itemEventInfo.getStageCount();
                };
                itemSetBatchSettings.put("progress", (String)callback);
                LOGGER.info("Adding " + FormattingUtils.itemsCountToDisplay((long)this.items.size()) + " to itemSet");
                this.addItemsToItemSet(this.items, itemSetBatchSettings);
                if (this.deduplicationMethod != DeduplicationMethod.NONE) {
                    long countOriginals = this.executionContext.nuixCase.count("item-set-batch:\"" + this.itemSet.getName() + ";originals;" + this.batchName + "\"");
                    this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.OriginalsCount", countOriginals));
                    long countDuplicates = this.executionContext.nuixCase.count("item-set-batch:\"" + this.itemSet.getName() + ";duplicates;" + this.batchName + "\"");
                    this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.DuplicatesCount", countDuplicates));
                }
                this.trackFinished();
            }
            catch (Exception e) {
                LOGGER.error("Operation unchecked exception");
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        }).start();
    }

    private void addToItemSetWithCustomFieldDeduplication(CustomDeduplicationField customDeduplicationField) throws IOException {
        DeduplicateBy itemSetDeduplicateBy = DeduplicateBy.getDeduplicateBy(this.itemSetSettings.get("deduplicateBy").toString());
        if (itemSetDeduplicateBy == DeduplicateBy.INDIVIDUAL) {
            LOGGER.info("Custom Deduplication by Individual");
            this.addToItemSetWithCustomDeduplicationByIndividual(customDeduplicationField);
        } else {
            LOGGER.info("Custom Deduplication by Family");
            this.addToItemSetWithCustomDeduplicationByFamily(customDeduplicationField);
        }
    }

    private void addToItemSetWithCustomDeduplicationByIndividual(CustomDeduplicationField customDeduplicationField) throws IOException {
        this.stageCount = 3;
        this.stageId = 0;
        this.stageType = StageType.QUERY;
        this.stageProgress = 0.0;
        new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                LOGGER.info("Applying inclusion strategy " + this.inclusionStrategy.toString());
                switch (this.inclusionStrategy) {
                    case SELECTED_ITEMS: {
                        --this.stageCount;
                        break;
                    }
                    case SELECTED_ITEMS_AND_DESCENDANTS: {
                        this.stageName = this.iu.getString("AddToItemSetOperation.Stage.ApplyingInclusionStrategy");
                        this.items = ItemsUtils.findItemsAndMaterialDescendants(this.items);
                        LOGGER.info("Scope items and descendants :" + this.items.size());
                        ++this.stageId;
                        break;
                    }
                    case TOP_LEVEL_ITEMS: {
                        this.stageName = this.iu.getString("AddToItemSetOperation.Stage.ApplyingInclusionStrategy");
                        this.items = this.executionContext.nuixUtilities.getItemUtility().findTopLevelItems(this.items);
                        LOGGER.info("Scope top-level items: " + this.items.size());
                        ++this.stageId;
                        break;
                    }
                    case TOP_LEVEL_ITEMS_AND_DESCENDANTS: {
                        this.stageName = this.iu.getString("AddToItemSetOperation.Stage.ApplyingInclusionStrategy");
                        this.items = this.executionContext.nuixUtilities.getItemUtility().findFamilies(this.items);
                        LOGGER.info("Scope top-level items and descendants: " + this.items.size());
                        ++this.stageId;
                    }
                }
                this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.InclusionStrategyCount", (long)this.items.size()));
                Hashtable<String, Object> itemSetBatchSettings = new Hashtable<String, Object>();
                try {
                    this.getUniqueBatchName();
                }
                catch (ParameterException e) {
                    LOGGER.error("Cannot get valid batch name", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                itemSetBatchSettings.put("batch", this.batchName);
                ItemEventCallback callback = itemEventInfo -> {
                    this.addToItemSetItemsStageName = itemEventInfo.getStage();
                    this.addToItemSetItemsProcessed = itemEventInfo.getStageCount();
                };
                itemSetBatchSettings.put("progress", callback);
                CustomItemExpression customItemExpression = new CustomItemExpression(this.deduplicateBy, customDeduplicationField);
                itemSetBatchSettings.put("expression", customItemExpression);
                this.addToItemSetItemsTotal = this.items.size();
                this.addToItemSetItemsProcessed = 0L;
                this.stageName = this.iu.getString("AddToItemSetOperation.Stage.DeduplicatingItemSet");
                this.stageType = StageType.DEDUPLICATE;
                this.addExecutionLog(this.iu.getFormattedString("AddToItemSetOperation.Log.DeduplicateItems", (Object)this.deduplicateBy));
                this.addExecutionLog(this.iu.getFormattedString("AddToItemSetOperation.Log.DeduplicationMethod", (Object)this.deduplicationMethod));
                LOGGER.info("Adding " + FormattingUtils.itemsCountToDisplay((long)this.items.size()) + " to itemSet");
                this.itemSet.addItems(this.items, itemSetBatchSettings);
                if (this.deduplicationMethod != DeduplicationMethod.NONE) {
                    long countOriginals = this.executionContext.nuixCase.count("item-set-batch:\"" + this.itemSet.getName() + ";originals;" + this.batchName + "\"");
                    this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.OriginalsCount", countOriginals));
                    long countDuplicates = this.executionContext.nuixCase.count("item-set-batch:\"" + this.itemSet.getName() + ";duplicates;" + this.batchName + "\"");
                    this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.DuplicatesCount", countDuplicates));
                }
                this.trackFinished();
            }
            catch (Exception e) {
                LOGGER.error("Operation unchecked exception");
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        }).start();
    }

    private void addToItemSetWithCustomDeduplicationByFamily(CustomDeduplicationField customDeduplicationField) throws IOException {
        new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                if (this.usingLegacyWorkaround()) {
                    this.nonTopLevelItems = new HashSet<Item>();
                    this.topLevelItems = this.executionContext.nuixCase.searchUnsorted(NuixUtils.addAndQuery(this.scope, "flag:top_level has-exclusion:0"));
                    LOGGER.info("Scope TL items: " + this.topLevelItems.size());
                    this.nonTopLevelItems = this.executionContext.nuixCase.searchUnsorted(NuixUtils.addAndQuery(this.scope, "!flag:top_level has-exclusion:0"));
                    LOGGER.info("Scope nonTL items: " + this.nonTopLevelItems.size());
                } else {
                    LOGGER.info("Scope items: " + this.items.size());
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while searching for items", (Throwable)e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
            try {
                this.stageCount = 4;
                this.stageId = 0;
                this.stageType = StageType.QUERY;
                this.stageProgress = 0.0;
                this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.InclusionStrategyCount", (long)this.items.size()));
                LOGGER.info("Building dictionary");
                this.stageName = this.iu.getString("AddToItemSetOperation.Stage.BuildingDictionary");
                this.itemsProcessed.set(0L);
                this.stageTotalCount = this.items.size();
                Hashtable<String, Object> itemSetBatchSettings = new Hashtable<String, Object>();
                try {
                    if (this.usingLegacyWorkaround()) {
                        this.getUniqueBatchName(new String[]{" TL", " NonTL"});
                    } else {
                        this.getUniqueBatchName();
                    }
                }
                catch (ParameterException e) {
                    LOGGER.error("Cannot get valid batch name", (Throwable)e);
                    this.exception = e;
                    this.executionState = ExecutionState.ERROR;
                    return;
                }
                ItemEventCallback callback = itemEventInfo -> {
                    this.addToItemSetItemsStageName = itemEventInfo.getStage();
                    this.addToItemSetItemsProcessed = itemEventInfo.getStageCount();
                };
                itemSetBatchSettings.put("progress", callback);
                CustomItemExpression customItemExpression = new CustomItemExpression(this.deduplicateBy, customDeduplicationField);
                itemSetBatchSettings.put("expression", customItemExpression);
                if (this.usingLegacyWorkaround()) {
                    itemSetBatchSettings.put("batch", this.batchName + " TL");
                    LOGGER.info("Adding topLevelItems " + FormattingUtils.itemsCountToDisplay((long)this.topLevelItems.size()) + " to itemSet");
                    this.addToItemSetItemsTotal = this.topLevelItems.size();
                } else {
                    itemSetBatchSettings.put("batch", this.batchName);
                    LOGGER.info("Adding items " + FormattingUtils.itemsCountToDisplay((long)this.items.size()) + " to itemSet");
                    this.addToItemSetItemsTotal = this.items.size();
                }
                this.addToItemSetItemsProcessed = 0L;
                this.stageType = StageType.DEDUPLICATE;
                this.stageName = this.iu.getString("AddToItemSetOperation.Stage.DeduplicatingItemSet");
                this.addExecutionLog(this.iu.getFormattedString("AddToItemSetOperation.Log.DeduplicateItems", (Object)this.deduplicateBy));
                this.addExecutionLog(this.iu.getFormattedString("AddToItemSetOperation.Log.DeduplicationMethod", (Object)this.deduplicationMethod));
                if (this.usingLegacyWorkaround()) {
                    this.itemSet.addItems(this.topLevelItems, itemSetBatchSettings);
                    LOGGER.info("Finished adding topLevelItems " + FormattingUtils.itemsCountToDisplay((long)this.topLevelItems.size()) + " to itemSet");
                } else {
                    this.itemSet.addItems(this.items, itemSetBatchSettings);
                    LOGGER.info("Finished adding items " + FormattingUtils.itemsCountToDisplay((long)this.items.size()) + " to itemSet");
                }
                ++this.stageId;
                this.addToItemSetItemsStageName = null;
                if (this.usingLegacyWorkaround() && this.nonTopLevelItems != null) {
                    this.addToItemSetItemsTotal = this.nonTopLevelItems.size();
                    this.addToItemSetItemsProcessed = 0L;
                    this.stageName = this.iu.getString("AddToItemSetOperation.Stage.DeduplicatingItemSet");
                    this.stageType = StageType.DEDUPLICATE;
                    itemSetBatchSettings.put("batch", this.batchName + " NonTL");
                    LOGGER.info("Adding nonTopLevelItems " + FormattingUtils.itemsCountToDisplay((long)this.nonTopLevelItems.size()) + " to itemSet");
                    this.itemSet.addItems(this.nonTopLevelItems, itemSetBatchSettings);
                    LOGGER.info("Finished nonTopLevelItems " + FormattingUtils.itemsCountToDisplay((long)this.nonTopLevelItems.size()) + " to itemSet");
                }
                ++this.stageId;
                if (this.deduplicationMethod != DeduplicationMethod.NONE) {
                    String lastItemSetOriginalsBatch = this.itemSet.getName() + ";originals;" + this.batchName;
                    String lastItemSetDuplicatesBatch = this.itemSet.getName() + ";duplicates;" + this.batchName;
                    if (this.usingLegacyWorkaround()) {
                        long countOriginals = this.executionContext.nuixCase.count("item-set-batch:(\"" + lastItemSetOriginalsBatch + "\" OR \"" + lastItemSetOriginalsBatch + " TL\" OR \"" + lastItemSetOriginalsBatch + " NonTL\")");
                        this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.OriginalsCount", countOriginals));
                        long countDuplicates = this.executionContext.nuixCase.count("item-set-batch:(\"" + lastItemSetDuplicatesBatch + "\" OR \"" + lastItemSetDuplicatesBatch + " TL\" OR \"" + lastItemSetDuplicatesBatch + " NonTL\")");
                        this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.DuplicatesCount", countDuplicates));
                    } else {
                        long countOriginals = this.executionContext.nuixCase.count("item-set-batch:(\"" + lastItemSetOriginalsBatch + "\")");
                        this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.OriginalsCount", countOriginals));
                        long countDuplicates = this.executionContext.nuixCase.count("item-set-batch:(\"" + lastItemSetDuplicatesBatch + "\")");
                        this.addExecutionLog(this.iu.getNumeralString("AddToItemSetOperation.Log.DuplicatesCount", countDuplicates));
                    }
                }
                this.trackFinished();
            }
            catch (Exception e) {
                LOGGER.error("Operation unchecked exception");
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        }).start();
    }

    private void addItemsToItemSet(Set<Item> items, Map itemSetBatchSettings) throws IOException {
        if (items.size() == 0) {
            HashSet<Item> dummyItems = new HashSet<Item>();
            this.addExecutionLog(this.iu.getString("AddToItemSetOperation.Log.RootItemAddedAsDummy"));
            Item rootItem = (Item)this.executionContext.nuixCase.getRootItems().get(0);
            dummyItems.add(rootItem);
            boolean itemSetContainsRootItem = this.itemSet.getBatches().stream().anyMatch(batch -> {
                Collection batchItems = this.itemSet.getItems(batch.getName());
                return batchItems.contains(rootItem);
            });
            this.itemSet.addItems(dummyItems, itemSetBatchSettings);
            if (!itemSetContainsRootItem) {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("removeDuplicates", false);
                this.itemSet.removeItems(dummyItems, options);
            }
        } else {
            this.itemSet.addItems(items, itemSetBatchSettings);
        }
    }

    private void getUniqueBatchName(String[] suffixes) throws ParameterException {
        if (this.batchName.length() == 0) {
            this.batchName = "{date_time_local}";
        }
        String batchNamePrefix = this.batchName = this.executionContext.evalParameters(this.batchName, this);
        boolean batchNameUnique = true;
        for (String suffix : suffixes) {
            batchNameUnique = batchNameUnique && this.batchExists(this.batchName + suffix, this.itemSet) == false;
        }
        int evidenceNameCounter = 1;
        while (!batchNameUnique) {
            LOGGER.warn("Batch name '" + this.batchName + "' is not unique in item set '" + this.itemSetName + "'");
            this.batchName = batchNamePrefix + " " + ++evidenceNameCounter;
            batchNameUnique = true;
            for (String suffix : suffixes) {
                batchNameUnique = batchNameUnique && this.batchExists(this.batchName + suffix, this.itemSet) == false;
            }
        }
    }

    private void getUniqueBatchName() throws ParameterException {
        this.getUniqueBatchName(new String[]{""});
    }

    @Override
    public String getPrintablePercentageComplete() {
        double percentageComplete;
        Object result = "";
        long stageItems = 0L;
        if (this.stageType == StageType.DEDUPLICATE) {
            if (this.addToItemSetItemsStageName != null) {
                this.stageName = FormattingUtils.stageToString((String)this.addToItemSetItemsStageName);
            }
            stageItems = this.addToItemSetItemsProcessed;
        }
        if (!Double.isNaN(percentageComplete = this.getNormalizedPercentageComplete())) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (stageItems > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("AddToItemSetOperation.Progress.ItemsProcessed", stageItems);
        }
        return result;
    }

    private double getAddToItemSetProgress() {
        if (this.addToItemSetItemsStageName == null) {
            return 0.0;
        }
        double percentage = 0.0;
        double stagePercentage = (double)this.addToItemSetItemsProcessed / (double)this.addToItemSetItemsTotal;
        switch (this.addToItemSetItemsStageName) {
            case "item_set_deduplicating": {
                percentage = stagePercentage / 2.0;
                break;
            }
            case "item_set_assigning": {
                percentage = 0.5 + stagePercentage / 2.0;
                break;
            }
        }
        return percentage;
    }

    @Override
    protected double getPercentageComplete() {
        this.stageProgress = 0.0;
        if (this.stageType == StageType.DEDUPLICATE) {
            this.stageProgress = this.getAddToItemSetProgress();
        }
        double percentageComplete = (this.stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    static enum StageType {
        QUERY,
        DEDUPLICATE;

    }
}

