/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionPlatformType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.utilization.consumption.UnitType;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionAbortRequested;
import com.nuix.automate.workflow.core.execution.operations.AnalyzeWithNlpOperation;
import com.nuix.automate.workflow.core.utils.memgraph.DummyGraphUtils;
import com.nuix.automate.workflow.core.utils.memgraph.GraphUtils;
import com.nuix.automate.workflow.core.utils.memgraph.MemgraphUtils;
import com.nuix.automate.workflow.core.utils.nlp.NlpUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nuix.NlpAnalyser;
import nuix.NlpJob;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AnalyzeWithNlpOperationImplementation
extends AnalyzeWithNlpOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AnalyzeWithNlpOperationImplementation.class);
    private transient long itemsInScope;
    private transient String stageName;
    private final transient long NO_PROGRESS_ERROR_SECONDS = 15L;
    private transient long nlpJobStartEpoch;
    private transient String nlpJobStatus;
    private transient long uploadCount;
    private transient long uploadFailed;
    private transient long enrichedCount;
    private transient long enrichmentErrors;
    private transient long downloadCount;
    private transient long downloadFailed;
    private transient long itemsVolume;
    private transient NlpUtils nlpUtils;
    private transient String playbookName;

    private long getLongFromStatus(String name, Map<String, Object> status) {
        Object value = status.get(name);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return 0L;
    }

    private void parseStatusCounts(Map<String, Object> status) {
        this.uploadCount = this.getLongFromStatus("uploadCount", status);
        this.uploadFailed = this.getLongFromStatus("uploadFailed", status);
        this.enrichedCount = this.getLongFromStatus("enrichedCount", status);
        this.enrichmentErrors = this.getLongFromStatus("enrichmentErrors", status);
        this.downloadCount = this.getLongFromStatus("downloadCount", status);
        this.downloadFailed = this.getLongFromStatus("downloadFailed", status);
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("AnalyseWithNlpOperation.Stage.SearchingForItems");
                this.addExecutionLog(this.iu.getString("AnalyseWithNlpOperation.Stage.SearchingForItems"));
                this.addExecutionLog(this.iu.getFormattedString("AnalyseWithNlpOperation.Log.ScopeQuery", (Object)this.scope));
                Set scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.itemsInScope = scopeItems.size();
                this.addExecutionLog(this.iu.getNumeralString("AnalyseWithNlpOperation.Log.ScopeCount", (long)scopeItems.size()));
                if (this.itemsInScope > 0L) {
                    String nlpCredential = this.executionContext.evalProtectedParameter("{wfn_nlp_api_token_protected}");
                    HashMap<String, Object> nlpJobSettings = new HashMap<String, Object>();
                    if (this.updateDuplicates) {
                        this.addExecutionLog(this.iu.getString("AnalyseWithNlpOperation.Log.UpdateDuplicates"));
                    }
                    nlpJobSettings.put("updateDuplicates", this.updateDuplicates);
                    nlpJobSettings.put("nlpCredential", nlpCredential);
                    this.addExecutionLog(this.iu.getFormattedString("AnalyseWithNlpOperation.Log.DictionaryProximityThreshold", (Object)String.valueOf(this.dictionaryProximityThreshold)));
                    nlpJobSettings.put("dictionaryProximityThreshold", this.dictionaryProximityThreshold);
                    this.addExecutionLog(this.iu.getFormattedString("AnalyseWithNlpOperation.Log.SkillsetProximityThreshold", (Object)String.valueOf(this.skillsetProximityThreshold)));
                    nlpJobSettings.put("skillsetProximityThreshold", this.skillsetProximityThreshold);
                    if (this.sendAdditionalMetadata) {
                        this.addExecutionLog(this.iu.getString("AnalyseWithNlpOperation.Log.SendAdditionalMetadata"));
                    }
                    nlpJobSettings.put("sendAdditionalMetadata", this.sendAdditionalMetadata);
                    if (this.includeNamedEntities) {
                        this.addExecutionLog(this.iu.getString("AnalyseWithNlpOperation.Log.IncludeNamedEntities"));
                    }
                    nlpJobSettings.put("includeNamedEntities", this.includeNamedEntities);
                    if (this.useLanguageCode) {
                        nlpJobSettings.put("languageCode", this.languageCode);
                        this.addExecutionLog(this.iu.getFormattedString("AnalyseWithNlpOperation.Log.LanguageCode", (Object)this.languageCode));
                    }
                    GraphUtils memgraphUtils = new DummyGraphUtils();
                    try {
                        if (this.sendEnrichmentToGraph) {
                            this.nlpUtils = new NlpUtils(this.executionContext, this);
                            memgraphUtils = new MemgraphUtils(this.executionContext, this);
                            this.stageName = this.iu.getString("Operation.Stage.Synchronizing");
                            Integer memgraphJobsInFront = memgraphUtils.getLock();
                            if (memgraphJobsInFront.equals(-1)) {
                                this.addExecutionLog(this.iu.getString("GraphPromoteOperation.Log.WaitingOnJobs"));
                            } else if (!memgraphJobsInFront.equals(0)) {
                                this.addExecutionLog(this.iu.getNumeralFormattedString("GraphPromoteOperation.Log.WaitingOnJobs", (long)memgraphJobsInFront.intValue(), new Object[0]));
                            }
                            while (!memgraphJobsInFront.equals(0)) {
                                if (this.stopRequested) {
                                    this.trackStopped();
                                    return;
                                }
                                Thread.sleep(5000L);
                                memgraphJobsInFront = memgraphUtils.getLock();
                            }
                            String playbookFile = this.executionContext.evalParameters("{wfn_memgraph_playbook_file}", this);
                            String playbookContents = FileUtils.readFileWithAutodetectEncoding((File)new File(playbookFile));
                            String fileName = FileUtils.getFileNameWithoutExtension((String)Paths.get(playbookFile, new String[0]).getFileName().toString());
                            this.playbookName = "Automate " + fileName + " " + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
                            this.nlpUtils.createPlaybook(this.playbookName, playbookContents);
                            String memgraphUrl = this.executionContext.evalParameters("{wfn_memgraph_url}", this);
                            URI uri = new URI(memgraphUrl);
                            String memgraphHostname = uri.getHost();
                            int memgraphPort = uri.getPort();
                            String memgraphUsername = "";
                            String memgraphPassword = "";
                            try {
                                memgraphUsername = this.executionContext.evalParametersIfSet("{wfn_memgraph_username}", this);
                                memgraphPassword = this.executionContext.evalParametersIfSet("{wfn_memgraph_password}", this);
                            }
                            catch (ParameterException parameterException) {
                                // empty catch block
                            }
                            try {
                                this.nlpUtils.deleteMemgraphPersistance();
                            }
                            catch (Exception e) {
                                LOGGER.info("Cannot delete previous NLP Memgraph persistance", (Throwable)e);
                            }
                            String graphId = this.nlpUtils.createMemgraphPersistance("Automate " + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)), memgraphHostname, memgraphPort, memgraphUsername, memgraphPassword, this.playbookName);
                            nlpJobSettings.put("graphId", graphId);
                        }
                        this.itemsVolume = this.executionContext.nuixCase.getStatistics().getAuditSize(this.scope);
                        NlpAnalyser nlpAnalyzer = this.executionContext.nuixUtilities.getNlpAnalyser();
                        NlpJob nlpJob = nlpAnalyzer.createJob((Collection)scopeItems, nlpJobSettings);
                        if (nlpJob == null) {
                            throw new UnsupportedOperationException(this.iu.getString("AnalyseWithNlpOperation.Error.NlpAnalyzerNotSupported"));
                        }
                        this.nlpJobStartEpoch = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                        this.addExecutionLog(this.iu.getFormattedString("AnalyseWithNlpOperation.Log.WaitForAnalysis", new Object[0]));
                        while (true) {
                            if (this.stopRequested) {
                                if (nlpJob != null) {
                                    try {
                                        nlpJob.cancel();
                                    }
                                    catch (Exception e) {
                                        LOGGER.error("Cannot stop job", (Throwable)e);
                                    }
                                }
                                this.trackStopped();
                                return;
                            }
                            Map jobStatus = nlpJob.getStatus();
                            if (jobStatus != null) {
                                this.parseStatusCounts(jobStatus);
                                Object jobStatusResponse = jobStatus.get("state");
                                if (jobStatusResponse != null) {
                                    this.nlpJobStatus = jobStatusResponse.toString();
                                    this.stageName = FormattingUtils.constantToCamelCaseFirstUpper((String)this.nlpJobStatus);
                                    if (this.stageName.equalsIgnoreCase("error")) {
                                        if (jobStatus.containsKey("error")) {
                                            String errorMessage = jobStatus.get("error").toString();
                                            if (errorMessage.contains("X509Trust")) {
                                                LOGGER.error("Cannot connect to NLP, " + errorMessage);
                                                errorMessage = this.iu.getFormattedString("AnalyseWithNlpOperation.Error.CertificateNotTrusted", (Object)System.getProperty("java.home"));
                                            }
                                            this.exception = new IllegalStateException(errorMessage);
                                        } else {
                                            this.exception = new IllegalStateException(SerializationUtils.toJson((Object)jobStatus));
                                        }
                                        this.executionState = ExecutionState.ERROR;
                                        return;
                                    }
                                    if (this.stageName.equalsIgnoreCase("completed")) {
                                        this.handleErrors();
                                        this.trackFinished();
                                        return;
                                    }
                                }
                            }
                            Thread.sleep(1000L);
                        }
                    }
                    finally {
                        memgraphUtils.releaseLock();
                        this.closeNlpMemgraph();
                    }
                }
                this.handleErrors();
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
                return;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    private void closeNlpMemgraph() {
        if (this.nlpUtils != null && this.sendEnrichmentToGraph) {
            try {
                this.nlpUtils.deleteMemgraphPersistance();
            }
            catch (IOException e) {
                LOGGER.error("Cannot delete NLP Memgraph persistance", (Throwable)e);
                this.addWarning(this.iu.getFormattedString("AnalyseWithNlpOperation.Log.CannotCleanUpGraph", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            }
            if (this.playbookName != null) {
                try {
                    this.nlpUtils.deletePlaybook(this.playbookName);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot delete NLP Playbook", (Throwable)e);
                    this.addWarning(this.iu.getFormattedString("AnalyseWithNlpOperation.Log.CannotCleanUpGraph", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                }
            }
        }
    }

    private void handleErrors() {
        this.addExecutionLog(this.iu.getFormattedString("AnalyseWithNlpOperation.Log.UploadedCount", (Object)this.iu.getNumeralString("General.Count.Items", this.uploadCount)));
        if (this.uploadFailed > 0L) {
            this.addWarning(this.iu.getNumeralString("AnalyseWithNlpOperation.Warning.UploadError", this.uploadFailed));
        }
        this.addExecutionLog(this.iu.getFormattedString("AnalyseWithNlpOperation.Log.EnrichedCount", (Object)this.iu.getNumeralString("General.Count.Items", this.downloadCount)));
        if (this.enrichmentErrors > 0L) {
            this.addWarning(this.iu.getNumeralString("AnalyseWithNlpOperation.Warning.EnrichmentError", this.enrichmentErrors));
        }
        this.addExecutionLog(this.iu.getFormattedString("AnalyseWithNlpOperation.Log.DownloadedCount", (Object)this.iu.getNumeralString("General.Count.Items", this.enrichedCount)));
        if (this.downloadFailed > 0L) {
            this.addWarning(this.iu.getNumeralString("AnalyseWithNlpOperation.Warning.DownloadError", this.downloadFailed));
        }
    }

    @Override
    public synchronized void updateState() {
        if (this.nlpJobStartEpoch > 0L) {
            long elapsedMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.nlpJobStartEpoch;
            long minutes = elapsedMillis / 1000L / 60L;
            if ((this.nlpJobStatus == null || this.nlpJobStatus.equalsIgnoreCase("Unknown")) && elapsedMillis > 15000L) {
                this.exception = new WorkflowExecutionAbortRequested(this.iu.getFormattedString("AnalyseWithNlpOperation.Error.NoProgress", (Object)this.iu.getNumeralString("AnalyseWithNlpOperation.Error.NoProgressFirstMinutes", minutes)));
                this.executionState = ExecutionState.ERROR;
                this.stopRequested = true;
            }
        }
    }

    @Override
    protected double getPercentageComplete() {
        if (this.itemsInScope == 0L) {
            return 1.0E-4;
        }
        double result = (double)(this.uploadCount + this.enrichedCount + this.downloadCount) / ((double)this.itemsInScope * 3.0);
        return Math.max(1.0E-4, Math.min(result, 0.9999));
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = -1.0;
        percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.downloadCount > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("General.Count.Items", this.downloadCount);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            String formattedStageName = FormattingUtils.constantUppercaseToUserPrintable((String)(this.stageName + "..."));
            result = (String)result + formattedStageName;
        }
        return result;
    }

    @Override
    public Consumption getOperationConsumption() {
        Consumption consumption = new Consumption();
        ConsumptionEvent consumptionEvent = new ConsumptionEvent();
        consumptionEvent.setConsumptionEventId(UidUtils.getRandom());
        consumptionEvent.setLicenseId(this.executionContext.licenceSession.getLicenceInfo().getId());
        consumptionEvent.setConsumptionStartEpoch(this.startDateTime.getMillis());
        if (this.finishedDateTime != null) {
            consumptionEvent.setConsumptionEndEpoch(this.finishedDateTime.getMillis());
        } else {
            consumptionEvent.setConsumptionEndEpoch(this.startDateTime.getMillis());
        }
        consumptionEvent.setPlatformType(ConsumptionPlatformType.NUIX_NLP);
        try {
            String nlpHostname = this.executionContext.evalParameters("{wfn_nlp_url}", this);
            consumptionEvent.setPlatformId(nlpHostname);
        }
        catch (ParameterException e) {
            LOGGER.error("Cannot evaluate NLP hostname", (Throwable)e);
        }
        consumptionEvent.setConsumptionType(ConsumptionType.DATA_LOADED);
        consumptionEvent.setUnitType(UnitType.AUDITED_BYTES);
        consumptionEvent.setUnits(this.itemsVolume);
        if (this.executionContext.getEngine() != null) {
            consumptionEvent.setJobId(this.executionContext.getEngine().getJobId());
        }
        consumption.add(consumptionEvent);
        return consumption;
    }
}

