/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.DatasetMetadata;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.AssignDataSetMetadataOperation;
import com.nuix.automate.workflow.core.execution.operations.DatasetOperation;
import com.nuix.automate.workflow.core.execution.workflow.DatasetUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import nuix.BulkAnnotater;
import nuix.Item;

public class AssignDataSetMetadataOperationImplementation
extends AssignDataSetMetadataOperation
implements DatasetOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AssignDataSetMetadataOperation.class);
    private transient long stageItems;
    private transient AtomicLong processedItems;
    private transient AtomicLong failedTagItems;
    private transient AtomicLong failedMetadataItems;
    private transient int stageId;
    private transient int stageCount;
    private transient Map<String, DatasetMetadata> datasetsMetadata;
    private transient Map<String, Item> pathToItem;
    private transient BulkAnnotater bulkAnnotater;
    private transient String finalEffectiveTagPrefix;

    private Item getItemWithRelativePath(String relativePath, Collection<Item> rootItemsChildren) {
        block4: {
            block3: {
                Item item = this.pathToItem.get(relativePath);
                if (item != null) {
                    return item;
                }
                String[] pathSplits = DatasetUtils.getRelativePathSplit(relativePath);
                if (pathSplits.length <= 1) break block3;
                CharSequence[] parentPathSplits = Arrays.copyOfRange(pathSplits, 0, pathSplits.length - 1);
                String parentPath = String.join((CharSequence)"\\", parentPathSplits);
                Item parentItem = this.getItemWithRelativePath(parentPath, rootItemsChildren);
                if (parentItem == null) break block4;
                for (Item child : parentItem.getChildren()) {
                    if (!child.getName().equals(pathSplits[pathSplits.length - 1])) continue;
                    this.pathToItem.put(relativePath, child);
                    return child;
                }
                break block4;
            }
            for (Item rootItemChild : rootItemsChildren) {
                if (!rootItemChild.getName().equals(relativePath)) continue;
                this.pathToItem.put(relativePath, rootItemChild);
                return rootItemChild;
            }
        }
        return null;
    }

    private void assignHashes(Item item, Map<String, Map<String, String>> fileHashes) {
        if (fileHashes != null) {
            try {
                String query = NuixUtils.addAndQuery(this.scope, "guid:" + item.getGuid());
                Set items = this.executionContext.nuixCase.searchUnsorted(query);
                for (Item evidenceItem : items) {
                    String datasetRelativePath = DatasetUtils.getRelativePathForDatasetItem(evidenceItem);
                    Map<String, String> evidenceItemHashes = fileHashes.get(datasetRelativePath);
                    if (evidenceItemHashes == null) continue;
                    for (String algorithm : evidenceItemHashes.keySet()) {
                        String hashValue = evidenceItemHashes.get(algorithm).toLowerCase();
                        evidenceItem.getCustomMetadata().put((Object)("Upload " + algorithm), (Object)hashValue);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot search for items", (Throwable)e);
                this.addWarning(e.getMessage());
            }
        }
    }

    private void assignMetadata(Item item, List<String> metadataHeaders, List<String> metadataValues) {
        String query = NuixUtils.addAndQuery(this.scope, "guid:" + item.getGuid());
        try {
            Set items = this.executionContext.nuixCase.searchUnsorted(query);
            this.assignMetadata(items, metadataHeaders, metadataValues);
        }
        catch (IOException e) {
            LOGGER.error("Cannot search for items", (Throwable)e);
            this.addWarning(e.getMessage());
        }
    }

    private void assignMetadata(Collection<Item> items, List<String> metadataHeaders, List<String> metadataValues) {
        if (items == null || items.size() == 0) {
            return;
        }
        for (int i = 0; i < metadataHeaders.size() && metadataValues.size() > i; ++i) {
            String metadata = metadataHeaders.get(i);
            if (metadata.equalsIgnoreCase("custodian")) continue;
            String metadataValue = metadataValues.get(i);
            if (this.assignAsCustomMetadata && metadataValue != null) {
                try {
                    this.bulkAnnotater.putCustomMetadata(metadata, (Object)metadataValue, items, null);
                }
                catch (IOException | IllegalArgumentException e) {
                    LOGGER.error("Cannot put custom metadata", (Throwable)e);
                    this.failedMetadataItems.addAndGet(items.size());
                    this.addWarning(e.getMessage());
                }
            }
            if (!this.assignAsTags) continue;
            try {
                if (metadataValue == null || metadataValue.trim().length() <= 0) continue;
                this.bulkAnnotater.addTag(this.finalEffectiveTagPrefix + metadata + "|" + metadataValue, items);
                continue;
            }
            catch (IOException | IllegalArgumentException e) {
                LOGGER.error("Cannot put add tag", (Throwable)e);
                this.failedTagItems.addAndGet(items.size());
                this.addWarning(e.getMessage());
            }
        }
        this.processedItems.addAndGet(items.size());
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.tagPrefix = this.executionContext.evalParameters(this.tagPrefix, this);
        this.executionContext.closeAllTabs();
        Object effectiveTagPrefix = this.tagPrefix;
        if (((String)effectiveTagPrefix).length() > 0 && !((String)effectiveTagPrefix).endsWith("|")) {
            effectiveTagPrefix = (String)effectiveTagPrefix + "|";
        }
        this.stageCount = 1;
        this.stageId = 0;
        this.stageItems = 0L;
        this.processedItems = new AtomicLong(0L);
        this.failedTagItems = new AtomicLong(0L);
        this.failedMetadataItems = new AtomicLong(0L);
        this.pathToItem = new HashMap<String, Item>();
        this.finalEffectiveTagPrefix = effectiveTagPrefix;
        this.startTriggerThread = new Thread(() -> {
            try {
                Set scopeItems = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.stageItems = scopeItems.size();
                this.addExecutionLog(this.iu.getFormattedString("DetectAndAssignCustodiansOperation.Log.ScopeQuery", (Object)this.scope));
                this.addExecutionLog(this.iu.getNumeralString("DetectAndAssignCustodiansOperation.Log.ScopeCount", (long)scopeItems.size()));
                this.bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                ArrayList<Item> rootItemsChildren = new ArrayList<Item>();
                for (Item rootItem : this.executionContext.nuixCase.getRootItems()) {
                    rootItemsChildren.addAll(rootItem.getChildren());
                }
                for (DatasetMetadata datasetMetadata : this.datasetsMetadata.values()) {
                    List headers = datasetMetadata.getMetadataFieldNames();
                    Map fileHashes = datasetMetadata.getFilesHashes();
                    if (fileHashes != null) {
                        Item item = null;
                        for (String relativePath : fileHashes.keySet()) {
                            if (this.stopRequested) {
                                throw new WorkflowExecutionStopRequested();
                            }
                            item = this.getItemWithRelativePath(relativePath, rootItemsChildren);
                            if (item == null || !scopeItems.contains(item)) continue;
                            this.assignHashes(item, fileHashes);
                        }
                    }
                    if (headers == null) continue;
                    TreeSet fileRelativePathToMetadata = new TreeSet();
                    fileRelativePathToMetadata.addAll(datasetMetadata.getFilesMetadata().keySet());
                    for (String relativePath : fileRelativePathToMetadata) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        Item item = null;
                        switch (datasetMetadata.getMetadataAssignMode()) {
                            case SELF: {
                                item = this.getItemWithRelativePath(relativePath, rootItemsChildren);
                                if (item == null || !scopeItems.contains(item)) break;
                                this.assignMetadata(item, (List<String>)headers, (List<String>)((List)datasetMetadata.getFilesMetadata().get(relativePath)));
                                break;
                            }
                            case SELF_AND_DESCENDANTS: {
                                for (Item rootItemChild : rootItemsChildren) {
                                    if (!relativePath.equalsIgnoreCase(DatasetUtils.getRelativePathForDatasetItem(rootItemChild)) || DatasetUtils.getFileDataSet(this.datasetsMetadata, rootItemChild) != datasetMetadata) continue;
                                    item = rootItemChild;
                                    break;
                                }
                                if (item == null) {
                                    item = this.getItemWithRelativePath(relativePath, rootItemsChildren);
                                }
                                if (item == null) break;
                                ArrayList<Item> itemAndDescendants = new ArrayList<Item>();
                                itemAndDescendants.add(item);
                                itemAndDescendants.addAll(item.getDescendants());
                                itemAndDescendants.retainAll(scopeItems);
                                this.assignMetadata(itemAndDescendants, (List<String>)headers, (List<String>)((List)datasetMetadata.getFilesMetadata().get(relativePath)));
                            }
                        }
                        if (item != null) continue;
                        if (this.assignAsCustomMetadata) {
                            this.failedMetadataItems.addAndGet(1L);
                        }
                        if (!this.assignAsTags) continue;
                        this.failedTagItems.addAndGet(1L);
                    }
                    if (this.assignAsCustomMetadata) {
                        this.addExecutionLog(this.iu.getFormattedString("AssignDataSetMetadataOperation.Log.AssignCustomMetadata", new Object[]{String.join((CharSequence)", ", headers), datasetMetadata.getName()}));
                    }
                    if (!this.assignAsTags) continue;
                    this.addExecutionLog(this.iu.getFormattedString("AssignDataSetMetadataOperation.Log.AssignTags", new Object[]{String.join((CharSequence)", ", headers), this.finalEffectiveTagPrefix, datasetMetadata.getName()}));
                }
                if (rootItemsChildren != null) {
                    rootItemsChildren.clear();
                }
                this.pathToItem.clear();
                if (this.failedTagItems.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("AssignDataSetMetadataOperation.Warning.failedTagItems", this.failedTagItems.get()));
                }
                if (this.failedMetadataItems.get() > 0L) {
                    this.addWarning(this.iu.getNumeralString("AssignDataSetMetadataOperation.Warning.failedMetadataItems", this.failedMetadataItems.get()));
                }
                ++this.stageId;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.processedItems != null) {
            stageProgress = (double)this.processedItems.get() / (double)this.stageItems;
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.processedItems != null && this.processedItems.get() > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("AssignCustomMetadataOperation.Progress.ItemsProcessed", this.processedItems.get());
        }
        return result;
    }

    @Override
    public void setDatasetsMetadata(Map<String, DatasetMetadata> datasetsMetadata) {
        this.datasetsMetadata = datasetsMetadata;
    }
}

