/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.InvestigateIdentifierType;
import com.nuix.automate.workflow.core.execution.operations.AssignFoldersToGroupOperation;
import com.nuix.automate.workflow.core.utils.investigate.Group;
import com.nuix.automate.workflow.core.utils.nuix.CaseFolders;
import com.nuix.automate.workflow.core.utils.nuix.Folder;
import com.nuix.automate.workflow.core.utils.nuix.InvestigateUtils;
import com.nuix.automate.workflow.core.utils.nuix.NuixUtils;
import java.util.List;
import nuix.BulkAnnotater;

public class AssignFoldersToGroupOperationImplementation
extends AssignFoldersToGroupOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AssignFoldersToGroupOperation.class);
    private transient int stageCount;
    private transient int stageId;
    private transient String stageName;
    private transient boolean stopTriggered = false;

    @Override
    public void startTriggered() throws Exception {
        this.startTriggerThread = new Thread(() -> {
            try {
                this.executionContext.closeAllTabs();
                this.stageCount = this.securedFolderGroups.size();
                this.stageId = 0;
                BulkAnnotater bulkAnnotater = this.executionContext.nuixUtilities.getBulkAnnotater();
                CaseFolders caseFolders = NuixUtils.getCaseFolders(this.executionContext);
                for (Object[] securedFolderGroup : this.securedFolderGroups) {
                    if (this.stopTriggered) {
                        this.executionState = ExecutionState.STOPPED;
                        return;
                    }
                    String folderName = securedFolderGroup[0].toString().trim();
                    try {
                        folderName = this.executionContext.evalParameters(folderName, this);
                    }
                    catch (ParameterException e) {
                        this.addWarning(e.getLocalizedMessage());
                    }
                    InvestigateIdentifierType investigateIdentifierType = InvestigateIdentifierType.valueOf((String)securedFolderGroup[1].toString());
                    String investigateIdentifier = securedFolderGroup[2].toString().trim();
                    try {
                        investigateIdentifier = this.executionContext.evalParameters(investigateIdentifier, this);
                    }
                    catch (ParameterException e) {
                        this.addWarning(e.getLocalizedMessage());
                    }
                    if (folderName.length() == 0) {
                        throw new IllegalArgumentException(this.iu.getString("ItemsSecurityOperation.Error.MissingFolderName"));
                    }
                    if (investigateIdentifier.length() == 0) {
                        throw new IllegalArgumentException(this.iu.getString("ItemsSecurityOperation.Error.MissingGroupIdentifier"));
                    }
                    Folder caseFolder = caseFolders.getFolderWithName(folderName);
                    if (caseFolder == null) {
                        throw new IllegalArgumentException(this.iu.getFormattedString("ItemsSecurityOperation.Log.FolderDoesNotExist", (Object)folderName));
                    }
                    String groupName = null;
                    Integer groupId = null;
                    InvestigateUtils investigateUtils = new InvestigateUtils(this.executionContext, this);
                    List<Group> investigateGroups = investigateUtils.getGroups();
                    block5 : switch (investigateIdentifierType) {
                        case NAME: {
                            groupName = investigateIdentifier;
                            for (Group investigateGroup : investigateGroups) {
                                if (!investigateGroup.getName().equals(groupName)) continue;
                                groupId = investigateGroup.getGroupId();
                                break block5;
                            }
                            break;
                        }
                        case ID: {
                            try {
                                groupId = Integer.parseInt(investigateIdentifier);
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException(this.iu.getFormattedString("ItemsSecurityOperation.Error.GroupNotANumber", (Object)groupId));
                            }
                            for (Group investigateGroup : investigateGroups) {
                                if (!investigateGroup.getGroupId().equals(groupId)) continue;
                                groupName = investigateGroup.getName();
                                break block5;
                            }
                            break;
                        }
                    }
                    if (groupId == null) {
                        try {
                            Integer.parseInt(investigateIdentifier);
                            throw new IllegalArgumentException(this.iu.getFormattedString("ItemsSecurityOperation.Error.GroupNotAName", (Object)investigateIdentifier));
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException(this.iu.getFormattedString("ItemsSecurityOperation.Error.CannotFindGroupWithName", (Object)investigateIdentifier));
                        }
                    }
                    if (groupName == null) {
                        throw new IllegalArgumentException(this.iu.getFormattedString("ItemsSecurityOperation.Error.CannotFindGroupWithId", (Object)investigateIdentifier));
                    }
                    caseFolder.getGroupIds().add(groupId);
                    String groupAssignment = SerializationUtils.toJson(caseFolder.getGroupIds());
                    this.executionContext.nuixCase.getCustomMetadata().put("security_list_" + caseFolder.getId(), (Object)groupAssignment, "text", "api", null);
                    investigateUtils.addGroupToCase(groupId, this.executionContext.nuixCase.getGuid().replace("-", ""));
                    this.addExecutionLog(this.iu.getFormattedString("ItemsSecurityOperation.Log.AssignedFolderToGroup", new Object[]{folderName, groupName, groupId}));
                    ++this.stageId;
                }
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void stopTriggered() {
        this.stopTriggered = true;
    }

    @Override
    protected double getPercentageComplete() {
        double percentageComplete = 0.0;
        if (this.stageCount > 0) {
            percentageComplete = (double)this.stageId / (double)this.stageCount;
        }
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        return result;
    }
}

