/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.workflow.core.execution.operations;

import com.nuix.automate.utils.general.AdaptiveThreadPoolExecutorFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.execution.exceptions.WorkflowExecutionStopRequested;
import com.nuix.automate.workflow.core.execution.operations.AssociateGoogleVaultMetadataOperation;
import com.nuix.automate.workflow.core.execution.options.associategooglevaultmetadata.Batch;
import com.nuix.automate.workflow.core.execution.options.associategooglevaultmetadata.Document;
import com.nuix.automate.workflow.core.execution.options.associategooglevaultmetadata.Root;
import com.nuix.automate.workflow.core.execution.options.associategooglevaultmetadata.Serializer;
import com.nuix.automate.workflow.core.execution.options.associategooglevaultmetadata.Tag;
import com.nuix.automate.workflow.core.utils.nuix.ItemsUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import nuix.Item;
import nuix.ItemCustomMetadataMap;
import org.joda.time.DateTime;
import org.openimaj.util.parallel.Parallel;
import org.openimaj.util.parallel.partition.FixedSizeChunkPartitioner;
import org.openimaj.util.parallel.partition.Partitioner;

public class AssociateGoogleVaultMetadataOperationImplementation
extends AssociateGoogleVaultMetadataOperation {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AssociateGoogleVaultMetadataOperation.class);
    private transient AtomicLong processedItems;
    private transient AtomicLong matchedItems;
    private long metadataItemsCount;
    private transient String stageName;
    private transient long stageItems;
    private transient int stageId;
    private transient int stageCount;
    private transient Map<String, List<Tag>> keyToTags;

    private long parseXml(InputStream inputStream) {
        Root root = (Root)Serializer.instance().deserialize(inputStream);
        long count = 0L;
        List<Batch> batches = root.getBatches();
        if (batches == null) {
            batches = new ArrayList<Batch>();
            if (root.getBatch() != null) {
                batches.add(root.getBatch());
            }
        }
        for (Batch batch : batches) {
            for (Document document : batch.getDocuments()) {
                String key = document.getFiles().get(0).getExternalFile().getFilename();
                this.keyToTags.put(key, document.getTags());
            }
            count += (long)batch.getDocuments().size();
        }
        return count;
    }

    private long parseCsv(InputStream inputStream) throws IOException {
        long count = 0L;
        String csvText = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        List csvData = FileUtils.loadVariableColumnCsv((String)csvText);
        String[] columns = new String[((Object[])csvData.get(0)).length];
        for (int i = 0; i < csvData.size(); ++i) {
            Object[] csvLine = (Object[])csvData.get(i);
            if (i == 0) {
                for (int j = 0; j < csvLine.length; ++j) {
                    columns[j] = csvLine[j].toString();
                }
                continue;
            }
            ++count;
            String key = csvLine[0].toString();
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (int j = 1; j < csvLine.length; ++j) {
                Tag tag = new Tag();
                tag.setTagName(columns[j]);
                tag.setTagValue(csvLine[j].toString());
                if (tag.getTagName().startsWith("Date")) {
                    tag.setTagDataType("DateTime");
                } else {
                    tag.setTagDataType("Text");
                }
                tags.add(tag);
            }
            this.keyToTags.put(key, tags);
        }
        return count;
    }

    @Override
    public void startTriggered() throws Exception {
        this.scope = this.executionContext.evalParameters(this.scope, this);
        this.metadataScope = this.executionContext.evalParameters(this.metadataScope, this);
        this.executionContext.closeAllTabs();
        this.stageCount = 2;
        this.stageId = 0;
        this.stageItems = 0L;
        this.keyToTags = new ConcurrentHashMap<String, List<Tag>>();
        this.matchedItems = new AtomicLong(0L);
        this.startTriggerThread = new Thread(() -> {
            try {
                this.stageName = this.iu.getString("AssociateGoogleVaultMetadataOperation.Stage.SearchingForMetadataItems");
                Set metadataItems = this.executionContext.nuixCase.searchUnsorted(this.metadataScope);
                this.processedItems = new AtomicLong(0L);
                this.stageName = this.iu.getString("AssociateGoogleVaultMetadataOperation.Stage.ProcessingMetadataItems");
                this.stageItems = metadataItems.size();
                this.metadataItemsCount = 0L;
                for (Item metadataItem : metadataItems) {
                    long count;
                    if (metadataItem.getName().toLowerCase().endsWith(".xml")) {
                        this.addExecutionLog(this.iu.getFormattedString("AssociateGoogleVaultMetadataOperation.Log.ProcessingMetadataFile", (Object)metadataItem.getName()));
                        try {
                            count = this.parseXml(metadataItem.getBinary().getBinaryData().getInputStream());
                            if (count == 0L) {
                                this.addWarning(this.iu.getFormattedString("AssociateGoogleVaultMetadataOperation.Log.FileDoesNotContainMetadataItems", (Object)metadataItem.getName()));
                            } else {
                                this.metadataItemsCount += count;
                                this.addExecutionLog(this.iu.getNumeralString("AssociateGoogleVaultMetadataOperation.Log.DetectedMetadataItems", count));
                            }
                            this.processedItems.incrementAndGet();
                        }
                        catch (Exception e) {
                            this.addWarning(this.iu.getFormattedString("AssociateGoogleVaultMetadataOperation.Log.CannotProcessMetadataFile", new Object[]{metadataItem.getName(), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                        }
                    }
                    if (!metadataItem.getName().toLowerCase().endsWith(".csv")) continue;
                    this.addExecutionLog(this.iu.getFormattedString("AssociateGoogleVaultMetadataOperation.Log.ProcessingMetadataFile", (Object)metadataItem.getName()));
                    try {
                        count = this.parseCsv(metadataItem.getBinary().getBinaryData().getInputStream());
                        if (count == 0L) {
                            this.addWarning(this.iu.getFormattedString("AssociateGoogleVaultMetadataOperation.Log.FileDoesNotContainMetadataItems", (Object)metadataItem.getName()));
                        } else {
                            this.metadataItemsCount += count;
                            this.addExecutionLog(this.iu.getNumeralString("AssociateGoogleVaultMetadataOperation.Log.DetectedMetadataItems", count));
                        }
                        this.processedItems.incrementAndGet();
                    }
                    catch (Exception e) {
                        this.addWarning(this.iu.getFormattedString("AssociateGoogleVaultMetadataOperation.Log.CannotProcessMetadataFile", new Object[]{metadataItem.getName(), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                    }
                }
                if (this.metadataItemsCount == 0L) {
                    this.addWarning(this.iu.getString("AssociateGoogleVaultMetadataOperation.Log.NoMetadataItems"));
                    this.trackFinished();
                    return;
                }
                this.processedItems = new AtomicLong(0L);
                ++this.stageId;
                this.stageName = this.iu.getString("AssociateGoogleVaultMetadataOperation.Stage.SearchingForItems");
                Set itemsInScope = this.executionContext.nuixCase.searchUnsorted(this.scope);
                this.stageName = this.iu.getString("AssociateGoogleVaultMetadataOperation.Stage.ProcessingItems");
                this.processedItems = new AtomicLong(0L);
                this.stageItems = itemsInScope.size();
                FixedSizeChunkPartitioner partitioner = new FixedSizeChunkPartitioner((Iterable)itemsInScope, ItemsUtils.getPartitionerChunkSize(1000, this));
                Parallel.forEachPartitioned((Partitioner)partitioner, iterator -> {
                    if (this.stopRequested) {
                        throw new WorkflowExecutionStopRequested();
                    }
                    while (iterator.hasNext()) {
                        if (this.stopRequested) {
                            throw new WorkflowExecutionStopRequested();
                        }
                        Item item = (Item)iterator.next();
                        this.processedItems.incrementAndGet();
                        HashSet<String> itemKeys = new HashSet<String>();
                        if (this.handleGoogleMail) {
                            Object messageId;
                            int atIndex;
                            String key;
                            Object mboxFrom = item.getProperties().get("MBOX From Line");
                            if (mboxFrom != null && (key = mboxFrom.toString()).length() > 5 && (atIndex = (key = key.substring(5)).indexOf(64)) > 0) {
                                key = key.substring(0, atIndex);
                                itemKeys.add(key);
                            }
                            if ((messageId = item.getProperties().get("Mapi-Smtp-Message-Id")) == null || messageId.toString().length() == 0) {
                                messageId = item.getProperties().get("Message-ID");
                            }
                            if (messageId != null) {
                                String key2 = messageId.toString();
                                if ((key2 = key2.replace("<", "").replace(">", "")).length() > 0) {
                                    itemKeys.add(key2);
                                }
                            }
                        }
                        if (itemKeys.size() == 0 && this.handleGoogleDrive) {
                            itemKeys.add(item.getName());
                        }
                        for (String key : itemKeys) {
                            List<Tag> itemTags = this.keyToTags.get(key);
                            if (itemTags == null) continue;
                            this.matchedItems.incrementAndGet();
                            ItemCustomMetadataMap itemCustomMetadata = item.getCustomMetadata();
                            for (Tag tag : itemTags) {
                                String value = tag.getTagValue();
                                if (tag.getTagDataType().equals("DateTime")) {
                                    try {
                                        value = DateTime.parse((String)tag.getTagValue());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                itemCustomMetadata.put((Object)tag.getTagName(), (Object)value);
                            }
                        }
                    }
                }, (ThreadPoolExecutor)AdaptiveThreadPoolExecutorFactory.newAdaptiveThreadPoolExecutor());
                if (this.stopRequested) {
                    throw new WorkflowExecutionStopRequested();
                }
                if (this.matchedItems.get() < this.metadataItemsCount) {
                    this.addWarning(this.iu.getNumeralString("AssociateGoogleVaultMetadataOperation.Log.CouldNotMatchRecords", this.metadataItemsCount - this.matchedItems.get()));
                }
                this.addExecutionLog(this.iu.getNumeralString("AssociateGoogleVaultMetadataOperation.Log.AssignMetadata", this.matchedItems.get()));
                ++this.stageId;
                this.trackFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Operation unchecked exception", e);
                this.exception = e;
                this.executionState = ExecutionState.ERROR;
            }
        });
        this.startTriggerThread.setName("Automate - Operation " + this.getOperationName());
        this.startTriggerThread.start();
    }

    @Override
    public void stopTriggered() {
        this.stopRequested = true;
    }

    @Override
    protected double getPercentageComplete() {
        double stageProgress = 0.0;
        if (this.processedItems != null) {
            stageProgress = (double)this.processedItems.get() / (double)this.stageItems;
        }
        double percentageComplete = (stageProgress + (double)this.stageId) / (double)this.stageCount;
        if (this.executionState != ExecutionState.FINISHED) {
            percentageComplete = Math.min(percentageComplete, 0.9999);
        }
        if (this.executionState != ExecutionState.NOT_STARTED) {
            percentageComplete = Math.max(percentageComplete, 1.0E-4);
        }
        return percentageComplete;
    }

    @Override
    public String getPrintablePercentageComplete() {
        Object result = "";
        double percentageComplete = this.getNormalizedPercentageComplete();
        if (!Double.isNaN(percentageComplete)) {
            result = String.format("%.2f%%", percentageComplete * 100.0);
        }
        if (this.stageName != null && this.stageName.length() > 0) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.stageName;
        }
        if (this.stageItems > 0L) {
            if (((String)result).length() > 0) {
                result = (String)result + " / ";
            }
            result = (String)result + this.iu.getNumeralString("AssignCustomMetadataOperation.Progress.ItemsProcessed", this.processedItems.get());
        }
        return result;
    }
}

